/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashSet;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

public class ServiceLoaderUtil {
    private static final MethodType LOAD_CLASS_CLASSLOADER = MethodType.methodType(ServiceLoader.class, Class.class, ClassLoader.class);

    private ServiceLoaderUtil() {
    }

    public static <T> Stream<T> loadServices(Class<T> serviceType, MethodHandles.Lookup lookup) {
        return ServiceLoaderUtil.loadServices(serviceType, lookup, false);
    }

    public static <T> Stream<T> loadServices(Class<T> serviceType, MethodHandles.Lookup lookup, boolean useTccl) {
        return ServiceLoaderUtil.loadServices(serviceType, lookup, useTccl, true);
    }

    static <T> Stream<T> loadServices(Class<T> serviceType, MethodHandles.Lookup lookup, boolean useTccl, boolean verbose) {
        ClassLoader contextClassLoader;
        ClassLoader classLoader = lookup.lookupClass().getClassLoader();
        Stream<Object> services = ServiceLoaderUtil.loadClassloaderServices(serviceType, lookup, classLoader, verbose);
        if (useTccl && (contextClassLoader = LoaderUtil.getThreadContextClassLoader()) != classLoader) {
            services = Stream.concat(services, ServiceLoaderUtil.loadClassloaderServices(serviceType, lookup, contextClassLoader, verbose));
        }
        HashSet classes = new HashSet();
        return services.filter(service -> classes.add(service.getClass()));
    }

    static <T> Stream<T> loadClassloaderServices(Class<T> serviceType, MethodHandles.Lookup lookup, ClassLoader classLoader, boolean verbose) {
        try {
            MethodHandle handle = lookup.findStatic(ServiceLoader.class, "load", LOAD_CLASS_CLASSLOADER);
            ServiceLoader serviceLoader = handle.invokeExact(serviceType, classLoader);
            return serviceLoader.stream().map(provider -> {
                try {
                    return provider.get();
                }
                catch (ServiceConfigurationError e) {
                    if (verbose) {
                        StatusLogger.getLogger().warn("Unable to load service class for service {}", (Object)serviceType, (Object)e);
                    }
                    return null;
                }
            }).filter(Objects::nonNull);
        }
        catch (Throwable e) {
            if (verbose) {
                StatusLogger.getLogger().error("Unable to load services for service {}", (Object)serviceType, (Object)e);
            }
            return Stream.empty();
        }
    }
}

