/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.util.LazyBoolean;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class Constants {
    private static final LazyBoolean isWebApp = new LazyBoolean(() -> PropertiesUtil.getProperties().getBooleanProperty("log4j2.is.webapp", Constants.isClassAvailable("javax.servlet.Servlet") || Constants.isClassAvailable("jakarta.servlet.Servlet")));
    @Deprecated(since="3.0.0", forRemoval=true)
    public static final boolean IS_WEB_APP = Constants.isWebApp();
    private static final LazyBoolean threadLocalsEnabled = new LazyBoolean(() -> !Constants.isWebApp() && PropertiesUtil.getProperties().getBooleanProperty("log4j2.enable.threadlocals", true));
    @Deprecated(since="3.0.0", forRemoval=true)
    public static final boolean ENABLE_THREADLOCALS = Constants.isThreadLocalsEnabled();
    public static final int JAVA_MAJOR_VERSION = Constants.getMajorVersion();
    public static final int MAX_REUSABLE_MESSAGE_SIZE = Constants.size("log4j.maxReusableMsgSize", 518);
    public static final String LOG4J2_DEBUG = "log4j2.debug";
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static boolean isWebApp() {
        return isWebApp.getAsBoolean();
    }

    public static void setWebApp(boolean webApp) {
        isWebApp.setAsBoolean(webApp);
    }

    public static void resetWebApp() {
        isWebApp.reset();
    }

    public static boolean isThreadLocalsEnabled() {
        return threadLocalsEnabled.getAsBoolean();
    }

    public static void setThreadLocalsEnabled(boolean enabled) {
        threadLocalsEnabled.setAsBoolean(enabled);
    }

    public static void resetThreadLocalsEnabled() {
        threadLocalsEnabled.reset();
    }

    private static int size(String property, int defaultValue) {
        return PropertiesUtil.getProperties().getIntegerProperty(property, defaultValue);
    }

    private static boolean isClassAvailable(String className) {
        try {
            return LoaderUtil.loadClass(className) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private Constants() {
    }

    private static int getMajorVersion() {
        return Constants.getMajorVersion(System.getProperty("java.version"));
    }

    static int getMajorVersion(String version) {
        String[] parts = version.split("-|\\.");
        try {
            boolean isJEP223;
            int token = Integer.parseInt(parts[0]);
            boolean bl = isJEP223 = token != 1;
            if (isJEP223) {
                return token;
            }
            return Integer.parseInt(parts[1]);
        }
        catch (Exception ex) {
            return 0;
        }
    }
}

