/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.LowLevelLogUtil;

public class ServiceLoaderUtil {
    public static <S> List<S> loadServices(Class<S> clazz, Function<ModuleLayer, ServiceLoader<S>> loader, Predicate<S> validator) {
        ArrayList<S> services = new ArrayList<S>();
        ModuleLayer moduleLayer = ServiceLoaderUtil.class.getModule().getLayer();
        if (moduleLayer == null) {
            ClassLoader[] classLoaders = LoaderUtil.getClassLoaders();
            Throwable throwable = null;
            ClassLoader errorClassLoader = null;
            for (ClassLoader classLoader : classLoaders) {
                try {
                    ServiceLoader<S> serviceLoader = ServiceLoader.load(clazz, classLoader);
                    for (S service : serviceLoader) {
                        if (services.contains(service) || validator != null && !validator.test(service)) continue;
                        services.add(service);
                    }
                }
                catch (Throwable ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                    errorClassLoader = classLoader;
                }
            }
            if (services.size() == 0 && throwable != null) {
                LowLevelLogUtil.logException("Unable to retrieve provider from ClassLoader " + errorClassLoader, throwable);
            }
        } else {
            ServiceLoader<S> serviceLoader = loader.apply(moduleLayer);
            for (S service : serviceLoader) {
                if (services.contains(service) || validator != null && !validator.test(service)) continue;
                services.add(service);
            }
        }
        return services;
    }
}

