/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.function.Function;
import java.util.function.Supplier;

public final class LazyValue<T>
implements Supplier<T> {
    private static final Object NULL_INSTANCE = new Object();
    private final Supplier<T> supplier;
    private volatile T value;

    private static <T> T nullInstance() {
        return (T)NULL_INSTANCE;
    }

    public static <T> LazyValue<T> from(Supplier<T> supplier) {
        return new LazyValue<T>(supplier);
    }

    public LazyValue(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        T value = this.value;
        if (value == null) {
            LazyValue lazyValue = this;
            synchronized (lazyValue) {
                value = this.value;
                if (value == null) {
                    value = this.supplier.get();
                    this.value = value == null ? LazyValue.nullInstance() : value;
                }
            }
        }
        return value == NULL_INSTANCE ? null : (T)value;
    }

    public void set(T value) {
        this.value = value;
    }

    public <R> LazyValue<R> map(Function<? super T, ? extends R> function) {
        return LazyValue.from(() -> function.apply((T)this.get()));
    }
}

