/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ServiceLoaderUtil;
import org.apache.logging.log4j.util.test.Service;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class ServiceLoaderUtilTest {
    private static final AtomicInteger counter = new AtomicInteger();
    private static final StatusListener listener = new StatusListener(){

        public void close() throws IOException {
        }

        public void log(StatusData data) {
            StackTraceElement stackTraceElement = data.getStackTraceElement();
            if (stackTraceElement.getClassName().startsWith(ServiceLoaderUtil.class.getName())) {
                counter.incrementAndGet();
            }
        }

        public Level getStatusLevel() {
            return Level.WARN;
        }
    };

    @BeforeAll
    public static void installStatusListener() {
        StatusLogger.getLogger().registerListener(listener);
    }

    @AfterAll
    public static void removeStatusListener() {
        StatusLogger.getLogger().removeListener(listener);
    }

    @Test
    public void testBrokenServiceFile() {
        List services = Collections.emptyList();
        int warnings = counter.get();
        try {
            services = ServiceLoaderUtil.loadServices(Service.class, (MethodHandles.Lookup)MethodHandles.lookup(), (boolean)false).collect(Collectors.toList());
        }
        catch (ServiceConfigurationError e) {
            Assertions.fail((Throwable)e);
        }
        Assertions.assertEquals((int)2, (int)services.size());
        Assertions.assertEquals((int)(warnings + 2), (int)counter.get());
    }
}

