/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.ReusableSimpleMessage;
import org.apache.logging.log4j.util.Constants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReusableSimpleMessageTest {
    @Test
    public void testSet_InitializesFormattedMessage() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        msg.set("abc");
        Assertions.assertEquals((Object)"abc", (Object)msg.getFormattedMessage());
    }

    @Test
    public void testGetFormattedMessage_InitiallyStringNull() throws Exception {
        Assertions.assertEquals((Object)"null", (Object)new ReusableSimpleMessage().getFormattedMessage());
    }

    @Test
    public void testGetFormattedMessage_ReturnsLatestSetString() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        msg.set("abc");
        Assertions.assertEquals((Object)"abc", (Object)msg.getFormattedMessage());
        msg.set("def");
        Assertions.assertEquals((Object)"def", (Object)msg.getFormattedMessage());
        msg.set("xyz");
        Assertions.assertEquals((Object)"xyz", (Object)msg.getFormattedMessage());
    }

    @Test
    public void testGetFormat_InitiallyStringNull() throws Exception {
        Assertions.assertNull((Object)new ReusableSimpleMessage().getFormat());
    }

    @Test
    public void testGetFormat_ReturnsLatestSetString() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        msg.set("abc");
        Assertions.assertEquals((Object)"abc", (Object)msg.getFormat());
        msg.set("def");
        Assertions.assertEquals((Object)"def", (Object)msg.getFormat());
        msg.set("xyz");
        Assertions.assertEquals((Object)"xyz", (Object)msg.getFormat());
    }

    @Test
    public void testGetParameters_InitiallyReturnsEmptyArray() throws Exception {
        Assertions.assertArrayEquals((Object[])Constants.EMPTY_OBJECT_ARRAY, (Object[])new ReusableSimpleMessage().getParameters());
    }

    @Test
    public void testGetParameters_ReturnsEmptyArrayAfterMessageSet() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        msg.set("abc");
        Assertions.assertArrayEquals((Object[])Constants.EMPTY_OBJECT_ARRAY, (Object[])msg.getParameters());
        msg.set("def");
        Assertions.assertArrayEquals((Object[])Constants.EMPTY_OBJECT_ARRAY, (Object[])msg.getParameters());
    }

    @Test
    public void testGetThrowable_InitiallyReturnsNull() throws Exception {
        Assertions.assertNull((Object)new ReusableSimpleMessage().getThrowable());
    }

    @Test
    public void testGetThrowable_ReturnsNullAfterMessageSet() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        msg.set("abc");
        Assertions.assertNull((Object)msg.getThrowable());
        msg.set("def");
        Assertions.assertNull((Object)msg.getThrowable());
    }

    @Test
    public void testFormatTo_InitiallyWritesNull() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        StringBuilder sb = new StringBuilder();
        msg.formatTo(sb);
        Assertions.assertEquals((Object)"null", (Object)sb.toString());
    }

    @Test
    public void testFormatTo_WritesLatestSetString() throws Exception {
        ReusableSimpleMessage msg = new ReusableSimpleMessage();
        StringBuilder sb = new StringBuilder();
        msg.formatTo(sb);
        Assertions.assertEquals((Object)"null", (Object)sb.toString());
        sb.setLength(0);
        msg.set("abc");
        msg.formatTo(sb);
        Assertions.assertEquals((Object)"abc", (Object)sb.toString());
        sb.setLength(0);
        msg.set("def");
        msg.formatTo(sb);
        Assertions.assertEquals((Object)"def", (Object)sb.toString());
        sb.setLength(0);
        msg.set("xyz");
        msg.formatTo(sb);
        Assertions.assertEquals((Object)"xyz", (Object)sb.toString());
    }
}

