/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.logging.log4j.message.LocalizedMessageFactory;
import org.apache.logging.log4j.message.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LocalizedMessageFactoryTest {
    @Test
    public void testMessageMarkersDataNo() {
        LocalizedMessageFactory localizedMessageFactory = new LocalizedMessageFactory(ResourceBundle.getBundle("MF", Locale.US));
        Message message = localizedMessageFactory.newMessage("msg1");
        Assertions.assertEquals((Object)"This is test number {0} with string argument {1}.", (Object)message.getFormattedMessage());
    }

    @Test
    public void testMessageMarkersNoDataYes() {
        LocalizedMessageFactory localizedMessageFactory = new LocalizedMessageFactory(ResourceBundle.getBundle("MF", Locale.US));
        Message message = localizedMessageFactory.newMessage("msg1", (Object)1, (Object)"two");
        Assertions.assertEquals((Object)"This is test number 1 with string argument two.", (Object)message.getFormattedMessage());
    }

    @Test
    public void testNewMessage() {
        LocalizedMessageFactory localizedMessageFactory = new LocalizedMessageFactory(ResourceBundle.getBundle("MF", Locale.US));
        Message message = localizedMessageFactory.newMessage("hello_world");
        Assertions.assertEquals((Object)"Hello world.", (Object)message.getFormattedMessage());
    }

    @Test
    public void testNoMatch() {
        LocalizedMessageFactory localizedMessageFactory = new LocalizedMessageFactory(ResourceBundle.getBundle("MF", Locale.US));
        Message message = localizedMessageFactory.newMessage("no match");
        Assertions.assertEquals((Object)"no match", (Object)message.getFormattedMessage());
    }

    @Test
    public void testNoMatchPercentInMessageNoArgsNo() {
        LocalizedMessageFactory localizedMessageFactory = new LocalizedMessageFactory(ResourceBundle.getBundle("MF", Locale.US));
        Message message = localizedMessageFactory.newMessage("C:/Program%20Files/Some%20Company/Some%20Product%20Name/");
        Assertions.assertEquals((Object)"C:/Program%20Files/Some%20Company/Some%20Product%20Name/", (Object)message.getFormattedMessage());
    }

    @Test
    public void testNoMatchPercentInMessageArgsYes() {
        LocalizedMessageFactory localizedMessageFactory = new LocalizedMessageFactory(ResourceBundle.getBundle("MF", Locale.US));
        Message message = localizedMessageFactory.newMessage("C:/Program%20Files/Some%20Company/Some%20Product%20Name/{0}", (Object)"One");
        Assertions.assertEquals((Object)"C:/Program%20Files/Some%20Company/Some%20Product%20Name/One", (Object)message.getFormattedMessage());
    }
}

