/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadContext {
    private static ThreadLocal<Map<String, String>> localMap = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> childValue(Map<String, String> parentValue) {
            return parentValue == null ? null : new HashMap<String, String>(parentValue);
        }
    };
    private static ThreadLocal<Stack<String>> localStack = new InheritableThreadLocal<Stack<String>>(){

        @Override
        protected Stack<String> childValue(Stack<String> parentValue) {
            return parentValue == null ? null : (Stack)parentValue.clone();
        }
    };

    private ThreadContext() {
    }

    public static void put(String key, String value) {
        Map<String, String> map = localMap.get();
        if (map == null) {
            map = new HashMap<String, String>();
            localMap.set(map);
        }
        map.put(key, value);
    }

    public static String get(String key) {
        Map<String, String> map = localMap.get();
        return map == null ? null : map.get(key);
    }

    public static void remove(String key) {
        Map<String, String> map = localMap.get();
        if (map != null) {
            map.remove(key);
        }
    }

    public static void clear() {
        localMap.remove();
    }

    public static boolean containsKey(String key) {
        Map<String, String> map = localMap.get();
        return map == null ? false : map.containsKey(key);
    }

    public static Map<String, String> getContext() {
        Map<String, String> map = localMap.get();
        return map == null ? new HashMap<String, String>() : new HashMap<String, String>(localMap.get());
    }

    public static void clearStack() {
        localStack.remove();
    }

    public static Stack<String> cloneStack() {
        Stack<String> stack = localStack.get();
        return stack == null ? new Stack() : (Stack)stack.clone();
    }

    public static void setStack(Stack<String> stack) {
        localStack.set(stack);
    }

    public static int getDepth() {
        Stack<String> stack = localStack.get();
        return stack == null ? 0 : stack.size();
    }

    public static String pop() {
        Stack<String> s = localStack.get();
        if (s == null || s.isEmpty()) {
            return "";
        }
        return s.pop();
    }

    public static String peek() {
        Stack<String> s = localStack.get();
        if (s == null || s.isEmpty()) {
            return "";
        }
        return s.peek();
    }

    public static void push(String message) {
        Stack<String> stack = localStack.get();
        if (stack == null) {
            stack = new Stack();
        }
        stack.push(message);
    }

    public static void removeStack() {
        localStack.remove();
    }

    public static void setMaxDepth(int maxDepth) {
    }
}

