/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.persistence.impl;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.common.entity.persistence.PersistenceLock;
import org.apache.linkis.manager.dao.LockManagerMapper;
import org.apache.linkis.manager.persistence.LockManagerPersistence;
import org.apache.linkis.manager.util.PersistenceManagerConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public class DefaultLockManagerPersistence
implements LockManagerPersistence {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLockManagerPersistence.class);
    private LockManagerMapper lockManagerMapper;

    public LockManagerMapper getLockManagerMapper() {
        return this.lockManagerMapper;
    }

    public void setLockManagerMapper(LockManagerMapper lockManagerMapper) {
        this.lockManagerMapper = lockManagerMapper;
    }

    @Override
    public Boolean lock(PersistenceLock persistenceLock, Long timeOut) {
        try {
            return this.tryQueueLock(persistenceLock, timeOut);
        }
        catch (Exception e) {
            logger.error("Failed to get queue lock", (Throwable)e);
            if (persistenceLock.getId() > 0) {
                this.unlock(persistenceLock);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryQueueLock(PersistenceLock persistenceLock, Long timeOut) {
        String syncLocker;
        long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)persistenceLock.getLockObject())) {
            return true;
        }
        persistenceLock.setTimeOut(timeOut);
        String string = syncLocker = persistenceLock.getLockObject().intern();
        synchronized (string) {
            this.lockManagerMapper.lock(persistenceLock);
        }
        boolean isLocked = false;
        while (!isLocked && System.currentTimeMillis() - startTime < timeOut) {
            try {
                String string2 = syncLocker;
                synchronized (string2) {
                    isLocked = this.isAcquireLock(persistenceLock);
                    if (isLocked) {
                        syncLocker.notifyAll();
                    } else {
                        syncLocker.wait(PersistenceManagerConf.Distributed_lock_request_interval.intValue());
                    }
                }
            }
            catch (Exception e) {
                logger.info("lock waiting failed, can be retry", (Throwable)e);
            }
        }
        if (!isLocked) {
            logger.error("Failed to get lock by time out {} s", (Object)((System.currentTimeMillis() - startTime) / 1000L));
            this.unlock(persistenceLock);
        }
        return isLocked;
    }

    private boolean isAcquireLock(PersistenceLock persistenceLock) {
        Integer minimumOrder = this.lockManagerMapper.getMinimumOrder(persistenceLock.getLockObject(), persistenceLock.getId());
        return null == minimumOrder || minimumOrder >= persistenceLock.getId();
    }

    @Override
    @Retryable(value={CannotGetJdbcConnectionException.class}, maxAttempts=5, backoff=@Backoff(delay=10000L))
    public void unlock(PersistenceLock persistenceLock) {
        if (persistenceLock.getId() > 0) {
            this.lockManagerMapper.unlock(persistenceLock.getId());
        } else {
            logger.error("Unlock{} id cannot be null", (Object)persistenceLock.getLockObject());
        }
    }

    @Override
    public List<PersistenceLock> getAll() {
        return this.lockManagerMapper.getAll();
    }

    @Override
    public List<PersistenceLock> getTimeOutLocks(Date endDate) {
        return this.lockManagerMapper.getTimeOutLocks(endDate);
    }
}

