/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndKubernetesResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.InstanceResource;
import org.apache.linkis.manager.common.entity.resource.KubernetesResource;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.MemoryResource;
import org.apache.linkis.manager.common.entity.resource.ResourceType;
import org.apache.linkis.manager.common.entity.resource.SpecialResource;
import org.apache.linkis.manager.common.entity.resource.YarnResource;
import org.apache.linkis.manager.common.errorcode.ManagerCommonErrorCodeSummary;
import org.apache.linkis.manager.common.exception.ResourceWarnException;

public abstract class Resource {
    public static Resource initResource(ResourceType resourceType) {
        switch (resourceType) {
            case CPU: {
                return new CPUResource(0);
            }
            case Memory: {
                return new MemoryResource(0L);
            }
            case Load: {
                return new LoadResource(0L, 0);
            }
            case Instance: {
                return new InstanceResource(0);
            }
            case LoadInstance: {
                return new LoadInstanceResource(0L, 0, 0);
            }
            case Yarn: {
                return new YarnResource(0L, 0, 0, "default", "");
            }
            case DriverAndYarn: {
                return new DriverAndYarnResource(new LoadInstanceResource(0L, 0, 0), new YarnResource(0L, 0, 0, "default", ""));
            }
            case Kubernetes: {
                return new KubernetesResource(0L, 0L);
            }
            case DriverAndKubernetes: {
                return new DriverAndKubernetesResource(new LoadInstanceResource(0L, 0, 0), new KubernetesResource(0L, 0L));
            }
            case Special: {
                return new SpecialResource(new HashMap<String, Object>());
            }
            case Default: {
                return new LoadResource(0L, 0);
            }
        }
        throw new ResourceWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_POLICY.getErrorCode(), ManagerCommonErrorCodeSummary.NOT_RESOURCE_POLICY.getErrorDesc());
    }

    public static Resource getZeroResource(Resource resource) {
        if (resource instanceof MemoryResource) {
            return new MemoryResource(0L);
        }
        if (resource instanceof InstanceResource) {
            return new InstanceResource(0);
        }
        if (resource instanceof CPUResource) {
            return new CPUResource(0);
        }
        if (resource instanceof LoadResource) {
            return new LoadResource(0L, 0);
        }
        if (resource instanceof LoadInstanceResource) {
            return new LoadInstanceResource(0L, 0, 0);
        }
        if (resource instanceof YarnResource) {
            return new YarnResource(0L, 0, 0, "default", "");
        }
        if (resource instanceof DriverAndYarnResource) {
            DriverAndYarnResource driverAndYarnResource = (DriverAndYarnResource)resource;
            if (driverAndYarnResource.getYarnResource() != null && driverAndYarnResource.getYarnResource().getQueueName() != null) {
                return new DriverAndYarnResource(new LoadInstanceResource(0L, 0, 0), new YarnResource(0L, 0, 0, driverAndYarnResource.getYarnResource().getQueueName(), ""));
            }
            return new DriverAndYarnResource(new LoadInstanceResource(0L, 0, 0), new YarnResource(0L, 0, 0, "default", ""));
        }
        if (resource instanceof DriverAndKubernetesResource) {
            return new DriverAndKubernetesResource(new LoadInstanceResource(0L, 0, 0), new KubernetesResource(0L, 0L));
        }
        if (resource instanceof SpecialResource) {
            return new SpecialResource(new HashMap<String, Object>());
        }
        throw new ResourceWarnException(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorCode(), MessageFormat.format(ManagerCommonErrorCodeSummary.NOT_RESOURCE_TYPE.getErrorDesc(), resource.getClass()));
    }

    public abstract Resource add(Resource var1);

    public abstract Resource minus(Resource var1);

    public abstract Resource multiplied(Resource var1);

    public abstract Resource multiplied(float var1);

    public abstract Resource divide(Resource var1);

    public abstract Resource divide(int var1);

    public abstract boolean moreThan(Resource var1);

    public abstract boolean caseMore(Resource var1);

    public abstract boolean equalsTo(Resource var1);

    public abstract boolean notLess(Resource var1);

    public abstract boolean less(Resource var1);

    public abstract int compare(Resource var1);

    public abstract String toJson();
}

