/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.MemoryResource;
import org.apache.linkis.manager.common.entity.resource.Resource;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KubernetesResource
extends Resource {
    private final long memory;
    private final long cores;
    private final String namespace;

    private KubernetesResource(Resource r) {
        if (r instanceof KubernetesResource) {
            KubernetesResource t = (KubernetesResource)r;
            this.memory = t.memory;
            this.cores = t.cores;
            this.namespace = t.namespace;
        } else if (r instanceof MemoryResource) {
            MemoryResource m = (MemoryResource)r;
            this.memory = m.getMemory();
            this.cores = 0L;
            this.namespace = "default";
        } else if (r instanceof CPUResource) {
            CPUResource c = (CPUResource)r;
            this.memory = 0L;
            this.cores = c.getCores();
            this.namespace = "default";
        } else {
            this.memory = Long.MAX_VALUE;
            this.cores = Long.MAX_VALUE;
            this.namespace = "default";
        }
    }

    public KubernetesResource() {
        this(Long.MAX_VALUE, Long.MAX_VALUE, "default");
    }

    public KubernetesResource(long memory, long cores, String namespace) {
        this.memory = memory;
        this.cores = cores;
        this.namespace = namespace;
    }

    public KubernetesResource(long memory, long cores) {
        this.memory = memory;
        this.cores = cores;
        this.namespace = "default";
    }

    @Override
    public KubernetesResource add(Resource r) {
        KubernetesResource temp = new KubernetesResource(r);
        return new KubernetesResource(this.memory + temp.memory, this.cores + temp.cores, this.namespace);
    }

    @Override
    public KubernetesResource minus(Resource r) {
        KubernetesResource temp = new KubernetesResource(r);
        return new KubernetesResource(this.memory - temp.memory, this.cores - temp.cores, this.namespace);
    }

    @Override
    public KubernetesResource multiplied(Resource r) {
        KubernetesResource temp = new KubernetesResource(r);
        return new KubernetesResource(this.memory * temp.memory, this.cores * temp.cores, this.namespace);
    }

    @Override
    public KubernetesResource multiplied(float rate) {
        return new KubernetesResource((long)((float)this.memory * rate), Math.round((float)this.cores * rate), this.namespace);
    }

    @Override
    public KubernetesResource divide(Resource r) {
        KubernetesResource temp = new KubernetesResource(r);
        return new KubernetesResource(this.memory / temp.memory, this.cores / temp.cores, this.namespace);
    }

    @Override
    public KubernetesResource divide(int rate) {
        return new KubernetesResource(this.memory / (long)rate, this.cores / (long)rate, this.namespace);
    }

    @Override
    public boolean moreThan(Resource r) {
        KubernetesResource temp = new KubernetesResource(r);
        return this.memory > temp.memory && this.cores > temp.cores;
    }

    @Override
    public boolean caseMore(Resource r) {
        KubernetesResource temp = new KubernetesResource(r);
        return this.memory > temp.memory || this.cores > temp.cores;
    }

    @Override
    public boolean equalsTo(Resource r) {
        KubernetesResource temp = new KubernetesResource(r);
        return this.memory == temp.memory && this.cores == temp.cores;
    }

    @Override
    public boolean notLess(Resource r) {
        KubernetesResource temp = new KubernetesResource(r);
        return this.memory >= temp.memory && this.cores >= temp.cores && this.namespace.equals(temp.namespace);
    }

    @Override
    public boolean less(Resource r) {
        return !this.notLess(r);
    }

    @Override
    public int compare(Resource r) {
        KubernetesResource temp = new KubernetesResource(r);
        if (this.getMemory() > temp.getMemory()) {
            return 1;
        }
        if (this.getMemory() < temp.getMemory()) {
            return -1;
        }
        return Long.compare(this.getCores(), temp.getCores());
    }

    @Override
    public String toJson() {
        return String.format("{\"namespace\":\"%s\",\"memory\":\"%s\",\"cpu\":%d}", this.namespace, ByteTimeUtils.bytesToString((long)this.memory), this.cores);
    }

    public String toString() {
        return this.toJson();
    }

    public long getMemory() {
        return this.memory;
    }

    public long getCores() {
        return this.cores;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

