/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.io.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.CodeLanguageLabel;
import org.apache.linkis.manager.label.entity.engine.ConcurrentEngineConnLabel;
import org.apache.linkis.manager.label.entity.engine.RunType$;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.entity.entrance.LoadBalanceLabel;
import org.apache.linkis.orchestrator.computation.entity.ComputationJobReq;
import org.apache.linkis.orchestrator.computation.entity.ComputationJobReq$;
import org.apache.linkis.orchestrator.domain.JobReq;
import org.apache.linkis.orchestrator.plans.unit.CodeLogicalUnit;
import org.apache.linkis.protocol.utils.TaskUtils$;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.apache.linkis.storage.domain.MethodEntity;
import org.apache.linkis.storage.domain.MethodEntitySerializer$;
import org.apache.linkis.storage.io.conf.IOFileClientConf$;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import org.apache.linkis.storage.utils.StorageUtils$;
import scala.Array$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class IOClientUtils$ {
    public static final IOClientUtils$ MODULE$;
    private final String SUCCESS;
    private final String FAILED;
    private final AtomicInteger idGenerator;
    private final AtomicInteger jobGroupIDGenerator;
    private LabelBuilderFactory labelBuilderFactory;
    private final LoadBalanceLabel loadBalanceLabel;
    private final CodeLanguageLabel codeTypeLabel;
    private final ConcurrentEngineConnLabel conCurrentLabel;
    private final String creator;
    private volatile boolean bitmap$0;

    static {
        new IOClientUtils$();
    }

    private LabelBuilderFactory labelBuilderFactory$lzycompute() {
        IOClientUtils$ iOClientUtils$ = this;
        synchronized (iOClientUtils$) {
            if (!this.bitmap$0) {
                this.labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
                this.bitmap$0 = true;
            }
            return this.labelBuilderFactory;
        }
    }

    public String SUCCESS() {
        return this.SUCCESS;
    }

    public String FAILED() {
        return this.FAILED;
    }

    private AtomicInteger idGenerator() {
        return this.idGenerator;
    }

    private AtomicInteger jobGroupIDGenerator() {
        return this.jobGroupIDGenerator;
    }

    private LabelBuilderFactory labelBuilderFactory() {
        return this.bitmap$0 ? this.labelBuilderFactory : this.labelBuilderFactory$lzycompute();
    }

    private LoadBalanceLabel loadBalanceLabel() {
        return this.loadBalanceLabel;
    }

    private CodeLanguageLabel codeTypeLabel() {
        return this.codeTypeLabel;
    }

    private ConcurrentEngineConnLabel conCurrentLabel() {
        return this.conCurrentLabel;
    }

    private String creator() {
        return this.creator;
    }

    public String generateExecID() {
        return new StringBuilder().append((Object)"io_").append((Object)BoxesRunTime.boxToInteger((int)this.idGenerator().getAndIncrement())).append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString();
    }

    public String generateJobGrupID() {
        return new StringBuilder().append((Object)"io_jobGrup_").append((Object)BoxesRunTime.boxToInteger((int)this.jobGroupIDGenerator().getAndIncrement())).toString();
    }

    public LabelBuilderFactory getLabelBuilderFactory() {
        return this.labelBuilderFactory();
    }

    public LoadBalanceLabel getDefaultLoadBalanceLabel() {
        return this.loadBalanceLabel();
    }

    public Label<?>[] getExtraLabels() {
        Label[] labelArray;
        String labelJson = (String)IOFileClientConf$.MODULE$.IO_EXTRA_LABELS().getValue();
        if (StringUtils.isNotBlank((CharSequence)labelJson)) {
            Map labelMap = (Map)BDPJettyServerHelper$.MODULE$.gson().fromJson(labelJson, Map.class);
            labelArray = (Label[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.labelBuilderFactory().getLabels(labelMap)).asScala()).toArray(ClassTag$.MODULE$.apply(Label.class));
        } else {
            labelArray = (Label[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Label.class));
        }
        return labelArray;
    }

    public void addLabelToParams(Label<?> label, Map<String, Object> params) {
        Map labelMap = TaskUtils$.MODULE$.getLabelsMap(params);
        labelMap.put(label.getLabelKey(), label.getStringValue());
        TaskUtils$.MODULE$.addLabelsMap(params, labelMap);
    }

    public JobReq buildJobReq(String user, MethodEntity methodEntity, Map<String, Object> params) {
        Map labelMap = TaskUtils$.MODULE$.getLabelsMap(params);
        List labels = this.labelBuilderFactory().getLabels(labelMap);
        labels.add(this.codeTypeLabel());
        labels.add(this.conCurrentLabel());
        String string = methodEntity.fsType();
        String string2 = StorageUtils$.MODULE$.HDFS();
        String rootUser = !(string != null ? !string.equals(string2) : string2 != null) ? (String)StorageConfiguration$.MODULE$.HDFS_ROOT_USER().getValue() : (String)StorageConfiguration$.MODULE$.LOCAL_ROOT_USER().getValue();
        UserCreatorLabel userCreatorLabel = (UserCreatorLabel)this.labelBuilderFactory().createLabel(UserCreatorLabel.class);
        userCreatorLabel.setCreator(this.creator());
        userCreatorLabel.setUser(rootUser);
        labels.add(userCreatorLabel);
        String code = MethodEntitySerializer$.MODULE$.serializer(methodEntity);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(code);
        CodeLogicalUnit codeLogicalUnit = new CodeLogicalUnit(codes, this.codeTypeLabel());
        ComputationJobReq.ComputationJobReqBuilder jobReqBuilder = ComputationJobReq$.MODULE$.newBuilder();
        jobReqBuilder.setId(this.generateExecID());
        jobReqBuilder.setSubmitUser(user);
        jobReqBuilder.setExecuteUser((String)StorageConfiguration$.MODULE$.IO_USER().getValue());
        jobReqBuilder.setCodeLogicalUnit(codeLogicalUnit);
        jobReqBuilder.setLabels(labels);
        jobReqBuilder.setParams(params);
        return jobReqBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private IOClientUtils$() {
        void var3_3;
        void var2_2;
        void var1_1;
        MODULE$ = this;
        this.SUCCESS = "SUCCESS";
        this.FAILED = "FAILED";
        this.idGenerator = new AtomicInteger(0);
        this.jobGroupIDGenerator = new AtomicInteger(0);
        LoadBalanceLabel label = (LoadBalanceLabel)this.labelBuilderFactory().createLabel("loadBalance");
        label.setCapacity((String)IOFileClientConf$.MODULE$.IO_LOADBALANCE_CAPACITY().getValue());
        label.setGroupId("ioclient");
        this.loadBalanceLabel = var1_1;
        CodeLanguageLabel label2 = (CodeLanguageLabel)this.labelBuilderFactory().createLabel("codeType");
        label2.setCodeType(RunType$.MODULE$.IO_FILE().toString());
        this.codeTypeLabel = var2_2;
        ConcurrentEngineConnLabel label3 = (ConcurrentEngineConnLabel)this.labelBuilderFactory().createLabel(ConcurrentEngineConnLabel.class);
        label3.setParallelism("10");
        this.conCurrentLabel = var3_3;
        this.creator = (String)StorageConfiguration$.MODULE$.IO_DEFAULT_CREATOR().getValue();
    }
}

