/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.trino.password;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.io.IOUtils;

public class CommandPasswordCallback
extends PasswordCallback {
    private static final Charset CHARSET = Charset.defaultCharset();

    public CommandPasswordCallback(String prompt) {
        this(prompt, false);
    }

    public CommandPasswordCallback(String prompt, boolean echoOn) {
        super(prompt, echoOn);
    }

    private static String string(InputStream inputStream) throws IOException {
        try {
            String string = IOUtils.toString((InputStream)inputStream, (Charset)CHARSET);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    private static char[] array(InputStream inputStream) throws IOException {
        try {
            char[] cArray = IOUtils.toCharArray((InputStream)inputStream, (Charset)CHARSET);
            return cArray;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public char[] getPassword() {
        Process process = null;
        String prompt = this.getPrompt();
        try {
            process = new ProcessBuilder(new String[0]).command(prompt).start();
            int ret = process.waitFor();
            if (ret != 0) {
                throw new RuntimeException(CommandPasswordCallback.string(process.getErrorStream()));
            }
            char[] cArray = CommandPasswordCallback.array(process.getInputStream());
            return cArray;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to authenticate with command: " + prompt, e);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }
}

