/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.trino.executor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.airlift.units.Duration;
import io.trino.client.ClientSession;
import io.trino.client.OkHttpUtil;
import io.trino.client.QueryError;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import io.trino.client.StatementStats;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.SocketFactory;
import javax.security.auth.callback.PasswordCallback;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.OverloadUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.acessible.executor.listener.event.TaskLogUpdateEvent;
import org.apache.linkis.engineconn.common.conf.EngineConnConf$;
import org.apache.linkis.engineconn.common.conf.EngineConnConstant$;
import org.apache.linkis.engineconn.computation.executor.execute.ConcurrentComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.executor.listener.ExecutorListenerBusContext;
import org.apache.linkis.engineconn.executor.listener.ExecutorListenerBusContext$;
import org.apache.linkis.engineplugin.trino.conf.TrinoConfiguration$;
import org.apache.linkis.engineplugin.trino.conf.TrinoEngineConfig$;
import org.apache.linkis.engineplugin.trino.exception.TrinoClientException;
import org.apache.linkis.engineplugin.trino.exception.TrinoStateInvalidException;
import org.apache.linkis.engineplugin.trino.executor.TrinoEngineConnExecutor$;
import org.apache.linkis.engineplugin.trino.interceptor.PasswordInterceptor;
import org.apache.linkis.engineplugin.trino.password.CommandPasswordCallback;
import org.apache.linkis.engineplugin.trino.password.StaticPasswordCallback;
import org.apache.linkis.engineplugin.trino.socket.SocketChannelSocketFactory;
import org.apache.linkis.engineplugin.trino.utils.TrinoCode$;
import org.apache.linkis.engineplugin.trino.utils.TrinoSQLHook$;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.SQLCodeParser;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.engineplugin.common.util.NodeResourceUtils$;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType$;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.springframework.util.CollectionUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\re\u0001\u0002\u0013&\u0001IB\u0001B\u0010\u0001\u0003\u0006\u0004%\te\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0001\"Aq\t\u0001BC\u0002\u0013\u0005q\b\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003A\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001dy\u0005A1A\u0005\nACa\u0001\u001b\u0001!\u0002\u0013\t\u0006b\u00029\u0001\u0005\u0004%I!\u001d\u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003s\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\u0002\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\n\u0011%\tI\u0003\u0001b\u0001\n\u0013\tY\u0003\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA\u0017\u0011%\ti\u0005\u0001b\u0001\n\u0013\ty\u0005\u0003\u0005\u0002X\u0001\u0001\u000b\u0011BA)\u0011\u001d\t\t\b\u0001C!\u0003gBq!a\u001f\u0001\t\u0003\ni\bC\u0004\u0002\u001e\u0002!\t%a(\t\u000f\u0005%\u0006\u0001\"\u0011\u0002,\"9\u0011q\u0017\u0001\u0005B\u0005e\u0006bBAj\u0001\u0011\u0005\u0013Q\u001b\u0005\b\u00037\u0004A\u0011IAo\u0011\u001d\tY\u000f\u0001C!\u0003[Dq!a@\u0001\t\u0003\u0012\t\u0001C\u0004\u0003\n\u0001!\tEa\u0003\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$!9!Q\u0005\u0001\u0005B\t\u001d\u0002b\u0002B\u0015\u0001\u0011%!1\u0006\u0005\b\u0005{\u0001A\u0011\u0002B \u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#BqAa\u0017\u0001\t\u0013\u0011i\u0006C\u0004\u0003f\u0001!IAa\u001a\t\u000f\tU\u0004\u0001\"\u0003\u0003x!9!q\u0010\u0001\u0005B\u0005M\u0004b\u0002BA\u0001\u0011\u0005\u00131\u000f\u0002\u0018)JLgn\\#oO&tWmQ8o]\u0016CXmY;u_JT!AJ\u0014\u0002\u0011\u0015DXmY;u_JT!\u0001K\u0015\u0002\u000bQ\u0014\u0018N\\8\u000b\u0005)Z\u0013\u0001D3oO&tW\r\u001d7vO&t'B\u0001\u0017.\u0003\u0019a\u0017N\\6jg*\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u001a\u0011\u0005QbT\"A\u001b\u000b\u0005Y:\u0014aB3yK\u000e,H/\u001a\u0006\u0003MaR!!\u000f\u001e\u0002\u0017\r|W\u000e];uCRLwN\u001c\u0006\u0003w-\n!\"\u001a8hS:,7m\u001c8o\u0013\tiTGA\u000fD_:\u001cWO\u001d:f]R\u001cu.\u001c9vi\u0006$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s\u0003AyW\u000f\u001e9viB\u0013\u0018N\u001c;MS6LG/F\u0001A!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\rIe\u000e^\u0001\u0012_V$\b/\u001e;Qe&tG\u000fT5nSR\u0004\u0013AA5e\u0003\rIG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007-ke\n\u0005\u0002M\u00015\tQ\u0005C\u0003?\u000b\u0001\u0007\u0001\tC\u0003H\u000b\u0001\u0007\u0001)\u0001\bfq\u0016\u001cW\u000f^8s\u0019\u0006\u0014W\r\\:\u0016\u0003E\u00032AU,Z\u001b\u0005\u0019&B\u0001+V\u0003\u0011)H/\u001b7\u000b\u0003Y\u000bAA[1wC&\u0011\u0001l\u0015\u0002\u0005\u0019&\u001cH\u000f\r\u0002[MB\u00191L\u00193\u000e\u0003qS!!\u00180\u0002\r\u0015tG/\u001b;z\u0015\ty\u0006-A\u0003mC\n,GN\u0003\u0002bW\u00059Q.\u00198bO\u0016\u0014\u0018BA2]\u0005\u0015a\u0015MY3m!\t)g\r\u0004\u0001\u0005\u0013\u001d<\u0011\u0011!A\u0001\u0006\u0003I'aA0%c\u0005yQ\r_3dkR|'\u000fT1cK2\u001c\b%\u0005\u0002k[B\u0011\u0011i[\u0005\u0003Y\n\u0013qAT8uQ&tw\r\u0005\u0002B]&\u0011qN\u0011\u0002\u0004\u0003:L\u0018!E8l\u0011R$\bo\u00117jK:$8)Y2iKV\t!\u000fE\u0003SgV\f\t!\u0003\u0002u'\n\u0019Q*\u00199\u0011\u0005YlhBA<|!\tA()D\u0001z\u0015\tQ\u0018'\u0001\u0004=e>|GOP\u0005\u0003y\n\u000ba\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011AP\u0011\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0011\u0011qA\u0001\b_.DG\u000f\u001e94\u0013\u0011\tY!!\u0002\u0003\u0019=[\u0007\n\u001e;q\u00072LWM\u001c;\u0002%=\\\u0007\n\u001e;q\u00072LWM\u001c;DC\u000eDW\rI\u0001\u0015gR\fG/Z7f]R\u001cE.[3oi\u000e\u000b7\r[3\u0016\u0005\u0005M\u0001#\u0002*tk\u0006U\u0001\u0003BA\f\u0003Gi!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0007G2LWM\u001c;\u000b\u0007!\nyB\u0003\u0002\u0002\"\u0005\u0011\u0011n\\\u0005\u0005\u0003K\tIBA\bTi\u0006$X-\\3oi\u000ec\u0017.\u001a8u\u0003U\u0019H/\u0019;f[\u0016tGo\u00117jK:$8)Y2iK\u0002\n!c\u00197jK:$8+Z:tS>t7)Y2iKV\u0011\u0011Q\u0006\t\b\u0003_\t\t%^A#\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012!B2bG\",'\u0002BA\u001c\u0003s\taaY8n[>t'\u0002BA\u001e\u0003{\taaZ8pO2,'BAA \u0003\r\u0019w.\\\u0005\u0005\u0003\u0007\n\tDA\u0003DC\u000eDW\r\u0005\u0003\u0002\u0018\u0005\u001d\u0013\u0002BA%\u00033\u0011Qb\u00117jK:$8+Z:tS>t\u0017aE2mS\u0016tGoU3tg&|gnQ1dQ\u0016\u0004\u0013!\u00052vS2$wj\u001b%uiB\u001cE.[3oiV\u0011\u0011\u0011\u000b\n\u0007\u0003'\nI&!\u001a\u0007\r\u0005Us\u0002AA)\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0003I\u0011W/\u001b7e\u001f.DE\u000f\u001e9DY&,g\u000e\u001e\u0011\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018V\u0003\u0011a\u0017M\\4\n\t\u0005\r\u0014Q\f\u0002\u0007\u001f\nTWm\u0019;\u0011\u000f\u0005\u001d\u0014QN;\u0002\u00025\u0011\u0011\u0011\u000e\u0006\u0004\u0003W\u001a\u0016\u0001\u00034v]\u000e$\u0018n\u001c8\n\t\u0005=\u0014\u0011\u000e\u0002\t\rVt7\r^5p]\u0006!\u0011N\\5u)\t\t)\bE\u0002B\u0003oJ1!!\u001fC\u0005\u0011)f.\u001b;\u0002\u0017\u0015DXmY;uK2Kg.\u001a\u000b\u0007\u0003\u007f\ny)!'\u0011\t\u0005\u0005\u00151R\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006AQ\r_3dkR,'OC\u0002\u0002\n.\n\u0011b]2iK\u0012,H.\u001a:\n\t\u00055\u00151\u0011\u0002\u0010\u000bb,7-\u001e;f%\u0016\u001c\bo\u001c8tK\"9\u0011\u0011S\tA\u0002\u0005M\u0015!F3oO&tW-\u0012=fGV$xN]\"p]R,\u0007\u0010\u001e\t\u0004i\u0005U\u0015bAALk\t1RI\\4j]\u0016,\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u001cF\u0001\r!^\u0001\u0005G>$W-A\tfq\u0016\u001cW\u000f^3D_6\u0004H.\u001a;fYf$\u0002\"a \u0002\"\u0006\r\u0016Q\u0015\u0005\b\u0003#\u0013\u0002\u0019AAJ\u0011\u0019\tYJ\u0005a\u0001k\"1\u0011q\u0015\nA\u0002U\fQbY8na2,G/\u001a3MS:,\u0017\u0001\u00039s_\u001e\u0014Xm]:\u0015\t\u00055\u00161\u0017\t\u0004\u0003\u0006=\u0016bAAY\u0005\n)a\t\\8bi\"1\u0011QW\nA\u0002U\fa\u0001^1tW&#\u0015aD4fiB\u0013xn\u001a:fgNLeNZ8\u0015\t\u0005m\u0016\u0011\u001b\t\u0006\u0003\u0006u\u0016\u0011Y\u0005\u0004\u0003\u007f\u0013%!B!se\u0006L\b\u0003BAb\u0003\u001bl!!!2\u000b\t\u0005\u001d\u0017\u0011Z\u0001\u0007K:<\u0017N\\3\u000b\u0007\u0005-7&\u0001\u0005qe>$xnY8m\u0013\u0011\ty-!2\u0003\u001f){'\r\u0015:pOJ,7o]%oM>Da!!.\u0015\u0001\u0004)\u0018\u0001C6jY2$\u0016m]6\u0015\t\u0005U\u0014q\u001b\u0005\u0007\u00033,\u0002\u0019A;\u0002\rQ\f7o[%e\u0003E9W\r^#yK\u000e,Ho\u001c:MC\n,Gn\u001d\u000b\u0003\u0003?\u0004BAU,\u0002bB\"\u00111]At!\u0011Y&-!:\u0011\u0007\u0015\f9\u000f\u0002\u0006\u0002jZ\t\t\u0011!A\u0003\u0002%\u00141a\u0018\u00134\u0003E\u0019X\r^#yK\u000e,Ho\u001c:MC\n,Gn\u001d\u000b\u0005\u0003k\ny\u000fC\u0004\u0002r^\u0001\r!a=\u0002\r1\f'-\u001a7t!\u0011\u0011v+!>1\t\u0005]\u00181 \t\u00057\n\fI\u0010E\u0002f\u0003w$1\"!@\u0002p\u0006\u0005\t\u0011!B\u0001S\n\u0019q\f\n\u001b\u0002'M,\b\u000f]8si\u000e\u000bG\u000e\u001c\"bG.dunZ:\u0015\u0005\t\r\u0001cA!\u0003\u0006%\u0019!q\u0001\"\u0003\u000f\t{w\u000e\\3b]\u00069\"/Z9vKN$X\t\u001f9fGR,GMU3t_V\u00148-\u001a\u000b\u0005\u0005\u001b\u0011i\u0002\u0005\u0003\u0003\u0010\teQB\u0001B\t\u0015\u0011\u0011\u0019B!\u0006\u0002\u0011I,7o\\;sG\u0016T1!\u0018B\f\u0015\r\t9\u0004Y\u0005\u0005\u00057\u0011\tB\u0001\u0007O_\u0012,'+Z:pkJ\u001cW\rC\u0004\u0003 e\u0001\rA!\u0004\u0002!\u0015D\b/Z2uK\u0012\u0014Vm]8ve\u000e,\u0017AF4fi\u000e+(O]3oi:{G-\u001a*fg>,(oY3\u0015\u0005\t5\u0011!B4fi&#G#A;\u0002!\u001d,Go\u00117jK:$8+Z:tS>tG\u0003CA#\u0005[\u0011\tDa\u000e\t\r\t=B\u00041\u0001v\u0003\u0011)8/\u001a:\t\u000f\tMB\u00041\u0001\u00036\u0005QA/Y:l!\u0006\u0014\u0018-\\:\u0011\u000bI\u001bX/!\u0017\t\u000f\teB\u00041\u0001\u0003<\u0005A1-Y2iK6\u000b\u0007\u000f\u0005\u0003SgV,\u0018AD4fi\u000e+(O]3oiV\u001bXM\u001d\u000b\u0004k\n\u0005\u0003bBAy;\u0001\u0007!1\t\t\u0006\u0003\u0006u&Q\t\u0019\u0005\u0005\u000f\u0012Y\u0005\u0005\u0003\\E\n%\u0003cA3\u0003L\u0011Y!Q\nB!\u0003\u0003\u0005\tQ!\u0001j\u0005\ryF%N\u0001\u0015S:LG/[1m'R\fG/^:Va\u0012\fG/Z:\u0015\u0011\u0005U$1\u000bB+\u0005/Ba!!7\u001f\u0001\u0004)\bbBAI=\u0001\u0007\u00111\u0013\u0005\b\u00053r\u0002\u0019AA\u000b\u0003%\u0019H/\u0019;f[\u0016tG/A\u0006rk\u0016\u0014\u0018pT;uaV$H\u0003CA;\u0005?\u0012\tGa\u0019\t\r\u0005ew\u00041\u0001v\u0011\u001d\t\tj\ba\u0001\u0003'CqA!\u0017 \u0001\u0004\t)\"A\twKJLg-_*feZ,'/\u0012:s_J$\u0002B!\u001b\u0003p\tE$1\u000f\t\u0005\u0003\u0003\u0013Y'\u0003\u0003\u0003n\u0005\r%\u0001F#se>\u0014X\t_3dkR,'+Z:q_:\u001cX\r\u0003\u0004\u0002Z\u0002\u0002\r!\u001e\u0005\b\u0003#\u0003\u0003\u0019AAJ\u0011\u001d\u0011I\u0006\ta\u0001\u0003+\tQ\"\u001e9eCR,7+Z:tS>tGCBA#\u0005s\u0012i\bC\u0004\u0003|\u0005\u0002\r!!\u0012\u0002\u001b\rd\u0017.\u001a8u'\u0016\u001c8/[8o\u0011\u001d\u0011I&\ta\u0001\u0003+\tqa[5mY\u0006cG.A\u0003dY>\u001cX\r")
public class TrinoEngineConnExecutor
extends ConcurrentComputationExecutor {
    private final int outputPrintLimit;
    private final int id;
    private final List<Label<?>> executorLabels;
    private final Map<String, OkHttpClient> okHttpClientCache;
    private final Map<String, StatementClient> statementClientCache;
    private final Cache<String, ClientSession> clientSessionCache;
    private final Function<String, OkHttpClient> buildOkHttpClient;

    public int outputPrintLimit() {
        return this.outputPrintLimit;
    }

    public int id() {
        return this.id;
    }

    private List<Label<?>> executorLabels() {
        return this.executorLabels;
    }

    private Map<String, OkHttpClient> okHttpClientCache() {
        return this.okHttpClientCache;
    }

    private Map<String, StatementClient> statementClientCache() {
        return this.statementClientCache;
    }

    private Cache<String, ClientSession> clientSessionCache() {
        return this.clientSessionCache;
    }

    private Function<String, OkHttpClient> buildOkHttpClient() {
        return this.buildOkHttpClient;
    }

    public void init() {
        this.setCodeParser((CodeParser)new SQLCodeParser());
        super.init();
    }

    public ExecuteResponse executeLine(EngineExecutionContext engineExecutorContext, String code) {
        boolean enableSqlHook = BoxesRunTime.unboxToBoolean((Object)TrinoConfiguration$.MODULE$.TRINO_SQL_HOOK_ENABLED().getValue());
        String realCode = StringUtils.isBlank((CharSequence)code) ? "SELECT 1" : (enableSqlHook ? TrinoSQLHook$.MODULE$.preExecuteHook(code.trim()) : code.trim());
        TrinoCode$.MODULE$.checkCode(realCode);
        this.logger().info(new StringBuilder(39).append("trino client begins to run psql code:\n ").append(realCode).toString());
        String jobId = JobUtils$.MODULE$.getJobIdFromMap(engineExecutorContext.getProperties());
        realCode = new StringBuilder(18).append("--linkis_task_id=").append(jobId).append("\n").append(realCode).toString();
        String currentUser = this.getCurrentUser(engineExecutorContext.getLabels());
        String trinoUser = (String)Optional.ofNullable(TrinoConfiguration$.MODULE$.TRINO_DEFAULT_USER().getValue()).orElseGet((Supplier<Object>)new Supplier<String>(null, currentUser){
            private final String currentUser$1;

            public String get() {
                return this.currentUser$1;
            }
            {
                this.currentUser$1 = currentUser$1;
            }
        });
        String taskId = (String)engineExecutorContext.getJobId().get();
        ClientSession clientSession = (ClientSession)this.clientSessionCache().get((Object)taskId, (Callable)new Callable<ClientSession>(this, engineExecutorContext, currentUser){
            private final /* synthetic */ TrinoEngineConnExecutor $outer;
            private final EngineExecutionContext engineExecutorContext$1;
            private final String currentUser$1;

            public ClientSession call() {
                Map configMap;
                block0: {
                    Label userCreatorLabel = (Label)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.engineExecutorContext$1.getLabels())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$3.$anonfun$call$1(x$1))).get();
                    Label engineTypeLabel = (Label)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.engineExecutorContext$1.getLabels())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)$anon$3.$anonfun$call$2(x$2))).get();
                    configMap = null;
                    if (userCreatorLabel == null || engineTypeLabel == null) break block0;
                    configMap = (Map)Utils$.MODULE$.tryAndError((Function0 & Serializable & scala.Serializable)() -> TrinoEngineConfig$.MODULE$.getCacheMap(new Tuple2((Object)((UserCreatorLabel)userCreatorLabel), (Object)((EngineTypeLabel)engineTypeLabel))), this.$outer.logger());
                }
                return this.$outer.org$apache$linkis$engineplugin$trino$executor$TrinoEngineConnExecutor$$getClientSession(this.currentUser$1, this.engineExecutorContext$1.getProperties(), configMap);
            }

            public static final /* synthetic */ boolean $anonfun$call$1(Label x$1) {
                return x$1 instanceof UserCreatorLabel;
            }

            public static final /* synthetic */ boolean $anonfun$call$2(Label x$2) {
                return x$2 instanceof EngineTypeLabel;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.engineExecutorContext$1 = engineExecutorContext$1;
                this.currentUser$1 = currentUser$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$call$1$adapted(org.apache.linkis.manager.label.entity.Label ), $anonfun$call$2$adapted(org.apache.linkis.manager.label.entity.Label ), $anonfun$call$3(org.apache.linkis.manager.label.entity.Label org.apache.linkis.manager.label.entity.Label )}, serializedLambda);
            }
        });
        StatementClient statement = StatementClientFactory.newStatementClient((OkHttpClient)this.okHttpClientCache().computeIfAbsent(trinoUser, this.buildOkHttpClient()), (ClientSession)clientSession, (String)realCode);
        this.statementClientCache().put(taskId, statement);
        return (ExecuteResponse)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> {
            ErrorExecuteResponse errorResponse;
            this.initialStatusUpdates(taskId, engineExecutorContext, statement);
            if (statement.isRunning() || statement.isFinished() && statement.finalStatusInfo().getError() == null) {
                this.queryOutput(taskId, engineExecutorContext, statement);
            }
            if ((errorResponse = this.verifyServerError(taskId, engineExecutorContext, statement)) == null) {
                this.clientSessionCache().put((Object)taskId, (Object)this.updateSession(clientSession, statement));
                return new SuccessExecuteResponse();
            }
            return errorResponse;
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.statementClientCache().remove(taskId));
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutorContext, String code, String completedLine) {
        return null;
    }

    public float progress(String taskID) {
        QueryStatusInfo results;
        StatementClient statement = this.statementClientCache().get(taskID);
        if (statement != null && (results = statement.currentStatusInfo()) != null) {
            StatementStats stats = results.getStats();
            if (results != null) {
                return (float)stats.getProgressPercentage().orElse(0.0) / (float)100;
            }
        }
        return 0.0f;
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        QueryStatusInfo results;
        StatementClient statement = this.statementClientCache().get(taskID);
        if (statement != null && (results = statement.currentStatusInfo()) != null) {
            StatementStats stats = results.getStats();
            if (results != null) {
                return (JobProgressInfo[])((Object[])new JobProgressInfo[]{new JobProgressInfo(taskID, stats.getTotalSplits(), stats.getRunningSplits(), 0, stats.getCompletedSplits())});
            }
        }
        return (JobProgressInfo[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(JobProgressInfo.class));
    }

    public void killTask(String taskId) {
        StatementClient statement = this.statementClientCache().remove(taskId);
        Object object = statement != null ? Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> statement.cancelLeafStage(), this.logger()) : BoxedUnit.UNIT;
        super.killTask(taskId);
    }

    public List<Label<?>> getExecutorLabels() {
        return this.executorLabels();
    }

    public void setExecutorLabels(List<Label<?>> labels) {
        if (!CollectionUtils.isEmpty(labels)) {
            this.executorLabels().clear();
            this.executorLabels().addAll(labels);
            return;
        }
    }

    public boolean supportCallBackLogs() {
        return false;
    }

    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return null;
    }

    public NodeResource getCurrentNodeResource() {
        NodeResourceUtils$.MODULE$.appendMemoryUnitIfMissing(EngineConnObject$.MODULE$.getEngineCreationContext().getOptions());
        CommonNodeResource resource = new CommonNodeResource();
        LoadResource usedResource = new LoadResource(OverloadUtils$.MODULE$.getProcessMaxMemory(), 1);
        resource.setUsedResource((Resource)usedResource);
        return resource;
    }

    public String getId() {
        return new StringBuilder(1).append(Sender$.MODULE$.getThisServiceInstance().getInstance()).append("_").append(this.id()).toString();
    }

    public ClientSession org$apache$linkis$engineplugin$trino$executor$TrinoEngineConnExecutor$$getClientSession(String user, Map<String, Object> taskParams, Map<String, String> cacheMap) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(cacheMap)) {
            configMap.putAll(cacheMap);
        }
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(taskParams).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                if (key != null) {
                    Object object;
                    String string = key;
                    if (value != null && (object = value) != null) {
                        return configMap.put(string, String.valueOf(object));
                    }
                }
            }
            return BoxedUnit.UNIT;
        });
        URI httpUri = URI.create((String)TrinoConfiguration$.MODULE$.TRINO_URL().getValue(configMap));
        String source = (String)TrinoConfiguration$.MODULE$.TRINO_SOURCE().getValue(configMap);
        String catalog = (String)TrinoConfiguration$.MODULE$.TRINO_CATALOG().getValue(configMap);
        String schema = (String)TrinoConfiguration$.MODULE$.TRINO_SCHEMA().getValue(configMap);
        Map properties = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(configMap).asScala()).filter((Function1 & Serializable & scala.Serializable)tuple -> BoxesRunTime.boxToBoolean((boolean)TrinoEngineConnExecutor.$anonfun$getClientSession$2(tuple)))).map((Function1 & Serializable & scala.Serializable)tuple -> new Tuple2((Object)((String)tuple._1()).substring("trino.session.".length()), tuple._2()), Map$.MODULE$.canBuildFrom())).asJava();
        String clientInfo = "Linkis";
        String transactionId = null;
        String path = null;
        Optional traceToken = Optional.empty();
        Set clientTags = Collections.emptySet();
        ZoneId timeZonId = TimeZone.getDefault().toZoneId();
        Locale locale = Locale.getDefault();
        Map resourceEstimates = Collections.emptyMap();
        Map preparedStatements = Collections.emptyMap();
        Map roles = Collections.emptyMap();
        Map extraCredentials = Collections.emptyMap();
        boolean compressionDisabled = true;
        Duration clientRequestTimeout = new Duration(0.0, TimeUnit.MILLISECONDS);
        return new ClientSession(httpUri, user, Optional.of(user), source, traceToken, clientTags, clientInfo, catalog, schema, path, timeZonId, locale, resourceEstimates, properties, preparedStatements, roles, extraCredentials, transactionId, clientRequestTimeout, compressionDisabled);
    }

    private String getCurrentUser(Label<?>[] labels) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])labels)).find((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.boxToBoolean((boolean)TrinoEngineConnExecutor.$anonfun$getCurrentUser$1(l))).map((Function1 & Serializable & scala.Serializable)label -> ((UserCreatorLabel)label).getUser()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)TrinoConfiguration$.MODULE$.TRINO_DEFAULT_USER().getValue());
    }

    private void initialStatusUpdates(String taskId, EngineExecutionContext engineExecutorContext, StatementClient statement) {
        boolean isFirstTime = true;
        while (statement.isRunning() && (statement.currentData().getData() == null || statement.currentStatusInfo().getUpdateType() != null)) {
            QueryStatusInfo info = statement.currentStatusInfo();
            if (info != null && isFirstTime) {
                isFirstTime = false;
                engineExecutorContext.appendStdout(LogUtils$.MODULE$.generateInfo(new StringBuilder(17).append("Trino query id:[").append(info.getId()).append("]").toString()));
            }
            engineExecutorContext.pushProgress(this.progress(taskId), this.getProgressInfo(taskId));
            statement.advance();
        }
    }

    private void queryOutput(String taskId, EngineExecutionContext engineExecutorContext, StatementClient statement) {
        Object object = new Object();
        try {
            IntRef columnCount = IntRef.create((int)0);
            IntRef rows = IntRef.create((int)0);
            ResultSetWriter resultSetWriter = engineExecutorContext.createResultSetWriter(ResultSetFactory$.MODULE$.TABLE_TYPE());
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                QueryStatusInfo results = null;
                results = statement.isRunning() ? statement.currentStatusInfo() : statement.finalStatusInfo();
                if (results.getColumns() == null) {
                    this.logger().info(new StringBuilder(34).append("results columns is null for task: ").append(taskId).toString());
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                Column[] columns = (Column[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(results.getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)column -> new Column(column.getName(), DataType$.MODULE$.toDataType(column.getType()), ""), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Column.class));
                if (columns.length != 0) {
                    resultSetWriter.addMetaData((MetaData)new TableMetaData(columns));
                }
                columnCount$1.elem = columns.length;
                while (statement.isRunning()) {
                    Iterable data = statement.currentData().getData();
                    if (data != null) {
                        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(data).asScala()).foreach((Function1 & Serializable & scala.Serializable)row -> {
                            TrinoEngineConnExecutor.$anonfun$queryOutput$3(resultSetWriter, rows, row);
                            return BoxedUnit.UNIT;
                        });
                    }
                    engineExecutorContext.pushProgress(this.progress(taskId), this.getProgressInfo(taskId));
                    statement.advance();
                }
            }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                TrinoEngineConnExecutor.$anonfun$queryOutput$5(resultSetWriter, x0$1);
                return BoxedUnit.UNIT;
            });
            this.logger().info(new StringBuilder(34).append("Fetched ").append(columnCount.elem).append(" col(s) : ").append(rows.elem).append(" row(s) in trino").toString());
            engineExecutorContext.appendStdout(LogUtils$.MODULE$.generateInfo(new StringBuilder(34).append("Fetched ").append(columnCount.elem).append(" col(s) : ").append(rows.elem).append(" row(s) in trino").toString()));
            engineExecutorContext.sendResultSet(resultSetWriter);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private ErrorExecuteResponse verifyServerError(String taskId, EngineExecutionContext engineExecutorContext, StatementClient statement) {
        engineExecutorContext.pushProgress(this.progress(taskId), this.getProgressInfo(taskId));
        if (statement.isFinished()) {
            QueryStatusInfo info = statement.finalStatusInfo();
            if (info.getError() != null) {
                QueryError error = Objects.requireNonNull(info.getError());
                RuntimeException cause = null;
                if (error.getFailureInfo() != null) {
                    cause = error.getFailureInfo().toException();
                }
                engineExecutorContext.appendStdout(LogUtils$.MODULE$.generateERROR(ExceptionUtils.getStackTrace((Throwable)cause)));
                return new ErrorExecuteResponse(ExceptionUtils.getMessage((Throwable)cause), (Throwable)cause);
            }
            return null;
        }
        if (statement.isClientAborted()) {
            this.logger().warn("trino statement is killed.");
            return null;
        }
        if (statement.isClientError()) {
            throw new TrinoClientException("trino client error.");
        }
        throw new TrinoStateInvalidException("trino status error. Statement is not finished.");
    }

    private ClientSession updateSession(ClientSession clientSession, StatementClient statement) {
        ClientSession newSession;
        block5: {
            newSession = clientSession;
            if (statement.getSetCatalog().isPresent() || statement.getSetSchema().isPresent()) {
                newSession = ClientSession.builder((ClientSession)newSession).withCatalog(statement.getSetCatalog().orElse(newSession.getCatalog())).withSchema(statement.getSetSchema().orElse(newSession.getSchema())).build();
            }
            if (statement.isClearTransactionId()) {
                newSession = ClientSession.stripTransactionId((ClientSession)newSession);
            }
            ClientSession.Builder builder = ClientSession.builder((ClientSession)newSession);
            if (statement.getStartedTransactionId() != null) {
                builder = builder.withTransactionId(statement.getStartedTransactionId());
            }
            if (!statement.getSetSessionProperties().isEmpty() || !statement.getResetSessionProperties().isEmpty()) {
                HashMap sessionProperties = new HashMap(newSession.getProperties());
                sessionProperties.putAll(statement.getSetSessionProperties());
                sessionProperties.keySet().removeAll(statement.getResetSessionProperties());
                builder = builder.withProperties(sessionProperties);
            }
            if (!statement.getSetRoles().isEmpty()) {
                HashMap roles = new HashMap(newSession.getRoles());
                roles.putAll(statement.getSetRoles());
                builder = builder.withRoles(roles);
            }
            if (statement.getAddedPreparedStatements().isEmpty() && statement.getDeallocatedPreparedStatements().isEmpty()) break block5;
            HashMap preparedStatements = new HashMap(newSession.getPreparedStatements());
            preparedStatements.putAll(statement.getAddedPreparedStatements());
            preparedStatements.keySet().removeAll(statement.getDeallocatedPreparedStatements());
            builder = builder.withPreparedStatements(preparedStatements);
        }
        return newSession;
    }

    public void killAll() {
        for (StatementClient statement : this.statementClientCache().values()) {
            Object object = statement != null ? Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> statement.cancelLeafStage(), this.logger()) : BoxedUnit.UNIT;
        }
        this.statementClientCache().clear();
    }

    public void close() {
        Iterator<String> taskIds = this.statementClientCache().keySet().iterator();
        ExecutorListenerBusContext lbs = ExecutorListenerBusContext$.MODULE$.getExecutorListenerBusContext();
        while (taskIds.hasNext()) {
            String taskId = taskIds.next();
            Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lbs.getEngineConnSyncListenerBus().postToAll((Event)new TaskLogUpdateEvent(taskId, LogUtils$.MODULE$.generateERROR("EC exits unexpectedly and actively kills the task"))), this.logger());
        }
        this.killAll();
        super.close();
    }

    public static final /* synthetic */ boolean $anonfun$getClientSession$2(Tuple2 tuple) {
        return ((String)tuple._1()).startsWith("trino.session.");
    }

    public static final /* synthetic */ boolean $anonfun$getCurrentUser$1(Label l) {
        return l instanceof UserCreatorLabel;
    }

    public static final /* synthetic */ void $anonfun$queryOutput$3(ResultSetWriter resultSetWriter$1, IntRef rows$1, List row) {
        Buffer rowArray = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(row).asScala()).map((Function1 & Serializable & scala.Serializable)r -> String.valueOf(r), Buffer$.MODULE$.canBuildFrom());
        resultSetWriter$1.addRecord((Record)new TableRecord((Object[])rowArray.toArray(ClassTag$.MODULE$.Any())));
        ++rows$1.elem;
    }

    public static final /* synthetic */ void $anonfun$queryOutput$5(ResultSetWriter resultSetWriter$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            IOUtils.closeQuietly((Closeable)resultSetWriter$1);
            throw exception;
        }
        throw new MatchError((Object)throwable);
    }

    public TrinoEngineConnExecutor(int outputPrintLimit, int id) {
        this.outputPrintLimit = outputPrintLimit;
        this.id = id;
        super(outputPrintLimit);
        this.executorLabels = new ArrayList(2);
        this.okHttpClientCache = new ConcurrentHashMap<String, OkHttpClient>();
        this.statementClientCache = new ConcurrentHashMap<String, StatementClient>();
        this.clientSessionCache = CacheBuilder.newBuilder().expireAfterAccess((long)BoxesRunTime.unboxToInt((Object)EngineConnConf$.MODULE$.ENGINE_TASK_EXPIRE_TIME().getValue()), TimeUnit.MILLISECONDS).maximumSize((long)EngineConnConstant$.MODULE$.MAX_TASK_NUM()).build();
        this.buildOkHttpClient = new Function<String, OkHttpClient>(null){

            public <V> Function<V, OkHttpClient> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super OkHttpClient, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public OkHttpClient apply(String user) {
                Object object;
                OkHttpClient.Builder builder = new OkHttpClient.Builder().socketFactory((SocketFactory)new SocketChannelSocketFactory()).connectTimeout(Predef$.MODULE$.Long2long((Long)TrinoConfiguration$.MODULE$.TRINO_HTTP_CONNECT_TIME_OUT().getValue()), TimeUnit.SECONDS).readTimeout(Predef$.MODULE$.Long2long((Long)TrinoConfiguration$.MODULE$.TRINO_HTTP_READ_TIME_OUT().getValue()), TimeUnit.SECONDS);
                String password = (String)TrinoConfiguration$.MODULE$.TRINO_PASSWORD().getValue();
                String passwordCmd = (String)TrinoConfiguration$.MODULE$.TRINO_PASSWORD_CMD().getValue();
                if (StringUtils.isNotBlank((CharSequence)user)) {
                    PasswordCallback passwordCallback = null;
                    if (StringUtils.isNotBlank((CharSequence)passwordCmd)) {
                        passwordCallback = new CommandPasswordCallback(passwordCmd);
                    } else if (StringUtils.isNotBlank((CharSequence)password)) {
                        passwordCallback = new StaticPasswordCallback(password);
                    }
                    object = passwordCallback != null ? builder.addInterceptor((Interceptor)new PasswordInterceptor(user, passwordCallback)) : BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
                if (BoxesRunTime.unboxToBoolean((Object)TrinoConfiguration$.MODULE$.TRINO_SSL_INSECURED().getValue())) {
                    OkHttpUtil.setupInsecureSsl((OkHttpClient.Builder)builder);
                } else {
                    OkHttpUtil.setupSsl((OkHttpClient.Builder)builder, Optional.ofNullable(TrinoConfiguration$.MODULE$.TRINO_SSL_KEYSTORE().getValue()), Optional.ofNullable(TrinoConfiguration$.MODULE$.TRINO_SSL_KEYSTORE_PASSWORD().getValue()), Optional.ofNullable(TrinoConfiguration$.MODULE$.TRINO_SSL_KEYSTORE_TYPE().getValue()), Optional.ofNullable(TrinoConfiguration$.MODULE$.TRINO_SSL_TRUSTSTORE().getValue()), Optional.ofNullable(TrinoConfiguration$.MODULE$.TRINO_SSL_TRUSTSTORE_PASSWORD().getValue()), Optional.ofNullable(TrinoConfiguration$.MODULE$.TRINO_SSL_TRUSTSTORE_TYPE().getValue()));
                }
                return builder.build();
            }
        };
    }
}

