/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.zeta;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.linkis.engineconnplugin.seatunnel.util.SeatunnelUtils;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.core.starter.Starter;
import org.apache.seatunnel.core.starter.command.CommandArgs;
import org.apache.seatunnel.core.starter.enums.EngineType;
import org.apache.seatunnel.core.starter.seatunnel.args.ClientCommandArgs;
import org.apache.seatunnel.core.starter.utils.CommandLineUtils;

public class ZetaStarter
implements Starter {
    public static final Log logger = LogFactory.getLog((String)ZetaStarter.class.getName());
    private static final String APP_JAR_NAME = EngineType.SEATUNNEL.getStarterJarName();
    private static final String SHELL_NAME = EngineType.SEATUNNEL.getStarterShellName();
    private static final String namePrefix = "seaTunnel";
    private final ClientCommandArgs commandArgs;
    private final String appJar;

    ZetaStarter(String[] args) {
        this.commandArgs = (ClientCommandArgs)CommandLineUtils.parse((String[])args, (CommandArgs)new ClientCommandArgs(), (String)SHELL_NAME, (boolean)true);
        logger.info((Object)("this.commandArgs = " + this.commandArgs));
        Common.setDeployMode(this.commandArgs.getDeployMode());
        Common.setStarter(true);
        this.appJar = Common.appStarterDir().resolve(APP_JAR_NAME).toString();
    }

    public static int main(String[] args) {
        int exitCode = 0;
        try {
            logger.info((Object)"seaTunnel Zeta process..");
            ZetaStarter zetaStarter = new ZetaStarter(args);
            String commandVal = String.join((CharSequence)" ", zetaStarter.buildCommands());
            logger.info((Object)("ZetaStarter commandVal:" + commandVal));
            exitCode = SeatunnelUtils.executeLine(commandVal);
        }
        catch (Exception e) {
            exitCode = 1;
            logger.error((Object)("\n\nZetaStarter error:\n" + e));
        }
        return exitCode;
    }

    public List<String> buildCommands() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("${SEATUNNEL_HOME}/bin/" + SHELL_NAME);
        command.add("--master");
        command.add(this.commandArgs.getMasterType().name());
        command.add("--cluster");
        command.add(StringUtils.isNotBlank((CharSequence)this.commandArgs.getClusterName()) ? this.commandArgs.getClusterName() : this.randomClusterName());
        command.add("--config");
        command.add(this.commandArgs.getConfigFile());
        command.add("--name");
        command.add(this.commandArgs.getJobName());
        return command;
    }

    public String randomClusterName() {
        Random random = new Random();
        return "seaTunnel-" + random.nextInt(1000000);
    }
}

