/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.repl.executor.javarepl;

import java.io.File;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineplugin.repl.errorcode.ReplErrorCodeSummary;
import org.apache.linkis.engineplugin.repl.exception.ReplException;
import org.apache.linkis.engineplugin.repl.executor.javarepl.JavaReplBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaReplCompiler {
    private static final Logger logger = LoggerFactory.getLogger(JavaReplCompiler.class);
    private static final Pattern IMPORT_PATTERN = Pattern.compile("import\\s+([\\w\\.\\*]+);\n");
    private static final Pattern EXTENDS_PATTERN = Pattern.compile("\\s+extends\\s+([\\w\\.]+)[^\\{]*\\{\n");
    private static final Pattern IMPLEMENTS_PATTERN = Pattern.compile("\\s+implements\\s+([\\w\\.]+)\\s*\\{\n");
    private static final Pattern METHODS_PATTERN = Pattern.compile("(?<=\\})\\s+(private|public|protected)\\s+");
    private static final Pattern FIELD_PATTERN = Pattern.compile("[^\n]+=[^\n]+;");
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+([$_a-zA-Z][$_a-zA-Z0-9\\.]*);");
    private static final Pattern CLASS_PATTERN = Pattern.compile("class\\s+([$_a-zA-Z][$_a-zA-Z0-9]*)\\s+");
    private static final String javaReplClassName = "LinkisJavaRepl";

    public void compileAndExecutor(String code, ClassLoader classLoader, String classpathDir, String methodName) throws Exception {
        String cls;
        Matcher matcher = PACKAGE_PATTERN.matcher(code = code.trim());
        String pkg = matcher.find() ? matcher.group(1) : "";
        matcher = CLASS_PATTERN.matcher(code);
        Boolean containClass = true;
        if (matcher.find()) {
            cls = matcher.group(1);
        } else {
            cls = javaReplClassName;
            containClass = false;
        }
        String className = pkg != null && pkg.length() > 0 ? pkg + "." + cls : cls;
        try {
            Class.forName(className, true, classLoader);
            className = className.concat(RandomStringUtils.randomAlphabetic((int)6));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        logger.info("Java repl start building the class, className: {}", (Object)className);
        if (!code.endsWith("}")) {
            throw new IllegalStateException("The java code not endsWith \"}\", code: \n" + code + "\n");
        }
        this.doCompileAndExecutor(classLoader, className, code, containClass, classpathDir, methodName);
    }

    public void doCompileAndExecutor(ClassLoader classLoader, String name, String source, Boolean containClass, String classpathDir, String methodName) throws Exception {
        JavaReplBuilder builder = new JavaReplBuilder();
        builder.setClassName(name);
        Matcher matcher = IMPORT_PATTERN.matcher(source);
        while (matcher.find()) {
            builder.addImports(matcher.group(1).trim());
            String importCode = matcher.group();
            if (!StringUtils.isNotBlank((CharSequence)importCode)) continue;
            source = source.replaceFirst(importCode, "");
        }
        matcher = EXTENDS_PATTERN.matcher(source);
        if (matcher.find()) {
            builder.setSuperClassName(matcher.group(1).trim());
        }
        if ((matcher = IMPLEMENTS_PATTERN.matcher(source)).find()) {
            String[] ifaces = matcher.group(1).trim().split("\\,");
            Arrays.stream(ifaces).forEach(i -> builder.addInterface(i.trim()));
        }
        String body = "";
        body = containClass != false ? source.substring(source.indexOf(123) + 1, source.length() - 1) : source;
        String[] methods = METHODS_PATTERN.split(body);
        String className = JavaReplCompiler.getSimpleClassName(name);
        Arrays.stream(methods).map(String::trim).filter(m -> !m.isEmpty()).forEach(method -> {
            if (method.startsWith(className)) {
                builder.addConstructor("public " + method);
            } else if (FIELD_PATTERN.matcher((CharSequence)method).matches()) {
                builder.addField("private " + method);
            } else {
                builder.addMethod("public " + method);
            }
        });
        CtClass cls = builder.build(classLoader);
        logger.info("Java repl CtClass build completed, CtClass: {}", (Object)cls);
        ClassPool cp = cls.getClassPool();
        if (classLoader == null) {
            classLoader = cp.getClassLoader();
        }
        cp.insertClassPath((ClassPath)new LoaderClassPath(classLoader));
        if (StringUtils.isNotBlank((CharSequence)classpathDir) && FileUtils.isDirectory((File)new File(classpathDir), (LinkOption[])new LinkOption[0])) {
            cp.insertClassPath(classpathDir);
        }
        if (StringUtils.isBlank((CharSequence)methodName)) {
            Object[] declaredMethods = cls.getDeclaredMethods();
            String declareMethodName = declaredMethods[0].getName();
            if (ArrayUtils.isEmpty((Object[])declaredMethods) || StringUtils.isBlank((CharSequence)declareMethodName)) {
                throw new ReplException(ReplErrorCodeSummary.UNABLE_RESOLVE_JAVA_METHOD_NAME.getErrorCode(), ReplErrorCodeSummary.UNABLE_RESOLVE_JAVA_METHOD_NAME.getErrorDesc());
            }
            methodName = declareMethodName;
        }
        logger.info("Java repl methodName: {}", (Object)methodName);
        logger.info("Java repl {} start executor", (Object)className);
        Class clazz = cp.toClass(cls);
        Object obj = clazz.newInstance();
        obj.getClass().getMethod(methodName, new Class[0]).invoke(obj, new Object[0]);
        logger.info("Java repl {} executor success", (Object)className);
    }

    public static String getSimpleClassName(String qualifiedName) {
        if (null == qualifiedName) {
            return null;
        }
        int i = qualifiedName.lastIndexOf(46);
        return i < 0 ? qualifiedName : qualifiedName.substring(i + 1);
    }
}

