/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.jdbc.utils;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.manager.engineplugin.jdbc.JDBCPropertiesParser;
import org.apache.linkis.manager.engineplugin.jdbc.errorcode.JDBCErrorCodeSummary;
import org.apache.linkis.manager.engineplugin.jdbc.exception.JDBCParamsIllegalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcParamUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcParamUtils.class);
    private static final String AUTO_DESERIALIZE = "autoDeserialize";
    private static final String APPEND_PARAMS = "allowLoadLocalInfile=false&autoDeserialize=false&allowLocalInfile=false&allowUrlInLocalInfile=false";
    public static final CommonVars<String> MYSQL_STRONG_SECURITY_ENABLE = CommonVars$.MODULE$.apply("linkis.mysql.strong.security.enable", (Object)"false");
    private static final String QUOTATION_MARKS = "\"";

    public static String clearJdbcUrl(String url) {
        if (url.startsWith(QUOTATION_MARKS) && url.endsWith(QUOTATION_MARKS)) {
            url = url.trim();
            return url.substring(1, url.length() - 1);
        }
        return url;
    }

    public static String getJdbcUsername(Map<String, String> properties) throws JDBCParamsIllegalException {
        String username = JDBCPropertiesParser.getString(properties, "wds.linkis.jdbc.username", "");
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.JDBC_USERNAME_NOT_EMPTY.getErrorCode(), JDBCErrorCodeSummary.JDBC_USERNAME_NOT_EMPTY.getErrorDesc());
        }
        if (username.contains(AUTO_DESERIALIZE)) {
            LOG.warn("Sensitive param : {} in username field is filtered.", (Object)AUTO_DESERIALIZE);
            username = username.replace(AUTO_DESERIALIZE, "");
        }
        LOG.info("The jdbc username is: {}", (Object)username);
        return username;
    }

    public static String getJdbcPassword(Map<String, String> properties) throws JDBCParamsIllegalException {
        String password = JDBCPropertiesParser.getString(properties, "wds.linkis.jdbc.password", "");
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.JDBC_PASSWORD_NOT_EMPTY.getErrorCode(), JDBCErrorCodeSummary.JDBC_PASSWORD_NOT_EMPTY.getErrorDesc());
        }
        if (password.contains(AUTO_DESERIALIZE)) {
            LOG.warn("Sensitive param : {} in password field is filtered", (Object)AUTO_DESERIALIZE);
            password = password.replace(AUTO_DESERIALIZE, "");
        }
        return password;
    }
}

