/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.jdbc.executor;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.JsonUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.datasource.client.impl.LinkisDataSourceRemoteClient;
import org.apache.linkis.datasource.client.request.GetInfoPublishedByDataSourceNameAction$;
import org.apache.linkis.datasourcemanager.common.domain.DataSource;
import org.apache.linkis.manager.engineplugin.jdbc.JdbcAuthType;
import org.apache.linkis.manager.engineplugin.jdbc.conf.JDBCConfiguration$;
import org.apache.linkis.manager.engineplugin.jdbc.errorcode.JDBCErrorCodeSummary;
import org.apache.linkis.manager.engineplugin.jdbc.exception.JDBCParamsIllegalException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JDBCMultiDatasourceParser$
implements Logging {
    public static JDBCMultiDatasourceParser$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new JDBCMultiDatasourceParser$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        JDBCMultiDatasourceParser$ jDBCMultiDatasourceParser$ = this;
        synchronized (jDBCMultiDatasourceParser$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Map<String, String> queryDatasourceInfoByName(String datasourceName, String username, String system) {
        this.logger().info(new StringBuilder(44).append("Starting query [").append(system).append(", ").append(username).append(", ").append(datasourceName).append("] datasource info ......").toString());
        LinkisDataSourceRemoteClient dataSourceClient = new LinkisDataSourceRemoteClient();
        DataSource dataSource = null;
        dataSource = dataSourceClient.getInfoPublishedByDataSourceName(GetInfoPublishedByDataSourceNameAction$.MODULE$.builder().setSystem(system).setDataSourceName(datasourceName).setUser(username).build()).getDataSource();
        return this.queryDatasourceInfo(datasourceName, dataSource);
    }

    public Map<String, String> queryDatasourceInfo(String datasourceName, DataSource dataSource) {
        HashMap<String, String> dsConnInfo = new HashMap<String, String>();
        if (this.strObjIsBlank(dataSource)) {
            throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.DATA_SOURCE_INFO_NOT_FOUND.getErrorCode(), MessageFormat.format(JDBCErrorCodeSummary.DATA_SOURCE_INFO_NOT_FOUND.getErrorDesc(), datasourceName));
        }
        if (dataSource.getPublishedVersionId() == null || Predef$.MODULE$.Long2long(dataSource.getPublishedVersionId()) <= 0L) {
            throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.DATA_SOURCE_NOT_PUBLISHED.getErrorCode(), MessageFormat.format(JDBCErrorCodeSummary.DATA_SOURCE_NOT_PUBLISHED.getErrorDesc(), datasourceName));
        }
        String maxVersionId = "0";
        if (dataSource.getPublishedVersionId() != null) {
            maxVersionId = dataSource.getPublishedVersionId().toString();
        }
        dsConnInfo.put("wds.linkis.engine.runtime.datasource.maxVersionId", maxVersionId);
        if (dataSource.isExpire()) {
            throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.DATA_SOURCE_EXPIRED.getErrorCode(), MessageFormat.format(JDBCErrorCodeSummary.DATA_SOURCE_EXPIRED.getErrorDesc(), datasourceName));
        }
        if (dataSource.getDataSourceType() == null || StringUtils.isBlank((CharSequence)dataSource.getDataSourceType().getName())) {
            throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.DATA_SOURCE_JDBC_TYPE_NOT_NULL.getErrorCode(), JDBCErrorCodeSummary.DATA_SOURCE_JDBC_TYPE_NOT_NULL.getErrorDesc());
        }
        String dbType = dataSource.getDataSourceType().getName();
        Map dbConnParams = dataSource.getConnectParams();
        if (dbConnParams == null || dbConnParams.isEmpty()) {
            throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.JDBC_CONNECTION_INFO_NOT_NULL.getErrorCode(), JDBCErrorCodeSummary.JDBC_CONNECTION_INFO_NOT_NULL.getErrorDesc());
        }
        Object driverClassName = dbConnParams.get("driverClassName");
        if (this.strObjIsBlank(driverClassName)) {
            throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.JDBC_DRIVER_CLASS_NAME_NOT_NULL.getErrorCode(), JDBCErrorCodeSummary.JDBC_DRIVER_CLASS_NAME_NOT_NULL.getErrorDesc());
        }
        if (JDBCConfiguration$.MODULE$.CHANGE_DS_TYPE_TO_MYSQL()) {
            dbType = "mysql";
        }
        String jdbcUrl = this.createJdbcUrl(dbType, dbConnParams);
        this.logger().info(new StringBuilder(62).append("The url parsed from the data source connection information is ").append(jdbcUrl).toString());
        dsConnInfo.put("wds.linkis.jdbc.connect.url", jdbcUrl);
        dsConnInfo.put("wds.linkis.jdbc.driver", driverClassName.toString());
        return this.appendJdbcAuthType(dbConnParams, dsConnInfo);
    }

    public String createJdbcUrl(String dbType, Map<String, Object> dbConnParams) {
        String jdbcUrl;
        block5: {
            Object object;
            Object params;
            Map<Object, Object> paramsMap;
            Object host = dbConnParams.get("host");
            if (this.strObjIsBlank(host)) {
                throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.JDBC_HOST_NOT_NULL.getErrorCode(), JDBCErrorCodeSummary.JDBC_HOST_NOT_NULL.getErrorDesc());
            }
            Object port = dbConnParams.get("port");
            if (this.strObjIsBlank(port)) {
                throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.JDBC_PORT_NOT_NULL.getErrorCode(), JDBCErrorCodeSummary.JDBC_PORT_NOT_NULL.getErrorDesc());
            }
            jdbcUrl = new StringBuilder(9).append("jdbc:").append(dbType).append("://").append(host).append(":").append(port).toString();
            Object dbName = dbConnParams.get("databaseName");
            if (this.strObjIsNotBlank(dbName)) {
                jdbcUrl = new StringBuilder(1).append(jdbcUrl).append("/").append(dbName).toString();
            }
            Map<Object, Object> map = paramsMap = this.strObjIsNotBlank(params = dbConnParams.get("params")) ? this.convertJsonStrToMap(params.toString()) : new HashMap();
            if (!paramsMap.isEmpty()) {
                Tuple2 headConf = (Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(paramsMap).asScala()).head();
                jdbcUrl = new StringBuilder(2).append(jdbcUrl).append("?").append(headConf._1()).append("=").append(headConf._2()).toString();
                object = paramsMap.remove(headConf._1());
            } else {
                object = BoxedUnit.UNIT;
            }
            if (paramsMap.isEmpty()) break block5;
            Iterable paramsJoin = (Iterable)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(paramsMap).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)JDBCMultiDatasourceParser$.$anonfun$createJdbcUrl$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1).append(k).append("=").append(v.toString()).toString())).toList().mkString("&");
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom());
            jdbcUrl = new StringBuilder(1).append(jdbcUrl).append("&").append(paramsJoin).toString();
        }
        return jdbcUrl;
    }

    public HashMap<String, String> appendJdbcAuthType(Map<String, Object> dbConnParams, HashMap<String, String> dsConnInfo) {
        Object username = dbConnParams.get("username");
        Object password = dbConnParams.get("password");
        Object enableKerberos = dbConnParams.get("enableKerberos");
        Object kerberosPrincipal = dbConnParams.get("kerberosPrincipal");
        Object kerberosKeytab = dbConnParams.get("kerberosKeytab");
        JdbcAuthType authType = JdbcAuthType.SIMPLE;
        if (this.strObjIsNotBlank(username) && this.strObjIsNotBlank(password)) {
            authType = JdbcAuthType.USERNAME;
        } else if (this.strObjIsNotBlank(enableKerberos) && new StringOps(Predef$.MODULE$.augmentString(enableKerberos.toString())).toBoolean()) {
            authType = JdbcAuthType.KERBEROS;
            if (this.strObjIsBlank(kerberosPrincipal)) {
                throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.KERBEROS_PRINCIPAL_NOT_NULL.getErrorCode(), JDBCErrorCodeSummary.KERBEROS_PRINCIPAL_NOT_NULL.getErrorDesc());
            }
            if (this.strObjIsBlank(kerberosKeytab)) {
                throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.KERBEROS_KEYTAB_NOT_NULL.getErrorCode(), JDBCErrorCodeSummary.KERBEROS_KEYTAB_NOT_NULL.getErrorDesc());
            }
        } else {
            authType = JdbcAuthType.SIMPLE;
        }
        JdbcAuthType jdbcAuthType = authType;
        if (((Object)((Object)JdbcAuthType.SIMPLE)).equals((Object)jdbcAuthType)) {
            this.logger().info("jdbc simple auth type.");
        } else if (((Object)((Object)JdbcAuthType.USERNAME)).equals((Object)jdbcAuthType)) {
            dsConnInfo.put("wds.linkis.jdbc.username", username.toString());
            dsConnInfo.put("wds.linkis.jdbc.password", password.toString());
        } else if (((Object)((Object)JdbcAuthType.KERBEROS)).equals((Object)jdbcAuthType)) {
            dsConnInfo.put("wds.linkis.jdbc.principal", kerberosPrincipal.toString());
            dsConnInfo.put("wds.linkis.jdbc.keytab.location", kerberosKeytab.toString());
            Object enableKerberosProxyUser = dbConnParams.get("enableKerberosProxyUser");
            Object object = this.strObjIsNotBlank(enableKerberosProxyUser) ? dsConnInfo.put("wds.linkis.jdbc.auth.kerberos.proxy.enable", enableKerberosProxyUser.toString()) : BoxedUnit.UNIT;
            Object kerberosProxyUserProperty = dbConnParams.get("kerberosProxyUserProperty");
            if (this.strObjIsNotBlank(kerberosProxyUserProperty)) {
                dsConnInfo.put("wds.linkis.jdbc.proxy.user.property", kerberosProxyUserProperty.toString());
            }
        } else {
            throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.UNSUPPORTED_AUTHENTICATION_TYPE.getErrorCode(), MessageFormat.format(JDBCErrorCodeSummary.UNSUPPORTED_AUTHENTICATION_TYPE.getErrorDesc(), authType.getAuthType()));
        }
        dsConnInfo.put("wds.linkis.jdbc.auth.type", authType.getAuthType());
        return dsConnInfo;
    }

    private Map<String, Object> convertJsonStrToMap(String jsonStr) {
        return (Map)JsonUtils$.MODULE$.jackson().readValue(jsonStr, Map.class);
    }

    private boolean strObjIsNotBlank(Object str) {
        return str != null && StringUtils.isNotBlank((CharSequence)str.toString());
    }

    private boolean strObjIsBlank(Object str) {
        return !this.strObjIsNotBlank(str);
    }

    public static final /* synthetic */ boolean $anonfun$createJdbcUrl$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private JDBCMultiDatasourceParser$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

