/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.jdbc;

import com.alibaba.druid.pool.DruidDataSource;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.linkis.common.utils.SecurityUtils;
import org.apache.linkis.hadoop.common.utils.KerberosUtils;
import org.apache.linkis.manager.engineplugin.jdbc.JDBCDataSourceConfigurations;
import org.apache.linkis.manager.engineplugin.jdbc.JDBCPropertiesParser;
import org.apache.linkis.manager.engineplugin.jdbc.JdbcAuthType;
import org.apache.linkis.manager.engineplugin.jdbc.conf.JDBCConfiguration$;
import org.apache.linkis.manager.engineplugin.jdbc.errorcode.JDBCErrorCodeSummary;
import org.apache.linkis.manager.engineplugin.jdbc.exception.JDBCParamsIllegalException;
import org.apache.linkis.manager.engineplugin.jdbc.utils.JdbcParamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionManager.class);
    private final Map<String, DataSource> dataSourceFactories;
    private final JDBCDataSourceConfigurations jdbcDataSourceConfigurations = new JDBCDataSourceConfigurations();
    private static volatile ConnectionManager connectionManager;
    private ScheduledExecutorService scheduledExecutorService;
    private Integer kinitFailCount = 0;

    private ConnectionManager() {
        this.dataSourceFactories = new HashMap<String, DataSource>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionManager getInstance() {
        if (connectionManager != null) return connectionManager;
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            if (connectionManager != null) return connectionManager;
            connectionManager = new ConnectionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return connectionManager;
        }
    }

    public void initTaskStatementMap() {
        try {
            this.jdbcDataSourceConfigurations.initTaskIdStatementMap();
        }
        catch (Exception e) {
            LOG.error("Error while closing taskIdStatementMap statement...", (Throwable)e);
        }
    }

    public void saveStatement(String taskId, Statement statement) {
        this.jdbcDataSourceConfigurations.saveStatement(taskId, statement);
    }

    public void removeStatement(String taskId) {
        this.jdbcDataSourceConfigurations.removeStatement(taskId);
    }

    public void cancelStatement(String taskId) {
        try {
            this.jdbcDataSourceConfigurations.cancelStatement(taskId);
        }
        catch (SQLException e) {
            LOG.error("Error while cancelling task is {} ...", (Object)taskId, (Object)e);
        }
    }

    public void close() {
        try {
            this.initTaskStatementMap();
        }
        catch (Exception e) {
            LOG.error("Error while closing...", (Throwable)e);
        }
        for (DataSource dataSource : this.dataSourceFactories.values()) {
            try {
                if (!(dataSource instanceof Closeable)) continue;
                ((Closeable)((Object)dataSource)).close();
            }
            catch (Exception e) {
                LOG.error("Error while closing datasource...", (Throwable)e);
            }
        }
    }

    protected DataSource buildDataSource(String dbUrl, Map<String, String> properties) throws JDBCParamsIllegalException {
        String driverClassName = JDBCPropertiesParser.getString(properties, "wds.linkis.jdbc.driver", "");
        if (StringUtils.isBlank((CharSequence)driverClassName)) {
            LOG.error("The driver class name is required.");
            throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.DRIVER_CLASS_NAME_ERROR.getErrorCode(), JDBCErrorCodeSummary.DRIVER_CLASS_NAME_ERROR.getErrorDesc());
        }
        String username = JdbcParamUtils.getJdbcUsername(properties);
        String password = JdbcParamUtils.getJdbcPassword(properties);
        JdbcAuthType jdbcAuthType = this.getJdbcAuthType(properties);
        switch (jdbcAuthType) {
            case USERNAME: {
                LOG.info("The jdbc auth type is username and password.");
                break;
            }
            case SIMPLE: {
                LOG.info("The jdbc auth type is simple.");
                break;
            }
            case KERBEROS: {
                LOG.info("The jdbc auth type is kerberos.");
                break;
            }
            default: {
                throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.UNSUPPORT_JDBC_AUTHENTICATION_TYPES.getErrorCode(), MessageFormat.format(JDBCErrorCodeSummary.UNSUPPORT_JDBC_AUTHENTICATION_TYPES.getErrorDesc(), jdbcAuthType.getAuthType()));
            }
        }
        boolean testOnBorrow = JDBCPropertiesParser.getBool(properties, "wds.linkis.jdbc.pool.testOnBorrow", false);
        boolean testOnReturn = JDBCPropertiesParser.getBool(properties, "wds.linkis.jdbc.pool.testOnReturn", false);
        boolean testWhileIdle = JDBCPropertiesParser.getBool(properties, "wds.linkis.jdbc.pool.testWhileIdle", true);
        int minEvictableIdleTimeMillis = JDBCPropertiesParser.getInt(properties, "wds.linkis.jdbc.pool.minEvictableIdleTimeMillis", 300000);
        long timeBetweenEvictionRunsMillis = JDBCPropertiesParser.getLong(properties, "wds.linkis.jdbc.pool.timeBetweenEvictionRunsMillis", 60000L);
        long maxWait = JDBCPropertiesParser.getLong(properties, "wds.linkis.jdbc.pool.maxWaitMillis", 6000L);
        int maxActive = JDBCPropertiesParser.getInt(properties, "wds.linkis.jdbc.pool.maxActive", 20);
        int minIdle = JDBCPropertiesParser.getInt(properties, "wds.linkis.jdbc.pool.minIdle", 1);
        int initialSize = JDBCPropertiesParser.getInt(properties, "wds.linkis.jdbc.pool.initialSize", 1);
        String validationQuery = JDBCPropertiesParser.getString(properties, "wds.linkis.jdbc.pool.validationQuery", "SELECT 1");
        boolean poolPreparedStatements = JDBCPropertiesParser.getBool(properties, "wds.linkis.jdbc.pool.poolPreparedStatements", true);
        boolean removeAbandoned = JDBCPropertiesParser.getBool(properties, "wds.linkis.jdbc.pool.remove.abandoned.enabled", true);
        int removeAbandonedTimeout = JDBCPropertiesParser.getInt(properties, "wds.linkis.jdbc.pool.remove.abandoned.timeout", 300);
        int connectionTimeout = JDBCPropertiesParser.getInt(properties, "wds.linkis.jdbc.connection.timeout", 0);
        int socketTimeout = JDBCPropertiesParser.getInt(properties, "wds.linkis.jdbc.socket.timeout", 0);
        int queryTimeout = JDBCPropertiesParser.getInt(properties, JDBCConfiguration$.MODULE$.JDBC_QUERY_TIMEOUT().key(), 0);
        DruidDataSource datasource = new DruidDataSource();
        LOG.info("Database connection address information(\u6570\u636e\u5e93\u8fde\u63a5\u5730\u5740\u4fe1\u606f)=" + dbUrl);
        datasource.setUrl(dbUrl);
        datasource.setUsername(username);
        datasource.setPassword(password);
        datasource.setConnectProperties(SecurityUtils.getMysqlSecurityParams());
        datasource.setDriverClassName(driverClassName);
        datasource.setInitialSize(initialSize);
        datasource.setMinIdle(minIdle);
        datasource.setMaxActive(maxActive);
        datasource.setMaxWait(maxWait);
        datasource.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        datasource.setMinEvictableIdleTimeMillis((long)minEvictableIdleTimeMillis);
        datasource.setValidationQuery(validationQuery);
        datasource.setTestWhileIdle(testWhileIdle);
        datasource.setTestOnBorrow(testOnBorrow);
        datasource.setTestOnReturn(testOnReturn);
        datasource.setPoolPreparedStatements(poolPreparedStatements);
        datasource.setRemoveAbandoned(removeAbandoned);
        datasource.setRemoveAbandonedTimeout(removeAbandonedTimeout);
        if (queryTimeout > 0) {
            datasource.setQueryTimeout(queryTimeout);
        }
        return datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnectionFromDataSource(String dataSourceIdentifier, String url, Map<String, String> prop) throws SQLException, JDBCParamsIllegalException {
        DataSource dataSource = this.dataSourceFactories.get(dataSourceIdentifier);
        if (dataSource == null) {
            Map<String, DataSource> map = this.dataSourceFactories;
            synchronized (map) {
                if (dataSource == null) {
                    dataSource = this.buildDataSource(url, prop);
                    this.dataSourceFactories.put(dataSourceIdentifier, dataSource);
                }
            }
        }
        return dataSource.getConnection();
    }

    public Connection getConnection(String dataSourceIdentifier, Map<String, String> properties) throws SQLException, JDBCParamsIllegalException {
        String execUser = JDBCPropertiesParser.getString(properties, "execUser", "");
        if (StringUtils.isBlank((CharSequence)execUser)) {
            LOG.warn("execUser is empty!");
            throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.NO_EXEC_USER_ERROR.getErrorCode(), JDBCErrorCodeSummary.NO_EXEC_USER_ERROR.getErrorDesc());
        }
        Connection connection = null;
        String jdbcUrl = this.getJdbcUrl(properties);
        JdbcAuthType jdbcAuthType = this.getJdbcAuthType(properties);
        switch (jdbcAuthType) {
            case USERNAME: 
            case SIMPLE: {
                connection = this.getConnectionFromDataSource(dataSourceIdentifier, jdbcUrl, properties);
                break;
            }
            case KERBEROS: {
                UserGroupInformation ugi;
                LOG.debug("Calling createKerberosSecureConfiguration(); this will do loginUserFromKeytab() if required");
                String keytab = JDBCPropertiesParser.getString(properties, "wds.linkis.jdbc.keytab.location", "");
                String principal = JDBCPropertiesParser.getString(properties, "wds.linkis.jdbc.principal", "");
                KerberosUtils.createKerberosSecureConfiguration((String)keytab, (String)principal);
                LOG.debug("createKerberosSecureConfiguration() returned");
                boolean isProxyEnabled = JDBCPropertiesParser.getBool(properties, "wds.linkis.jdbc.auth.kerberos.proxy.enable", true);
                if (isProxyEnabled) {
                    String jdbcUrlWithProxyUser = this.appendProxyUserToJDBCUrl(jdbcUrl, execUser, properties);
                    LOG.info(String.format("Try to Create a new %s JDBC with url(%s), kerberos, proxyUser(%s).", dataSourceIdentifier, jdbcUrlWithProxyUser, execUser));
                    connection = this.getConnectionFromDataSource(dataSourceIdentifier, jdbcUrlWithProxyUser, properties);
                    break;
                }
                try {
                    ugi = UserGroupInformation.createProxyUser((String)execUser, (UserGroupInformation)UserGroupInformation.getCurrentUser());
                }
                catch (Exception e) {
                    LOG.error("Error in getCurrentUser", (Throwable)e);
                    throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.GET_CURRENT_USER_ERROR.getErrorCode(), JDBCErrorCodeSummary.GET_CURRENT_USER_ERROR.getErrorDesc());
                }
                try {
                    connection = (Connection)ugi.doAs(() -> this.getConnectionFromDataSource(dataSourceIdentifier, jdbcUrl, properties));
                    break;
                }
                catch (Exception e) {
                    throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.DOAS_FOR_GET_CONNECTION_ERROR.getErrorCode(), JDBCErrorCodeSummary.DOAS_FOR_GET_CONNECTION_ERROR.getErrorDesc());
                }
            }
            default: {
                throw new JDBCParamsIllegalException(JDBCErrorCodeSummary.UNSUPPORT_JDBC_AUTHENTICATION_TYPES.getErrorCode(), MessageFormat.format(JDBCErrorCodeSummary.UNSUPPORT_JDBC_AUTHENTICATION_TYPES.getErrorDesc(), jdbcAuthType.getAuthType()));
            }
        }
        return connection;
    }

    private String getJdbcUrl(Map<String, String> properties) throws SQLException {
        String url = properties.get("wds.linkis.jdbc.connect.url");
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new SQLException("wds.linkis.jdbc.connect.url cannot be empty.");
        }
        url = JdbcParamUtils.clearJdbcUrl(url);
        SecurityUtils.checkJdbcConnUrl((String)url);
        url = SecurityUtils.getJdbcUrl((String)url);
        return url;
    }

    private String appendProxyUserToJDBCUrl(String jdbcUrl, String execUser, Map<String, String> properties) {
        StringBuilder jdbcUrlSb = new StringBuilder(jdbcUrl);
        String proxyUserProperty = JDBCPropertiesParser.getString(properties, "wds.linkis.jdbc.proxy.user.property", "");
        if (execUser != null && !"anonymous".equals(execUser) && StringUtils.isNotBlank((CharSequence)proxyUserProperty)) {
            int lastIndexOfUrl = jdbcUrl.indexOf("?");
            if (lastIndexOfUrl == -1) {
                lastIndexOfUrl = jdbcUrl.length();
            }
            LOG.info("Using proxy user as: {}", (Object)execUser);
            LOG.info("Using proxy property for user as: {}", (Object)proxyUserProperty);
            jdbcUrlSb.insert(lastIndexOfUrl, ";" + proxyUserProperty + "=" + execUser + ";");
        }
        return jdbcUrlSb.toString();
    }

    private JdbcAuthType getJdbcAuthType(Map<String, String> properties) {
        String authType = properties.getOrDefault("wds.linkis.jdbc.auth.type", JdbcAuthType.USERNAME.getAuthType());
        if (authType == null || authType.trim().length() == 0) {
            return JdbcAuthType.of(JdbcAuthType.USERNAME.getAuthType());
        }
        return JdbcAuthType.of(authType.trim().toUpperCase());
    }

    public ScheduledExecutorService startRefreshKerberosLoginStatusThread() {
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        this.scheduledExecutorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (KerberosUtils.runRefreshKerberosLogin()) {
                    LOG.info("Ran runRefreshKerberosLogin command successfully.");
                    ConnectionManager.this.kinitFailCount = 0;
                    LOG.info("Scheduling Kerberos ticket refresh thread with interval {} ms", (Object)KerberosUtils.getKerberosRefreshInterval());
                    ConnectionManager.this.scheduledExecutorService.schedule(this, (long)KerberosUtils.getKerberosRefreshInterval(), TimeUnit.MILLISECONDS);
                } else {
                    Integer n = ConnectionManager.this.kinitFailCount;
                    Integer n2 = ConnectionManager.this.kinitFailCount = ConnectionManager.this.kinitFailCount + 1;
                    LOG.info("runRefreshKerberosLogin failed for {} time(s).", (Object)ConnectionManager.this.kinitFailCount);
                    if (ConnectionManager.this.kinitFailCount >= KerberosUtils.kinitFailTimesThreshold()) {
                        LOG.error("runRefreshKerberosLogin failed for max attempts, calling close executor.");
                    } else {
                        ConnectionManager.this.scheduledExecutorService.schedule(this, 1L, TimeUnit.SECONDS);
                    }
                }
                return null;
            }
        });
        return this.scheduledExecutorService;
    }

    public void shutdownRefreshKerberosLoginService() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }
}

