/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.io.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.conf.ByteType;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.storage.domain.MethodEntity;
import org.apache.linkis.storage.domain.MethodEntitySerializer$;
import org.apache.linkis.storage.errorcode.LinkisIoFileErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageErrorException;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.ResultSetReader$;
import org.apache.linkis.storage.resultset.ResultSetWriter$;
import org.apache.linkis.storage.resultset.io.IOMetaData;
import org.apache.linkis.storage.resultset.io.IORecord;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import org.apache.linkis.storage.utils.StorageUtils$;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class IOHelp$ {
    public static IOHelp$ MODULE$;
    private final long maxPageSize;

    static {
        new IOHelp$();
    }

    private long maxPageSize() {
        return this.maxPageSize;
    }

    public String read(Fs fs, MethodEntity method) {
        if (method.params() == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(method.params())).isEmpty()) {
            throw new StorageErrorException(LinkisIoFileErrorCodeSummary.CANNOT_BE_EMPTY.getErrorCode(), LinkisIoFileErrorCodeSummary.CANNOT_BE_EMPTY.getErrorDesc());
        }
        FsPath dest = (FsPath)MethodEntitySerializer$.MODULE$.deserializerToJavaObject((String)method.params()[0], FsPath.class);
        InputStream inputStream = fs.read(dest);
        ResultSet resultSet = ResultSetFactory$.MODULE$.getInstance().getResultSetByType(ResultSetFactory$.MODULE$.IO_TYPE());
        ResultSetWriter writer = ResultSetWriter$.MODULE$.getResultSetWriter(resultSet, Long.MAX_VALUE, null);
        return (String)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> {
            if (method.params().length == 1) {
                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                IOMetaData ioMetaData = new IOMetaData(0, bytes.length);
                IORecord ioRecord = new IORecord(bytes);
                writer.addMetaData((MetaData)ioMetaData);
                writer.addRecord((Record)ioRecord);
                return writer.toString();
            }
            if (method.params().length == 3) {
                int position = new StringOps(Predef$.MODULE$.augmentString(method.params()[1].toString())).toInt() < 0 ? 0 : new StringOps(Predef$.MODULE$.augmentString(method.params()[1].toString())).toInt();
                int fetchSize = (long)new StringOps(Predef$.MODULE$.augmentString(method.params()[2].toString())).toInt() > MODULE$.maxPageSize() ? (int)MODULE$.maxPageSize() : new StringOps(Predef$.MODULE$.augmentString(method.params()[2].toString())).toInt();
                Object object = position > 0 ? BoxesRunTime.boxToLong((long)inputStream.skip(position)) : BoxedUnit.UNIT;
                byte[] bytes = new byte[fetchSize];
                int len = StorageUtils$.MODULE$.readBytes(inputStream, bytes, fetchSize);
                IOMetaData ioMetaData = new IOMetaData(0, len);
                IORecord ioRecord = new IORecord((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(0, len));
                writer.addMetaData((MetaData)ioMetaData);
                writer.addRecord((Record)ioRecord);
                return writer.toString();
            }
            throw new StorageErrorException(LinkisIoFileErrorCodeSummary.PARAMETER_CALLS.getErrorCode(), LinkisIoFileErrorCodeSummary.PARAMETER_CALLS.getErrorDesc());
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((InputStream)inputStream));
    }

    public void write(Fs fs, MethodEntity method) {
        if (method.params() == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(method.params())).isEmpty()) {
            throw new StorageErrorException(LinkisIoFileErrorCodeSummary.PARAMETER_CALLS.getErrorCode(), LinkisIoFileErrorCodeSummary.PARAMETER_CALLS.getErrorDesc());
        }
        FsPath dest = (FsPath)MethodEntitySerializer$.MODULE$.deserializerToJavaObject((String)method.params()[0], FsPath.class);
        boolean overwrite = BoxesRunTime.unboxToBoolean((Object)method.params()[1]);
        OutputStream outputStream = fs.write(dest, overwrite);
        String content = (String)method.params()[2];
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ResultSet resultSet = ResultSetFactory$.MODULE$.getInstance().getResultSetByType(ResultSetFactory$.MODULE$.IO_TYPE());
            ResultSetReader reader = ResultSetReader$.MODULE$.getResultSetReader(resultSet, content);
            while (reader.hasNext()) {
                IOUtils.write((byte[])((IORecord)reader.getRecord()).value(), (OutputStream)outputStream);
            }
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((OutputStream)outputStream));
    }

    private IOHelp$() {
        MODULE$ = this;
        this.maxPageSize = ((ByteType)StorageConfiguration$.MODULE$.IO_PROXY_READ_FETCH_SIZE().getValue()).toLong();
    }
}

