/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.elasticsearch.executor.client.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineplugin.elasticsearch.errorcode.EasticsearchErrorCodeSummary;
import org.apache.linkis.engineplugin.elasticsearch.exception.EsConvertResponseException;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.ElasticSearchJsonResponse;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.ElasticSearchResponse;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.ElasticSearchTableResponse;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.ResponseHandler;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.ResponseHandler$;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType;
import org.apache.linkis.storage.domain.DoubleType$;
import org.apache.linkis.storage.domain.StringType$;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E2Aa\u0001\u0003\u0001+!)\u0001\u0005\u0001C\u0001C!)A\u0005\u0001C!K\t\u0019\"+Z:q_:\u001cX\rS1oI2,'/S7qY*\u0011QAB\u0001\u0005S6\u0004HN\u0003\u0002\b\u0011\u000511\r\\5f]RT!!\u0003\u0006\u0002\u0011\u0015DXmY;u_JT!a\u0003\u0007\u0002\u001b\u0015d\u0017m\u001d;jGN,\u0017M]2i\u0015\tia\"\u0001\u0007f]\u001eLg.\u001a9mk\u001eLgN\u0003\u0002\u0010!\u00051A.\u001b8lSNT!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011c\u0001\u0001\u00179A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0010\u000e\u0003\u0019I!a\b\u0004\u0003\u001fI+7\u000f]8og\u0016D\u0015M\u001c3mKJ\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\u0003\u0002\r!\fg\u000e\u001a7f)\t1\u0013\u0006\u0005\u0002\u001eO%\u0011\u0001F\u0002\u0002\u0016\u000b2\f7\u000f^5d'\u0016\f'o\u00195SKN\u0004xN\\:f\u0011\u0015Q#\u00011\u0001,\u0003!\u0011Xm\u001d9p]N,\u0007C\u0001\u00170\u001b\u0005i#BA\u0004/\u0015\tY!#\u0003\u00021[\tA!+Z:q_:\u001cX\r")
public class ResponseHandlerImpl
implements ResponseHandler {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ResponseHandlerImpl responseHandlerImpl = this;
        synchronized (responseHandlerImpl) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public ElasticSearchResponse handle(Response response) {
        Charset charset;
        String contentType = ContentType.get((HttpEntity)response.getEntity()).getMimeType().toLowerCase();
        Charset charset2 = ContentType.get((HttpEntity)response.getEntity()).getCharset();
        Charset charSet = charset2 != null ? (charset = charset2) : Charset.forName("UTF-8");
        byte[] contentBytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        if (contentBytes == null || new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(contentBytes)).isEmpty()) {
            throw new EsConvertResponseException(EasticsearchErrorCodeSummary.RESPONSE_FAIL_IS_EMPTY.getErrorDesc());
        }
        JsonNode jsonNode = (JsonNode)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            String string = contentType;
            if ("application/yaml".equals(string)) {
                return ResponseHandler$.MODULE$.yamlMapper().readTree(contentBytes);
            }
            if ("application/cbor".equals(string)) {
                return ResponseHandler$.MODULE$.cborMapper().readTree(contentBytes);
            }
            if ("application/smile".equals(string)) {
                return ResponseHandler$.MODULE$.smileMapper().readTree(contentBytes);
            }
            return ResponseHandler$.MODULE$.jsonMapper().readTree(contentBytes);
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable != null) {
                Throwable throwable2 = throwable;
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "deserialize response content error, {}", throwable2);
                return null;
            }
            throw new MatchError((Object)throwable);
        });
        Object object = jsonNode == null ? new ElasticSearchJsonResponse(new String(contentBytes, charSet)) : BoxedUnit.UNIT;
        boolean isTable = false;
        ArrayBuffer columns = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer records = new ArrayBuffer();
        JsonNode jsonNode2 = jsonNode.at("/hits/hits");
        if (jsonNode2 instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode2;
            isTable = true;
            columns.$plus$eq((Object)new Column("_index", (DataType)StringType$.MODULE$, ""));
            columns.$plus$eq((Object)new Column("_type", (DataType)StringType$.MODULE$, ""));
            columns.$plus$eq((Object)new Column("_id", (DataType)StringType$.MODULE$, ""));
            columns.$plus$eq((Object)new Column("_score", (DataType)DoubleType$.MODULE$, ""));
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)arrayNode).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                JsonNode jsonNode = x0$2;
                if (jsonNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    Buffer lineValues = Predef$.MODULE$.genericArrayOps((Object)new Object[columns.length()]).toBuffer();
                    ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(objectNode.fields()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                        String key = (String)entry.getKey();
                        JsonNode value = (JsonNode)entry.getValue();
                        if ("_source".equals(key.trim())) {
                            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(value.fields()).asScala()).foreach((Function1 & Serializable & scala.Serializable)sourceEntry -> {
                                String sourcekey = (String)sourceEntry.getKey();
                                JsonNode sourcevalue = (JsonNode)sourceEntry.getValue();
                                int index = columns.indexWhere((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResponseHandlerImpl.$anonfun$handle$7(sourcekey, x$1)));
                                if (index < 0) {
                                    columns.$plus$eq((Object)new Column(sourcekey, ResponseHandler$.MODULE$.getNodeDataType(sourcevalue), ""));
                                    return lineValues.$plus$eq(ResponseHandler$.MODULE$.getNodeValue(sourcevalue));
                                }
                                lineValues.update(index, ResponseHandler$.MODULE$.getNodeValue(sourcevalue));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        }
                        int index = columns.indexWhere((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ResponseHandlerImpl.$anonfun$handle$8(key, x$2)));
                        if (index < 0) {
                            columns.$plus$eq((Object)new Column(key, ResponseHandler$.MODULE$.getNodeDataType(value), ""));
                            return lineValues.$plus$eq(ResponseHandler$.MODULE$.getNodeValue(value));
                        }
                        lineValues.update(index, ResponseHandler$.MODULE$.getNodeValue(value));
                        return BoxedUnit.UNIT;
                    });
                    return records.$plus$eq((Object)new TableRecord((Object[])lineValues.toArray(ClassTag$.MODULE$.Any())));
                }
                return BoxedUnit.UNIT;
            });
        }
        JsonNode jsonNode3 = jsonNode.at("/rows");
        if (jsonNode3 instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode3;
            isTable = true;
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)((ArrayNode)jsonNode.get("columns"))).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
                String name = node.get("name").asText();
                String estype = node.get("type").asText().trim();
                return columns.$plus$eq((Object)new Column(name, ResponseHandler$.MODULE$.getNodeTypeByEsType(estype), ""));
            });
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)arrayNode).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                JsonNode jsonNode = x0$3;
                if (jsonNode instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode;
                    ArrayBuffer lineValues = new ArrayBuffer();
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)arrayNode).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> lineValues.$plus$eq(ResponseHandler$.MODULE$.getNodeValue((JsonNode)node)));
                    return records.$plus$eq((Object)new TableRecord((Object[])lineValues.toArray(ClassTag$.MODULE$.Any())));
                }
                return BoxedUnit.UNIT;
            });
        }
        if (isTable) {
            return new ElasticSearchTableResponse((Column[])columns.toArray(ClassTag$.MODULE$.apply(Column.class)), (TableRecord[])records.toArray(ClassTag$.MODULE$.apply(TableRecord.class)));
        }
        return new ElasticSearchJsonResponse(new String(contentBytes, charSet));
    }

    public static final /* synthetic */ boolean $anonfun$handle$7(String sourcekey$1, Column x$1) {
        return x$1.columnName().equals(sourcekey$1);
    }

    public static final /* synthetic */ boolean $anonfun$handle$8(String key$1, Column x$2) {
        return x$2.columnName().equals(key$1);
    }

    public ResponseHandlerImpl() {
        Logging.$init$((Logging)this);
    }
}

