/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.elasticsearch.executor.client.impl;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.engineplugin.elasticsearch.conf.ElasticSearchConfiguration;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.ElasticSearchErrorResponse;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.ElasticSearchExecutor;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.ElasticSearchResponse;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.EsClient;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.EsClientFactory;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.ResponseHandler$;
import org.apache.linkis.storage.utils.StorageUtils;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchExecutorImpl
implements ElasticSearchExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchExecutorImpl.class);
    private EsClient client;
    private Cancellable cancelable;
    private String user;
    private String runType;
    private Map<String, String> properties;

    public ElasticSearchExecutorImpl(String runType, Map<String, String> properties) {
        this.runType = runType;
        this.properties = properties;
    }

    @Override
    public void open() throws Exception {
        this.client = EsClientFactory.getRestClient(this.properties);
        this.user = StringUtils.defaultString((String)this.properties.getOrDefault("umUser", StorageUtils.getJvmUser()));
        switch (this.runType.trim().toLowerCase(Locale.getDefault())) {
            case "essql": 
            case "sql": {
                this.properties.putIfAbsent(ElasticSearchConfiguration.ES_HTTP_ENDPOINT.key(), (String)ElasticSearchConfiguration.ES_HTTP_SQL_ENDPOINT.getValue(this.properties));
                break;
            }
        }
    }

    @Override
    public ElasticSearchResponse executeLine(String code) {
        String realCode = code.trim();
        logger.info("es client begins to run {} code:\n {}", (Object)this.runType, (Object)realCode.trim());
        final CountDownLatch countDown = new CountDownLatch(1);
        final ElasticSearchResponse[] executeResponse = new ElasticSearchResponse[]{new ElasticSearchErrorResponse("INCOMPLETE", null, null)};
        this.cancelable = this.client.execute(realCode, this.properties, new ResponseListener(){

            public void onSuccess(Response response) {
                executeResponse[0] = ElasticSearchExecutorImpl.this.convertResponse(response);
                countDown.countDown();
            }

            public void onFailure(Exception exception) {
                executeResponse[0] = new ElasticSearchErrorResponse("EsEngineExecutor execute fail. ", null, exception);
                countDown.countDown();
            }
        });
        try {
            countDown.await();
        }
        catch (InterruptedException e) {
            executeResponse[0] = new ElasticSearchErrorResponse("EsEngineExecutor execute interrupted. ", null, e);
        }
        return executeResponse[0];
    }

    private ElasticSearchResponse convertResponse(Response response) {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 200 && statusCode < 300) {
                return ResponseHandler$.MODULE$.handle(response);
            }
            return new ElasticSearchErrorResponse("EsEngineExecutor convert response fail. response code: " + statusCode, null, null);
        }
        catch (Exception e) {
            return new ElasticSearchErrorResponse("EsEngineExecutor convert response error.", null, e);
        }
    }

    @Override
    public void close() {
        if (this.cancelable != null) {
            this.cancelable.cancel();
        }
    }
}

