/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.hbase.shell;

public final class Result {
    private final boolean success;
    private final String result;
    private final Throwable e;

    public Result(boolean success, String result, Throwable e) {
        this.success = success;
        this.result = result;
        this.e = e;
    }

    private static Result of(boolean success, String message, Throwable e) {
        return new Result(success, message, e);
    }

    public static Result ok(String message) {
        return Result.of(true, message, null);
    }

    public static Result ok() {
        return Result.of(true, "ok", null);
    }

    public static Result failed(String message, Throwable e) {
        return Result.of(false, message, e);
    }

    public static Result failed(Throwable e) {
        return Result.of(false, "error", e);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getResult() {
        return this.result;
    }

    public Throwable getThrowable() {
        return this.e;
    }

    public String toString() {
        return "Result{success=" + this.success + ", result='" + this.result + '\'' + '}';
    }
}

