/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.hbase.shell;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseShellCommands {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseShellCommands.class);
    private static final String COMMANDS_PATH = "hbase-ruby/shell/commands/";
    private static volatile Set<String> commandsSet;

    private HBaseShellCommands() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> getAllCommands() throws IOException {
        if (commandsSet != null) return commandsSet;
        Class<HBaseShellCommands> clazz = HBaseShellCommands.class;
        synchronized (HBaseShellCommands.class) {
            if (commandsSet != null) return commandsSet;
            TreeSet<String> sortedSet = new TreeSet<String>();
            URL commandFilesUrl = HBaseShellCommands.class.getClassLoader().getResource(COMMANDS_PATH);
            if (commandFilesUrl == null) {
                throw new IOException("The command files path is null!");
            }
            String commandFilePath = commandFilesUrl.getPath();
            File commandFile = new File(commandFilePath);
            if (!commandFile.exists()) {
                LOG.warn("The command files path is not exists, starting read file from jar.");
                String jarPath = commandFilesUrl.toString().substring(0, commandFilesUrl.toString().indexOf("!/") + 2);
                LOG.info("The path in jar is " + jarPath);
                URL jarUrl = new URL(jarPath);
                JarURLConnection jarCon = (JarURLConnection)jarUrl.openConnection();
                JarFile jarFile = jarCon.getJarFile();
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry entry = jarEntries.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || !name.startsWith(COMMANDS_PATH)) continue;
                    String commandName = name.substring(name.lastIndexOf(File.separator) + 1, name.lastIndexOf(".rb"));
                    sortedSet.add(commandName);
                }
            } else {
                String[] files = commandFile.list();
                if (files == null) {
                    throw new IOException("The command files is null!");
                }
                for (String file : files) {
                    if (!file.endsWith(".rb")) continue;
                    sortedSet.add(file.substring(0, file.lastIndexOf(".rb")));
                }
            }
            commandsSet = sortedSet;
            // ** MonitorExit[var0] (shouldn't be in output)
            return commandsSet;
        }
    }

    public static List<String> searchCommand(String subCommand) {
        ArrayList<String> matchCommands = new ArrayList<String>();
        try {
            Set<String> allCommands = HBaseShellCommands.getAllCommands();
            for (String command : allCommands) {
                if (!command.startsWith(subCommand)) continue;
                matchCommands.add(command);
            }
        }
        catch (IOException e) {
            return matchCommands;
        }
        return matchCommands;
    }
}

