/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.hbase.executor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.OverloadUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.common.conf.EngineConnConstant$;
import org.apache.linkis.engineconn.computation.executor.execute.ConcurrentComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.ConcurrentComputationExecutor$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.engineplugin.common.util.NodeResourceUtils$;
import org.apache.linkis.manager.engineplugin.hbase.conf.HBaseConfiguration$;
import org.apache.linkis.manager.engineplugin.hbase.constant.HBaseEngineConnConstant;
import org.apache.linkis.manager.engineplugin.hbase.executor.HBaseEngineConfig$;
import org.apache.linkis.manager.engineplugin.hbase.shell.HBaseShellSession;
import org.apache.linkis.manager.engineplugin.hbase.shell.HBaseShellSessionManager;
import org.apache.linkis.manager.engineplugin.hbase.shell.Result;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.scheduler.executer.AliasOutputExecuteResponse;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.LineMetaData$;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001\u0002\u000f\u001e\u00011B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005u!)\u0011\t\u0001C\u0001\u0005\"9a\t\u0001b\u0001\n\u00139\u0005B\u0002(\u0001A\u0003%\u0001\nC\u0004P\u0001\t\u0007I\u0011\u0002)\t\r!\u0004\u0001\u0015!\u0003R\u0011\u001dI\u0007A1A\u0005\n)Daa\u001c\u0001!\u0002\u0013Y\u0007b\u00029\u0001\u0005\u0004%I!\u001d\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003s\u0011\u001d\ty\u0002\u0001C!\u0003CAq!!\u000b\u0001\t\u0003\nY\u0003C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBA6\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003s\u0002A\u0011IA>\u0011\u001d\t)\n\u0001C!\u0003/Cq!a(\u0001\t\u0003\n\t\u000bC\u0004\u00020\u0002!\t%!-\t\u000f\u0005\r\u0007\u0001\"\u0011\u0002F\"9\u00111\u001c\u0001\u0005B\u0005u\u0007BBAp\u0001\u0011\u0005\u0013\bC\u0004\u0002b\u0002!\t%!\t\t\u000f\u0005\r\b\u0001\"\u0011\u0002f\"9\u00111\u001e\u0001\u0005B\u00055(a\u0006%CCN,WI\\4j]\u0016\u001cuN\u001c8Fq\u0016\u001cW\u000f^8s\u0015\tqr$\u0001\u0005fq\u0016\u001cW\u000f^8s\u0015\t\u0001\u0013%A\u0003iE\u0006\u001cXM\u0003\u0002#G\u0005aQM\\4j]\u0016\u0004H.^4j]*\u0011A%J\u0001\b[\u0006t\u0017mZ3s\u0015\t1s%\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001i\u0003C\u0001\u00187\u001b\u0005y#B\u0001\u00192\u0003\u001d)\u00070Z2vi\u0016T!A\b\u001a\u000b\u0005M\"\u0014aC2p[B,H/\u0019;j_:T!!N\u0013\u0002\u0015\u0015tw-\u001b8fG>tg.\u0003\u00028_\ti2i\u001c8dkJ\u0014XM\u001c;D_6\u0004X\u000f^1uS>tW\t_3dkR|'/\u0001\u0002jIV\t!\b\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDHA\u0002J]R\f1!\u001b3!\u0003\u0019a\u0014N\\5u}Q\u00111)\u0012\t\u0003\t\u0002i\u0011!\b\u0005\u0006q\r\u0001\rAO\u0001\u0014g\",G\u000e\\*fgNLwN\\'b]\u0006<WM]\u000b\u0002\u0011B\u0011\u0011\nT\u0007\u0002\u0015*\u00111jH\u0001\u0006g\",G\u000e\\\u0005\u0003\u001b*\u0013\u0001\u0004\u0013\"bg\u0016\u001c\u0006.\u001a7m'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s\u0003Q\u0019\b.\u001a7m'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3sA\u0005q\u0002NY1tKNCW\r\u001c7UCN\\'+\u001e8oS:<7i\u001c8uC&tWM]\u000b\u0002#B!!kW/^\u001b\u0005\u0019&B\u0001+V\u0003\u0015\u0019\u0017m\u00195f\u0015\t1v+\u0001\u0004d_6lwN\u001c\u0006\u00031f\u000baaZ8pO2,'\"\u0001.\u0002\u0007\r|W.\u0003\u0002]'\n)1)Y2iKB\u0011a,\u001a\b\u0003?\u000e\u0004\"\u0001\u0019\u001f\u000e\u0003\u0005T!AY\u0016\u0002\rq\u0012xn\u001c;?\u0013\t!G(\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u0014aa\u0015;sS:<'B\u00013=\u0003}A'-Y:f'\",G\u000e\u001c+bg.\u0014VO\u001c8j]\u001e\u001cuN\u001c;bS:,'\u000fI\u0001\u0017Q\n\f7/Z*iK2d7+Z:tS>t7)Y2iKV\t1\u000e\u0005\u0003S7vc\u0007CA%n\u0013\tq'JA\tI\u0005\u0006\u001cXm\u00155fY2\u001cVm]:j_:\fq\u0003\u001b2bg\u0016\u001c\u0006.\u001a7m'\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u001d\u0015DXmY;u_Jd\u0015MY3mgV\t!\u000fE\u0002tqjl\u0011\u0001\u001e\u0006\u0003kZ\fA!\u001e;jY*\tq/\u0001\u0003kCZ\f\u0017BA=u\u0005\u0011a\u0015n\u001d;1\u0007m\fY\u0001E\u0003}\u0003\u0007\t9!D\u0001~\u0015\tqx0\u0001\u0004f]RLG/\u001f\u0006\u0004\u0003\u0003\u0019\u0013!\u00027bE\u0016d\u0017bAA\u0003{\n)A*\u00192fYB!\u0011\u0011BA\u0006\u0019\u0001!1\"!\u0004\f\u0003\u0003\u0005\tQ!\u0001\u0002\u0012\t\u0019q\fJ\u0019\u0002\u001f\u0015DXmY;u_Jd\u0015MY3mg\u0002\nB!a\u0005\u0002\u001aA\u00191(!\u0006\n\u0007\u0005]AHA\u0004O_RD\u0017N\\4\u0011\u0007m\nY\"C\u0002\u0002\u001eq\u00121!\u00118z\u0003\u0011Ig.\u001b;\u0015\u0005\u0005\r\u0002cA\u001e\u0002&%\u0019\u0011q\u0005\u001f\u0003\tUs\u0017\u000e^\u0001\fKb,7-\u001e;f\u0019&tW\r\u0006\u0004\u0002.\u0005u\u0012q\t\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003!)\u00070Z2vi\u0016\u0014(bAA\u001cK\u0005I1o\u00195fIVdWM]\u0005\u0005\u0003w\t\tDA\bFq\u0016\u001cW\u000f^3SKN\u0004xN\\:f\u0011\u001d\ty$\u0004a\u0001\u0003\u0003\nQ#\u001a8hS:,W\t_3dkR|'oQ8oi\u0016DH\u000fE\u0002/\u0003\u0007J1!!\u00120\u0005Y)enZ5oK\u0016CXmY;uS>t7i\u001c8uKb$\bBBA%\u001b\u0001\u0007Q,\u0001\u0003d_\u0012,\u0017!F4fi\"\u0013\u0015m]3Sk:$\u0018.\\3QCJ\fWn\u001d\u000b\u0005\u0003\u001f\n)\u0006E\u0003t\u0003#jV,C\u0002\u0002TQ\u00141!T1q\u0011\u001d\tyD\u0004a\u0001\u0003\u0003\nqbZ3u\u000bb,7mQ8eKV\u001bXM\u001d\u000b\u0004;\u0006m\u0003bBA/\u001f\u0001\u0007\u0011\u0011I\u0001\u0017K:<\u0017N\\3Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\tR\r_3dkR,7i\\7qY\u0016$X\r\\=\u0015\u0011\u00055\u00121MA3\u0003OBq!a\u0010\u0011\u0001\u0004\t\t\u0005\u0003\u0004\u0002JA\u0001\r!\u0018\u0005\u0007\u0003S\u0002\u0002\u0019A/\u0002\u001b\r|W\u000e\u001d7fi\u0016$G*\u001b8f\u0003!\u0001(o\\4sKN\u001cH\u0003BA8\u0003k\u00022aOA9\u0013\r\t\u0019\b\u0010\u0002\u0006\r2|\u0017\r\u001e\u0005\u0007\u0003o\n\u0002\u0019A/\u0002\rQ\f7o[%E\u0003=9W\r\u001e)s_\u001e\u0014Xm]:J]\u001a|G\u0003BA?\u0003'\u0003RaOA@\u0003\u0007K1!!!=\u0005\u0015\t%O]1z!\u0011\t))a$\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000ba!\u001a8hS:,'bAAGK\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\u0012\u0006\u001d%a\u0004&pEB\u0013xn\u001a:fgNLeNZ8\t\r\u0005]$\u00031\u0001^\u0003M\u0019X\u000f\u001d9peR\u001c\u0015\r\u001c7CC\u000e\\Gj\\4t)\t\tI\nE\u0002<\u00037K1!!(=\u0005\u001d\u0011un\u001c7fC:\f\u0011cZ3u\u000bb,7-\u001e;pe2\u000b'-\u001a7t)\t\t\u0019\u000b\u0005\u0003tq\u0006\u0015\u0006\u0007BAT\u0003W\u0003R\u0001`A\u0002\u0003S\u0003B!!\u0003\u0002,\u0012Y\u0011Q\u0016\u000b\u0002\u0002\u0003\u0005)\u0011AA\t\u0005\ryFeM\u0001\u0012g\u0016$X\t_3dkR|'\u000fT1cK2\u001cH\u0003BA\u0012\u0003gCq!!.\u0016\u0001\u0004\t9,\u0001\u0004mC\n,Gn\u001d\t\u0005gb\fI\f\r\u0003\u0002<\u0006}\u0006#\u0002?\u0002\u0004\u0005u\u0006\u0003BA\u0005\u0003\u007f#A\"!1\u00024\u0006\u0005\t\u0011!B\u0001\u0003#\u00111a\u0018\u00135\u0003]\u0011X-];fgR,\u0005\u0010]3di\u0016$'+Z:pkJ\u001cW\r\u0006\u0003\u0002H\u0006]\u0007\u0003BAe\u0003'l!!a3\u000b\t\u00055\u0017qZ\u0001\te\u0016\u001cx.\u001e:dK*\u0019a0!5\u000b\u0005Y\u001b\u0013\u0002BAk\u0003\u0017\u0014ABT8eKJ+7o\\;sG\u0016Dq!!7\u0017\u0001\u0004\t9-\u0001\tfqB,7\r^3e%\u0016\u001cx.\u001e:dK\u00061r-\u001a;DkJ\u0014XM\u001c;O_\u0012,'+Z:pkJ\u001cW\r\u0006\u0002\u0002H\u0006\u0011r-\u001a;D_:\u001cWO\u001d:f]Rd\u0015.\\5u\u0003\u001dY\u0017\u000e\u001c7BY2\f\u0001b[5mYR\u000b7o\u001b\u000b\u0005\u0003G\t9\u000f\u0003\u0004\u0002jj\u0001\r!X\u0001\u0007i\u0006\u001c8.\u00133\u0002\u000b\u001d,G/\u00133\u0016\u0003u\u0003")
public class HBaseEngineConnExecutor
extends ConcurrentComputationExecutor {
    private final int id;
    private final HBaseShellSessionManager shellSessionManager;
    private final Cache<String, String> hbaseShellTaskRunningContainer;
    private final Cache<String, HBaseShellSession> hbaseShellSessionCache;
    private final List<Label<?>> executorLabels;

    public int id() {
        return this.id;
    }

    private HBaseShellSessionManager shellSessionManager() {
        return this.shellSessionManager;
    }

    private Cache<String, String> hbaseShellTaskRunningContainer() {
        return this.hbaseShellTaskRunningContainer;
    }

    private Cache<String, HBaseShellSession> hbaseShellSessionCache() {
        return this.hbaseShellSessionCache;
    }

    private List<Label<?>> executorLabels() {
        return this.executorLabels;
    }

    public void init() {
        this.logger().info("hbase executor start init.");
        super.init();
    }

    public ExecuteResponse executeLine(EngineExecutionContext engineExecutorContext, String code) {
        ExecuteResponse executeResponse;
        Object object = new Object();
        try {
            String realCode = code.trim();
            String taskId = (String)engineExecutorContext.getJobId().get();
            ObjectRef properties = ObjectRef.create(Collections.emptyMap());
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                properties$1.elem = this.getHBaseRuntimeParams(engineExecutorContext);
            }, (Function1 & Serializable & scala.Serializable)e -> {
                this.logger().error(new StringBuilder(41).append("try to build hbase runtime params error! ").append(e).toString());
                throw new NonLocalReturnControl(object, (Object)new ErrorExecuteResponse(e.getMessage(), e));
            });
            this.logger().info(new StringBuilder(25).append("The hbase properties is: ").append((Map)properties.elem).toString());
            ObjectRef shellSession = ObjectRef.create(null);
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                shellSession$1.elem = this.shellSessionManager().getHBaseShellSession((Map)properties$1.elem);
                this.hbaseShellSessionCache().put((Object)taskId, (Object)((HBaseShellSession)shellSession$1.elem));
            }, (Function1 & Serializable & scala.Serializable)e -> {
                this.logger().error(new StringBuilder(35).append("created hbase shell session error! ").append(e).toString());
                throw new NonLocalReturnControl(object, (Object)new ErrorExecuteResponse("created hbase shell session error!", e));
            });
            this.hbaseShellTaskRunningContainer().put((Object)taskId, (Object)"1");
            Result result = ((HBaseShellSession)shellSession.elem).execute(realCode);
            this.hbaseShellTaskRunningContainer().invalidate((Object)taskId);
            if (!result.isSuccess()) {
                return new ErrorExecuteResponse(result.getResult(), result.getThrowable());
            }
            ResultSetWriter resultSetWriter = engineExecutorContext.createResultSetWriter(ResultSetFactory$.MODULE$.TEXT_TYPE());
            resultSetWriter.addMetaData((MetaData)new LineMetaData(LineMetaData$.MODULE$.$lessinit$greater$default$1()));
            resultSetWriter.addRecord((Record)new LineRecord(result.getResult()));
            String output = resultSetWriter != null ? resultSetWriter.toString() : null;
            Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((Closeable)resultSetWriter));
            this.logger().info("HBase shell command executed completed.");
            executeResponse = new AliasOutputExecuteResponse(null, output);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                executeResponse = (ExecuteResponse)ex.value();
            }
            throw ex;
        }
        return executeResponse;
    }

    private Map<String, String> getHBaseRuntimeParams(EngineExecutionContext engineExecutorContext) {
        HashMap<String, String> globalConfig;
        block1: {
            String execCodeUser = this.getExecCodeUser(engineExecutorContext);
            HashMap executorProperties = engineExecutorContext.getProperties();
            if (executorProperties == null) {
                executorProperties = new HashMap();
            }
            this.logger().info(new StringBuilder(23).append("executorProperties is: ").append(executorProperties).toString());
            globalConfig = new HashMap<String, String>();
            Utils$.MODULE$.tryAndWarn((Function0 & Serializable & scala.Serializable)() -> HBaseEngineConfig$.MODULE$.getCacheMap(engineExecutorContext.getLabels()), this.logger());
            globalConfig.put(HBaseEngineConnConstant.KERBEROS_PROXY_USER, execCodeUser);
            if (executorProperties.isEmpty()) break block1;
            scala.collection.immutable.Map _executorProperties = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(executorProperties).asScala()).toMap(Predef$.MODULE$.$conforms());
            _executorProperties.foreach((Function1 & Serializable & scala.Serializable)d -> {
                String k = (String)d._1();
                Object v = d._2();
                if (k.startsWith("linkis.")) {
                    return globalConfig.put(k, String.valueOf(v));
                }
                return BoxedUnit.UNIT;
            });
        }
        return globalConfig;
    }

    private String getExecCodeUser(EngineExecutionContext engineExecutionContext) {
        UserCreatorLabel userCreatorLabel = (UserCreatorLabel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])engineExecutionContext.getLabels())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HBaseEngineConnExecutor.$anonfun$getExecCodeUser$1(x$1))).get();
        return userCreatorLabel.getUser();
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutorContext, String code, String completedLine) {
        return null;
    }

    public float progress(String taskID) {
        return 0.0f;
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        return (JobProgressInfo[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(JobProgressInfo.class));
    }

    public boolean supportCallBackLogs() {
        return false;
    }

    public List<Label<?>> getExecutorLabels() {
        return this.executorLabels();
    }

    public void setExecutorLabels(List<Label<?>> labels) {
        if (!CollectionUtils.isEmpty(labels)) {
            this.executorLabels().clear();
            this.executorLabels().addAll(labels);
            return;
        }
    }

    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return null;
    }

    public NodeResource getCurrentNodeResource() {
        NodeResourceUtils$.MODULE$.appendMemoryUnitIfMissing(EngineConnObject$.MODULE$.getEngineCreationContext().getOptions());
        CommonNodeResource resource = new CommonNodeResource();
        LoadResource usedResource = new LoadResource(OverloadUtils$.MODULE$.getProcessMaxMemory(), 1);
        resource.setUsedResource((Resource)usedResource);
        return resource;
    }

    public int getConcurrentLimit() {
        return BoxesRunTime.unboxToInt((Object)HBaseConfiguration$.MODULE$.HBASE_CONCURRENT_LIMIT().getValue());
    }

    public void killAll() {
        this.logger().info("Killing all query task.");
        ConcurrentMap concurrentMap = this.hbaseShellTaskRunningContainer().asMap();
        if (concurrentMap.isEmpty()) {
            return;
        }
        Set taskIdSet = (Set)JavaConverters$.MODULE$.asScalaSetConverter(concurrentMap.keySet()).asScala();
        taskIdSet.foreach((Function1 & Serializable & scala.Serializable)taskId -> {
            this.killTask(taskId);
            return BoxedUnit.UNIT;
        });
        this.logger().info("All query task has killed successfully.");
    }

    public void killTask(String taskId) {
        this.logger().info(new StringBuilder(25).append("Killing hbase query task ").append(taskId).toString());
        HBaseShellSession hbaseShellSession = (HBaseShellSession)this.hbaseShellSessionCache().getIfPresent((Object)taskId);
        if (hbaseShellSession == null) {
            this.logger().info(new StringBuilder(42).append("Can not get hbase shell session by taskId ").append(taskId).toString());
        }
        hbaseShellSession.destroy();
        this.logger().info(new StringBuilder(40).append("The query task ").append(taskId).append(" has killed successfully.").toString());
    }

    public String getId() {
        return new StringBuilder(1).append(Sender$.MODULE$.getThisServiceInstance().getInstance()).append("_").append(this.id()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getExecCodeUser$1(Label x$1) {
        return x$1 instanceof UserCreatorLabel;
    }

    public HBaseEngineConnExecutor(int id) {
        this.id = id;
        super(ConcurrentComputationExecutor$.MODULE$.$lessinit$greater$default$1());
        this.shellSessionManager = HBaseShellSessionManager.getInstance();
        this.hbaseShellTaskRunningContainer = CacheBuilder.newBuilder().maximumSize((long)EngineConnConstant$.MODULE$.MAX_TASK_NUM()).build();
        this.hbaseShellSessionCache = CacheBuilder.newBuilder().maximumSize((long)EngineConnConstant$.MODULE$.MAX_TASK_NUM()).build();
        this.executorLabels = new ArrayList(2);
    }
}

