/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.result;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.types.Row;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;

public class ResultSetJsonSerializer
extends StdSerializer<ResultSet> {
    protected ResultSetJsonSerializer() {
        super(ResultSet.class);
    }

    public void serialize(ResultSet resultSet, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        serializerProvider.defaultSerializeField("result_kind", (Object)resultSet.getResultKind(), jsonGenerator);
        serializerProvider.defaultSerializeField("columns", resultSet.getColumns(), jsonGenerator);
        jsonGenerator.writeFieldName("data");
        jsonGenerator.writeStartArray();
        for (Row row : resultSet.getData()) {
            this.serializeRow(row, jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndArray();
        if (resultSet.getChangeFlags().isPresent()) {
            serializerProvider.defaultSerializeField("change_flags", resultSet.getChangeFlags().get(), jsonGenerator);
        }
        jsonGenerator.writeEndObject();
    }

    private void serializeLocalDate(LocalDate localDate, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeString(localDate.format(DateTimeFormatter.ISO_LOCAL_DATE));
    }

    private void serializeLocalTime(LocalTime localTime, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeString(localTime.format(DateTimeFormatter.ISO_LOCAL_TIME));
    }

    private void serializeLocalDateTime(LocalDateTime localDateTime, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeString(localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }

    private void serializeRow(Row row, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartArray();
        for (int i = 0; i < row.getArity(); ++i) {
            this.serializeObject(row.getField(i), jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndArray();
    }

    private void serializeObject(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (o instanceof LocalDate) {
            this.serializeLocalDate((LocalDate)o, jsonGenerator);
        } else if (o instanceof LocalTime) {
            this.serializeLocalTime((LocalTime)o, jsonGenerator);
        } else if (o instanceof LocalDateTime) {
            this.serializeLocalDateTime((LocalDateTime)o, jsonGenerator);
        } else if (o instanceof Row) {
            this.serializeRow((Row)o, jsonGenerator, serializerProvider);
        } else {
            serializerProvider.defaultSerializeValue(o, jsonGenerator);
        }
    }
}

