/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl;

import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.Environment;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.TableEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.ViewEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlExecutionException;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.NonJobOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.OperationUtil;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;

public class DropViewOperation
implements NonJobOperation {
    private final FlinkEngineConnContext context;
    private final String viewName;
    private final boolean ifExists;

    public DropViewOperation(FlinkEngineConnContext context, String viewName, boolean ifExists) {
        this.context = context;
        this.viewName = viewName;
        this.ifExists = ifExists;
    }

    @Override
    public ResultSet execute() throws SqlExecutionException {
        Environment env = this.context.getExecutionContext().getEnvironment();
        TableEntry tableEntry = (TableEntry)env.getTables().get(this.viewName);
        if (!(tableEntry instanceof ViewEntry) && !this.ifExists) {
            throw new SqlExecutionException("'" + this.viewName + "' " + FlinkErrorCodeSummary.NOT_EXIST_SESSION.getErrorDesc());
        }
        Environment newEnv = env.clone();
        if (newEnv.getTables().remove(this.viewName) != null) {
            ExecutionContext oldExecutionContext = this.context.getExecutionContext();
            oldExecutionContext.wrapClassLoader(tableEnv -> tableEnv.dropTemporaryView(this.viewName));
            ExecutionContext.Builder builder = this.context.newExecutionContextBuilder(this.context.getEnvironmentContext().getDefaultEnv()).env(newEnv).sessionState(this.context.getExecutionContext().getSessionState());
            this.context.setExecutionContext(this.context.getExecutionContext().cloneExecutionContext(builder));
        }
        return OperationUtil.OK;
    }
}

