/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlExecutionException;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.NonJobOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ColumnInfo;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultKind;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;

public class DescribeTableOperation
implements NonJobOperation {
    private final ExecutionContext context;
    private final String tableName;

    public DescribeTableOperation(FlinkEngineConnContext context, String tableName) {
        this.context = context.getExecutionContext();
        this.tableName = tableName;
    }

    @Override
    public ResultSet execute() throws SqlExecutionException {
        List columns;
        TableSchema schema;
        TableEnvironment tableEnv = this.context.getTableEnvironment();
        try {
            schema = this.context.wrapClassLoader(() -> tableEnv.from(this.tableName).getSchema());
        }
        catch (Throwable t) {
            throw new SqlExecutionException(FlinkErrorCodeSummary.NO_TABLE_FOUND.getErrorDesc(), t);
        }
        HashMap<String, String> fieldToWatermark = new HashMap<String, String>();
        for (WatermarkSpec spec : schema.getWatermarkSpecs()) {
            fieldToWatermark.put(spec.getRowtimeAttribute(), spec.getWatermarkExpr());
        }
        HashMap<TableColumn, String> fieldToPrimaryKey = new HashMap<TableColumn, String>();
        if (schema.getPrimaryKey().isPresent()) {
            columns = ((UniqueConstraint)schema.getPrimaryKey().get()).getColumns();
            String primaryKey = "PRI(" + String.join((CharSequence)", ", columns) + ")";
            for (Object column : columns) {
                fieldToPrimaryKey.put((TableColumn)column, primaryKey);
            }
        }
        columns = schema.getTableColumns();
        ArrayList<Row> data = new ArrayList<Row>();
        for (Object column : columns) {
            LogicalType logicalType = column.getType().getLogicalType();
            String name = column.getName();
            String type = StringUtils.removeEnd((String)logicalType.toString(), (String)" NOT NULL");
            boolean isNullable = logicalType.isNullable();
            String key = fieldToPrimaryKey.getOrDefault(column.getName(), null);
            String computedColumn = column.getName();
            String watermark = fieldToWatermark.getOrDefault(column.getName(), null);
            data.add(Row.of((Object[])new Object[]{name, type, isNullable, key, computedColumn, watermark}));
        }
        return ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(ColumnInfo.create("name", DataTypes.STRING().getLogicalType()), ColumnInfo.create("type", DataTypes.STRING().getLogicalType()), ColumnInfo.create("null", (LogicalType)new BooleanType()), ColumnInfo.create("key", DataTypes.STRING().getLogicalType()), ColumnInfo.create("computed_column", DataTypes.STRING().getLogicalType()), ColumnInfo.create("watermark", DataTypes.STRING().getLogicalType())).data(data).build();
    }
}

