/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl;

import org.apache.flink.table.api.TableEnvironment;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.Environment;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.TableEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.ViewEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlExecutionException;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.NonJobOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.OperationUtil;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;

public class CreateViewOperation
implements NonJobOperation {
    private final ExecutionContext context;
    private final String viewName;
    private final String query;

    public CreateViewOperation(FlinkEngineConnContext context, String viewName, String query) {
        this.context = context.getExecutionContext();
        this.viewName = viewName;
        this.query = query;
    }

    @Override
    public ResultSet execute() throws SqlExecutionException {
        Environment env = this.context.getEnvironment();
        TableEntry tableEntry = (TableEntry)env.getTables().get(this.viewName);
        if (tableEntry instanceof ViewEntry) {
            throw new SqlExecutionException("'" + this.viewName + "' " + FlinkErrorCodeSummary.ALREADY_CURRENT_SESSION.getErrorDesc());
        }
        TableEnvironment tableEnv = this.context.getTableEnvironment();
        try {
            this.context.wrapClassLoader(() -> {
                tableEnv.createTemporaryView(this.viewName, tableEnv.sqlQuery(this.query));
                return null;
            });
        }
        catch (Throwable t) {
            throw new SqlExecutionException(FlinkErrorCodeSummary.INVALID_SQL_STATEMENT.getErrorDesc(), t);
        }
        env.getTables().put(this.viewName, ViewEntry.create((String)this.viewName, (String)this.query));
        return OperationUtil.OK;
    }
}

