/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation;

import java.text.MessageFormat;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlParseException;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.Operation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.OperationFactory;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.CreateViewOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.DDLOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.DescribeTableOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.DropViewOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.ExplainOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.InsertOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.ResetOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.SelectOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.SetOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.ShowCatalogsOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.ShowCurrentCatalogOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.ShowCurrentDatabaseOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.ShowDatabasesOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.ShowFunctionsOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.ShowModulesOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.ShowTablesOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.ShowViewsOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.UseCatalogOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.UseDatabaseOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.parser.SqlCommandCall;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;
import org.apache.linkis.engineconnplugin.flink.util.ClassUtil;

public class OperationFactoryImpl
implements OperationFactory {
    private static OperationFactory operationFactory;

    private OperationFactoryImpl() {
    }

    @Override
    public Operation createOperation(SqlCommandCall call, FlinkEngineConnContext context) throws SqlParseException {
        Operation operation;
        switch (call.command) {
            case SELECT: {
                operation = new SelectOperation(context, call.operands[0]);
                break;
            }
            case CREATE_VIEW: {
                operation = new CreateViewOperation(context, call.operands[0], call.operands[1]);
                break;
            }
            case DROP_VIEW: {
                operation = new DropViewOperation(context, call.operands[0], Boolean.parseBoolean(call.operands[1]));
                break;
            }
            case CREATE_TABLE: 
            case CREATE_FUNCTION: 
            case DROP_TABLE: 
            case ALTER_TABLE: 
            case CREATE_CATALOG: 
            case DROP_CATALOG: 
            case CREATE_DATABASE: 
            case DROP_DATABASE: 
            case ALTER_DATABASE: {
                operation = new DDLOperation(context, call.operands[0], call.command);
                break;
            }
            case SET: {
                if (call.operands.length == 0) {
                    operation = new SetOperation(context);
                    break;
                }
                operation = new SetOperation(context, call.operands[0], call.operands[1]);
                break;
            }
            case RESET: {
                if (call.operands.length > 0) {
                    throw new SqlParseException(FlinkErrorCodeSummary.ONLY_RESET_ALL.getErrorDesc());
                }
                operation = new ResetOperation(context);
                break;
            }
            case USE_CATALOG: {
                operation = new UseCatalogOperation(context, call.operands[0]);
                break;
            }
            case USE: {
                operation = new UseDatabaseOperation(context, call.operands[0]);
                break;
            }
            case INSERT_INTO: 
            case INSERT_OVERWRITE: {
                operation = new InsertOperation(context, call.operands[0], call.operands[1]);
                break;
            }
            case SHOW_MODULES: {
                operation = new ShowModulesOperation(context);
                break;
            }
            case SHOW_CATALOGS: {
                operation = new ShowCatalogsOperation(context);
                break;
            }
            case SHOW_CURRENT_CATALOG: {
                operation = new ShowCurrentCatalogOperation(context);
                break;
            }
            case SHOW_DATABASES: {
                operation = new ShowDatabasesOperation(context);
                break;
            }
            case SHOW_CURRENT_DATABASE: {
                operation = new ShowCurrentDatabaseOperation(context);
                break;
            }
            case SHOW_TABLES: {
                operation = new ShowTablesOperation(context);
                break;
            }
            case SHOW_VIEWS: {
                operation = new ShowViewsOperation(context);
                break;
            }
            case SHOW_FUNCTIONS: {
                operation = new ShowFunctionsOperation(context);
                break;
            }
            case DESCRIBE_TABLE: {
                operation = new DescribeTableOperation(context, call.operands[0]);
                break;
            }
            case EXPLAIN: {
                operation = new ExplainOperation(context, call.operands[0]);
                break;
            }
            default: {
                throw new SqlParseException(MessageFormat.format(FlinkErrorCodeSummary.SUPPORTED_COMMAND_CALL.getErrorDesc(), call));
            }
        }
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OperationFactory getInstance() {
        if (operationFactory != null) return operationFactory;
        Class<OperationFactory> clazz = OperationFactory.class;
        synchronized (OperationFactory.class) {
            if (operationFactory != null) return operationFactory;
            operationFactory = ClassUtil.getInstance(OperationFactory.class, new OperationFactoryImpl());
            // ** MonitorExit[var0] (shouldn't be in output)
            return operationFactory;
        }
    }
}

