/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.deployment;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.program.ClusterClientProvider;
import org.apache.flink.kubernetes.KubernetesClusterDescriptor;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.deployment.AbstractSessionClusterDescriptorAdapter;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSessionClusterDescriptorAdapter
extends AbstractSessionClusterDescriptorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesSessionClusterDescriptorAdapter.class);

    public KubernetesSessionClusterDescriptorAdapter(ExecutionContext executionContext) {
        super(executionContext);
    }

    @Override
    public boolean isGloballyTerminalState() throws JobExecutionException {
        boolean isGloballyTerminalState;
        try {
            JobStatus jobStatus = this.getJobStatus();
            isGloballyTerminalState = jobStatus.isGloballyTerminalState();
        }
        catch (JobExecutionException e) {
            if (this.isKubernetesApplicationStopped(e)) {
                isGloballyTerminalState = true;
            }
            throw e;
        }
        return isGloballyTerminalState;
    }

    private boolean isKubernetesApplicationStopped(Throwable e) {
        do {
            String exceptionMessage;
            if (!StringUtils.equals((CharSequence)(exceptionMessage = e.getMessage()), (CharSequence)("The Kubernetes application " + this.kubernetesClusterID + " doesn't run anymore."))) continue;
            LOG.info("{} is stopped.", (Object)this.kubernetesClusterID);
            return true;
        } while ((e = e.getCause()) != null);
        return false;
    }

    @Override
    public void deployCluster() throws JobExecutionException {
        try {
            ClusterSpecification clusterSpecification = this.executionContext.getClusterClientFactory().getClusterSpecification(this.executionContext.getFlinkConfig());
            KubernetesClusterDescriptor clusterDescriptor = this.executionContext.createKubernetesClusterDescriptor();
            ClusterClientProvider clusterClientProvider = clusterDescriptor.deploySessionCluster(clusterSpecification);
            this.kubernetesClusterClient = clusterClientProvider.getClusterClient();
            this.kubernetesClusterID = (String)this.kubernetesClusterClient.getClusterId();
            this.webInterfaceUrl = this.kubernetesClusterClient.getWebInterfaceURL();
        }
        catch (Exception e) {
            throw new JobExecutionException(ExceptionUtils.getRootCauseMessage((Throwable)e), (Throwable)e);
        }
    }

    @Override
    public void setJobId(JobID jobId) {
        super.setJobId(jobId);
    }
}

