/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.server.operator;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.ecm.errorcode.EngineconnServerErrorCodeSummary;
import org.apache.linkis.ecm.server.exception.ECMErrorException;
import org.apache.linkis.ecm.server.operator.EngineConnLogOperator;
import org.apache.linkis.ecm.server.operator.EngineConnYarnLogOperator$;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.StorageUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\f\u0019\u0001\u0015BQA\u000b\u0001\u0005\u0002-Bq!\f\u0001C\u0002\u0013-a\u0006\u0003\u00047\u0001\u0001\u0006Ia\f\u0005\u0006o\u0001!I\u0001\u000f\u0005\u0006'\u0002!\t\u0005\u0016\u0005\u00063\u0002!\tE\u0017\u0005\u0006G\u0002!\t\u0005\u001a\u0005\u0006Y\u0002!\t&\u001c\u0005\u0006k\u0002!IA\u001e\u0005\u0006{\u0002!IA \u0005\u000f\u0003\u000b\u0001\u0001\u0013aA\u0001\u0002\u0013%\u0011qAA\u0006\u000f\u001d\ti\u0001\u0007E\u0001\u0003\u001f1aa\u0006\r\t\u0002\u0005E\u0001B\u0002\u0016\u000e\t\u0003\tI\u0002C\u0005\u0002\u001c5\u0011\r\u0011\"\u0001\u0002\u001e!A\u0011\u0011F\u0007!\u0002\u0013\ty\u0002C\u0005\u0002,5\u0011\r\u0011\"\u0001\u0002.!A\u0011qH\u0007!\u0002\u0013\ty\u0003C\u0005\u0002B5\u0011\r\u0011\"\u0001\u0002D!A\u0011QJ\u0007!\u0002\u0013\t)\u0005C\u0005\u0002P5\u0011\r\u0011\"\u0001\u0002R!A\u0011\u0011L\u0007!\u0002\u0013\t\u0019FA\rF]\u001eLg.Z\"p]:L\u0016M\u001d8M_\u001e|\u0005/\u001a:bi>\u0014(BA\r\u001b\u0003!y\u0007/\u001a:bi>\u0014(BA\u000e\u001d\u0003\u0019\u0019XM\u001d<fe*\u0011QDH\u0001\u0004K\u000el'BA\u0010!\u0003\u0019a\u0017N\\6jg*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dBS\"\u0001\r\n\u0005%B\"!F#oO&tWmQ8o]2{wm\u00149fe\u0006$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"a\n\u0001\u0002\u0005\u0019\u001cX#A\u0018\u0011\u0005A\"T\"A\u0019\u000b\u00055\u0012$BA\u001a\u001f\u0003\u001d\u0019Ho\u001c:bO\u0016L!!N\u0019\u0003\u0015\u0019KG.Z*zgR,W.A\u0002gg\u0002\nq\"_1s]2{wMR3uG\",'o]\u000b\u0002sA!!(Q\"Q\u001b\u0005Y$B\u0001\u001f>\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003}}\nA!\u001e;jY*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\"<\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003\t6s!!R&\u0011\u0005\u0019KU\"A$\u000b\u0005!#\u0013A\u0002\u001fs_>$hHC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015*\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001'J!\rQ\u0014kQ\u0005\u0003%n\u0012aAR;ukJ,\u0017\u0001C4fi:\u000bW.Z:\u0016\u0003U\u00032AV,D\u001b\u0005I\u0015B\u0001-J\u0005\u0015\t%O]1z\u0003\u0015\t\u0007\u000f\u001d7z)\tY\u0016\r\u0005\u0003E9\u000es\u0016BA/P\u0005\ri\u0015\r\u001d\t\u0003-~K!\u0001Y%\u0003\u0007\u0005s\u0017\u0010C\u0003c\r\u0001\u000f1,\u0001\u0006qCJ\fW.\u001a;feN\f!bZ3u\u0019><\u0007+\u0019;i)\t)7\u000e\u0005\u0002gS6\tqM\u0003\u0002i\u007f\u0005\u0011\u0011n\\\u0005\u0003U\u001e\u0014AAR5mK\")!m\u0002a\u00027\u0006qq-\u001a;MS:,\u0007+\u0019;uKJtW#\u00018\u0011\u0005=\u001cX\"\u00019\u000b\u0005E\u0014\u0018\u0001C7bi\u000eD\u0017N\\4\u000b\u0005yJ\u0015B\u0001;q\u0005\u0015\u0011VmZ3y\u0003Y\u0011X-];fgR$vNR3uG\"L\u0016M\u001d8M_\u001e\u001cH\u0003\u0002)xsnDQ\u0001_\u0005A\u0002\r\u000bqa\u0019:fCR|'\u000fC\u0003{\u0013\u0001\u00071)A\u0007baBd\u0017nY1uS>t\u0017\n\u001a\u0005\u0006y&\u0001\raQ\u0001\u000bs\u0006\u0014h\u000eT8h\t&\u0014\u0018\u0001D:vI>\u001cu.\\7b]\u0012\u001cH\u0003B+\u0000\u0003\u0003AQ\u0001\u001f\u0006A\u0002\rCa!a\u0001\u000b\u0001\u0004\u0019\u0015aB2p[6\fg\u000eZ\u0001\fgV\u0004XM\u001d\u0013baBd\u0017\u0010F\u0002\\\u0003\u0013AQAY\u0006A\u0004mK!!\u0017\u0015\u00023\u0015sw-\u001b8f\u0007>tg.W1s]2{wm\u00149fe\u0006$xN\u001d\t\u0003O5\u00192!DA\n!\r1\u0016QC\u0005\u0004\u0003/I%AB!osJ+g\r\u0006\u0002\u0002\u0010\u0005iq\nU#S\u0003R{%k\u0018(B\u001b\u0016+\"!a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n@\u0003\u0011a\u0017M\\4\n\u00079\u000b\u0019#\u0001\bP!\u0016\u0013\u0016\tV(S?:\u000bU*\u0012\u0011\u0002+e\u000b%KT0M\u001f\u001e{6\u000bV(S\u0003\u001e+u\fU!U\u0011V\u0011\u0011q\u0006\t\u0006\u0003c\tYdQ\u0007\u0003\u0003gQA!!\u000e\u00028\u0005!1m\u001c8g\u0015\r\tIDH\u0001\u0007G>lWn\u001c8\n\t\u0005u\u00121\u0007\u0002\u000b\u0007>lWn\u001c8WCJ\u001c\u0018AF-B%:{FjT$`'R{%+Q$F?B\u000bE\u000b\u0013\u0011\u0002+e\u000b%KT0M\u001f\u001e{f)\u0012+D\u0011~#\u0006JU#B\tV\u0011\u0011Q\t\t\u0007\u0003c\tY$a\u0012\u0011\u0007Y\u000bI%C\u0002\u0002L%\u00131!\u00138u\u0003YI\u0016I\u0015(`\u0019>;uLR#U\u0007\"{F\u000b\u0013*F\u0003\u0012\u0003\u0013\u0001G-B%:{FjT$`\r\u0016#6\tS0T\u0007\"+E)\u0016'F%V\u0011\u00111\u000b\t\u0004u\u0005U\u0013bAA,w\tyQ\t_3dkR|'oU3sm&\u001cW-A\rZ\u0003Jsu\fT(H?\u001a+Ek\u0011%`'\u000eCU\tR+M\u000bJ\u0003\u0003")
public class EngineConnYarnLogOperator
extends EngineConnLogOperator {
    private final FileSystem org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$fs = (FileSystem)FSFactory$.MODULE$.getFs(StorageUtils$.MODULE$.FILE());

    public static ExecutorService YARN_LOG_FETCH_SCHEDULER() {
        return EngineConnYarnLogOperator$.MODULE$.YARN_LOG_FETCH_SCHEDULER();
    }

    public static CommonVars<Object> YARN_LOG_FETCH_THREAD() {
        return EngineConnYarnLogOperator$.MODULE$.YARN_LOG_FETCH_THREAD();
    }

    public static CommonVars<String> YARN_LOG_STORAGE_PATH() {
        return EngineConnYarnLogOperator$.MODULE$.YARN_LOG_STORAGE_PATH();
    }

    public static String OPERATOR_NAME() {
        return EngineConnYarnLogOperator$.MODULE$.OPERATOR_NAME();
    }

    private /* synthetic */ scala.collection.immutable.Map super$apply(scala.collection.immutable.Map parameters) {
        return super.apply((scala.collection.immutable.Map<String, Object>)parameters);
    }

    public FileSystem org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$fs() {
        return this.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$fs;
    }

    public ConcurrentHashMap<String, Future<String>> org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$yarnLogFetchers() {
        return new ConcurrentHashMap<String, Future<String>>();
    }

    @Override
    public String[] getNames() {
        return (String[])((Object[])new String[]{EngineConnYarnLogOperator$.MODULE$.OPERATOR_NAME()});
    }

    @Override
    public scala.collection.immutable.Map<String, Object> apply(scala.collection.immutable.Map<String, Object> parameters) {
        ObjectRef result = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        return (scala.collection.immutable.Map)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> {
            result$1.elem = this.super$apply(parameters);
            return (scala.collection.immutable.Map)result$1.elem;
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
    }

    @Override
    public File getLogPath(scala.collection.immutable.Map<String, Object> parameters) {
        FsPath rootLogPath;
        FsPath fsPath;
        String applicationId = (String)this.getAsThrow("yarnApplicationId", parameters);
        Tuple3<String, String, String> tuple3 = this.getEngineConnInfo(parameters);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String ticketId = (String)tuple3._1();
        String engineConnInstance = (String)tuple3._2();
        String engineConnLogDir = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)ticketId, (Object)engineConnInstance, (Object)engineConnLogDir);
        String ticketId2 = (String)tuple32._1();
        String engineConnInstance2 = (String)tuple32._2();
        String engineConnLogDir2 = (String)tuple32._3();
        String string = (String)EngineConnYarnLogOperator$.MODULE$.YARN_LOG_STORAGE_PATH().getValue();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            FsPath logPath = new FsPath(new StringBuilder(1).append(StorageUtils$.MODULE$.FILE_SCHEMA()).append(string).append("/").append(applicationId).toString());
            this.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$fs().mkdir(logPath);
            this.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$fs().setPermission(logPath, "rwxrwxrwx");
            fsPath = logPath;
        } else {
            fsPath = rootLogPath = new FsPath(new StringBuilder(0).append(StorageUtils$.MODULE$.FILE_SCHEMA()).append(engineConnLogDir2).toString());
        }
        if (!this.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$fs().exists(rootLogPath) || !rootLogPath.toFile().isDirectory()) {
            throw new ECMErrorException(EngineconnServerErrorCodeSummary.LOG_IS_NOT_EXISTS.getErrorCode(), MessageFormat.format(EngineconnServerErrorCodeSummary.LOG_IS_NOT_EXISTS.getErrorDesc(), rootLogPath.getPath()));
        }
        String creator = (String)this.getAsThrow("creator", parameters);
        FsPath logPath = new FsPath(new StringBuilder(6).append(StorageUtils$.MODULE$.FILE_SCHEMA()).append(rootLogPath.getPath()).append("/yarn_").append(applicationId).toString());
        if (!this.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$fs().exists(logPath)) {
            Future<String> fetcher = this.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$yarnLogFetchers().computeIfAbsent(applicationId, new Function<String, Future<String>>(this, creator, applicationId, rootLogPath){
                private final /* synthetic */ EngineConnYarnLogOperator $outer;
                private final String creator$1;
                private final String applicationId$1;
                private final FsPath rootLogPath$1;

                public <V> Function<V, Future<String>> compose(Function<? super V, ? extends String> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<String, V> andThen(Function<? super Future<String>, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Future<String> apply(String v1) {
                    return this.$outer.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$requestToFetchYarnLogs(this.creator$1, this.applicationId$1, this.rootLogPath$1.getPath());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.creator$1 = creator$1;
                    this.applicationId$1 = applicationId$1;
                    this.rootLogPath$1 = rootLogPath$1;
                }
            });
            Option option = Option$.MODULE$.apply((Object)fetcher.get(5L, TimeUnit.SECONDS));
            if (option instanceof Some) {
                Some some = (Some)option;
                String path = (String)some.value();
                logPath = new FsPath(new StringBuilder(0).append(StorageUtils$.MODULE$.FILE_SCHEMA()).append(path).toString());
            }
        }
        if (!this.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$fs().exists(logPath) || logPath.toFile().isDirectory()) {
            throw new ECMErrorException(EngineconnServerErrorCodeSummary.LOGFILE_IS_NOT_EXISTS.getErrorCode(), MessageFormat.format(EngineconnServerErrorCodeSummary.LOGFILE_IS_NOT_EXISTS.getErrorDesc(), logPath.getPath()));
        }
        this.logger().info(new StringBuilder(77).append("Try to fetch EngineConn(id: ").append(ticketId2).append(", instance: ").append(engineConnInstance2).append(") yarn logs from ").append(logPath.getPath()).append(" in application id: ").append(applicationId).toString());
        return logPath.toFile();
    }

    @Override
    public Regex getLinePattern() {
        return null;
    }

    public Future<String> org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$requestToFetchYarnLogs(String creator, String applicationId, String yarnLogDir) {
        return EngineConnYarnLogOperator$.MODULE$.YARN_LOG_FETCH_SCHEDULER().submit(new Callable<String>(this, yarnLogDir, applicationId, creator){
            private final /* synthetic */ EngineConnYarnLogOperator $outer;
            private final String yarnLogDir$1;
            private final String applicationId$2;
            private final String creator$2;

            public String call() {
                Object object;
                FsPath logPath = new FsPath(new StringBuilder(6).append(StorageUtils$.MODULE$.FILE_SCHEMA()).append(this.yarnLogDir$1).append("/yarn_").append(this.applicationId$2).toString());
                if (!this.$outer.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$fs().exists(logPath)) {
                    String tempLogFile = new StringBuilder(8).append(".yarn_").append(this.applicationId$2).append("_").append(System.currentTimeMillis()).append("_").append(Thread.currentThread().getId()).toString();
                    Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
                        String command = new StringBuilder(30).append("yarn logs -applicationId ").append($this.applicationId$2).append(" >> ").append($this.yarnLogDir$1).append("/").append(tempLogFile).toString();
                        $this.$outer.logger().info(new StringBuilder(37).append("Fetch yarn logs to temporary file: [").append(command).append("]").toString());
                        ProcessBuilder processBuilder = new ProcessBuilder($this.$outer.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$sudoCommands($this.creator$2, command));
                        processBuilder.environment().putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)package$.MODULE$.env()).asJava());
                        processBuilder.redirectErrorStream(false);
                        Process process = processBuilder.start();
                        int exitCode = process.waitFor();
                        $this.$outer.logger().trace(new StringBuilder(52).append("Finish to fetch yan logs to temporary file, result: ").append(exitCode).toString());
                        if (exitCode == 0) {
                            command = new StringBuilder(11).append("mv ").append($this.yarnLogDir$1).append("/").append(tempLogFile).append(" ").append($this.yarnLogDir$1).append("/yarn_").append($this.applicationId$2).toString();
                            $this.$outer.logger().info(new StringBuilder(29).append("Move and save yarn logs(").append($this.applicationId$2).append("): [").append(command).append("]").toString());
                            return Utils$.MODULE$.exec($this.$outer.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$sudoCommands($this.creator$2, command));
                        }
                        return BoxedUnit.UNIT;
                    }, (Function1 & Serializable & scala.Serializable)e -> {
                        $anon$2.$anonfun$call$2(this, e);
                        return BoxedUnit.UNIT;
                    });
                    File tmpFile = new File(this.yarnLogDir$1, tempLogFile);
                    if (tmpFile.exists()) {
                        this.$outer.logger().info(new StringBuilder(46).append("Delete temporary file: [").append(tempLogFile).append("] in yarn logs fetcher").toString());
                        object = BoxesRunTime.boxToBoolean((boolean)tmpFile.delete());
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                this.$outer.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$yarnLogFetchers().remove(this.applicationId$2);
                if (this.$outer.org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$fs().exists(logPath)) {
                    return logPath.getPath();
                }
                return null;
            }

            public static final /* synthetic */ void $anonfun$call$2($anon$2 $this, Throwable e) {
                $this.$outer.logger().error(new StringBuilder(48).append("Fail to fetch yarn logs application: ").append($this.applicationId$2).append(", message: ").append(e.getMessage()).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.yarnLogDir$1 = yarnLogDir$1;
                this.applicationId$2 = applicationId$2;
                this.creator$2 = creator$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$call$1(org.apache.linkis.ecm.server.operator.EngineConnYarnLogOperator$$anon$2 java.lang.String ), $anonfun$call$2$adapted(org.apache.linkis.ecm.server.operator.EngineConnYarnLogOperator$$anon$2 java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    public String[] org$apache$linkis$ecm$server$operator$EngineConnYarnLogOperator$$sudoCommands(String creator, String command) {
        return (String[])((Object[])new String[]{"/bin/bash", "-c", new StringBuilder(44).append("sudo su ").append(creator).append(" -c \"source ~/.bashrc 2>/dev/null; ").append(command).append("\"").toString()});
    }
}

