/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.datasourcemanager.common.domain.DataSource;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceEnv;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.common.domain.DatasourceVersion;
import org.apache.linkis.datasourcemanager.common.exception.JsonErrorException;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.datasourcemanager.core.dao.DataSourceDao;
import org.apache.linkis.datasourcemanager.core.dao.DataSourceEnvDao;
import org.apache.linkis.datasourcemanager.core.dao.DataSourceParamKeyDao;
import org.apache.linkis.datasourcemanager.core.dao.DataSourceVersionDao;
import org.apache.linkis.datasourcemanager.core.formdata.FormStreamContent;
import org.apache.linkis.datasourcemanager.core.service.BmlAppService;
import org.apache.linkis.datasourcemanager.core.service.DataSourceInfoService;
import org.apache.linkis.datasourcemanager.core.service.DataSourceRelateService;
import org.apache.linkis.datasourcemanager.core.service.hooks.DataSourceParamsHook;
import org.apache.linkis.datasourcemanager.core.vo.DataSourceEnvVo;
import org.apache.linkis.datasourcemanager.core.vo.DataSourceVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataSourceInfoServiceImpl
implements DataSourceInfoService {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceInfoService.class);
    @Autowired
    private BmlAppService bmlAppService;
    @Autowired
    private DataSourceDao dataSourceDao;
    @Autowired
    private DataSourceEnvDao dataSourceEnvDao;
    @Autowired
    private DataSourceParamKeyDao dataSourceParamKeyDao;
    @Autowired
    private DataSourceVersionDao dataSourceVersionDao;
    @Autowired
    private DataSourceRelateService dataSourceRelateService;
    @Autowired
    private List<DataSourceParamsHook> dataSourceParamsHooks = new ArrayList<DataSourceParamsHook>();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveDataSourceInfo(DataSource dataSource) throws ErrorException {
        this.dataSourceDao.insertOne(dataSource);
    }

    @Override
    public void addEnvParamsToDataSource(Long dataSourceEnvId, DataSource dataSource) {
        DataSourceEnv dataSourceEnv = this.dataSourceEnvDao.selectOneDetail(dataSourceEnvId);
        if (null != dataSourceEnv) {
            Map envParamMap = dataSourceEnv.getConnectParams();
            envParamMap.putAll(dataSource.getConnectParams());
            dataSource.setConnectParams(envParamMap);
        }
    }

    @Override
    public DataSource getDataSourceInfo(Long dataSourceId) {
        DataSource dataSource = this.dataSourceDao.selectOneDetail(dataSourceId);
        if (Objects.nonNull(dataSource)) {
            this.mergeVersionParams(dataSource, dataSource.getVersionId());
        }
        return dataSource;
    }

    @Override
    public DataSource getDataSourceInfo(String dataSourceName) {
        DataSource dataSource = this.dataSourceDao.selectOneDetailByName(dataSourceName);
        if (Objects.nonNull(dataSource)) {
            this.mergeVersionParams(dataSource, dataSource.getVersionId());
        }
        return dataSource;
    }

    @Override
    public DataSource getDataSourcePublishInfo(String dataSourceName) {
        DataSource dataSource = this.dataSourceDao.selectOneDetailByName(dataSourceName);
        if (Objects.nonNull(dataSource)) {
            Long publishedVersionId = dataSource.getPublishedVersionId();
            if (publishedVersionId == null) {
                LOG.warn("Datasource name:{} is not published. ", (Object)dataSourceName);
            } else {
                String parameter = this.dataSourceVersionDao.selectOneVersion(dataSource.getId(), publishedVersionId);
                dataSource.setParameter(parameter);
            }
        }
        return dataSource;
    }

    @Override
    public DataSource getDataSourceInfo(Long dataSourceId, Long version) {
        DataSource dataSource = this.dataSourceDao.selectOneDetail(dataSourceId);
        if (Objects.nonNull(dataSource)) {
            this.mergeVersionParams(dataSource, version);
        }
        return dataSource;
    }

    @Override
    public DataSource getDataSourceInfoForConnect(Long dataSourceId) {
        DataSource dataSource = this.dataSourceDao.selectOneDetail(dataSourceId);
        if (Objects.nonNull(dataSource)) {
            this.mergeVersionParams(dataSource, dataSource.getPublishedVersionId());
            this.mergeEnvParamsByDefault(dataSource);
        }
        return dataSource;
    }

    @Override
    public DataSource getDataSourceInfoForConnect(String dataSourceName) {
        DataSource dataSource = this.dataSourceDao.selectOneDetailByName(dataSourceName);
        if (Objects.nonNull(dataSource)) {
            this.mergeVersionParams(dataSource, dataSource.getPublishedVersionId());
            this.mergeEnvParamsByDefault(dataSource);
        }
        return dataSource;
    }

    @Override
    public DataSource getDataSourceInfoForConnect(String dataSourceName, String envId) {
        DataSource dataSource = this.dataSourceDao.selectOneDetailByName(dataSourceName);
        if (Objects.nonNull(dataSource)) {
            this.mergeVersionParams(dataSource, dataSource.getPublishedVersionId());
            this.mergeEnvParamsByEnvId(dataSource, envId);
        }
        return dataSource;
    }

    private void mergeEnvParamsByEnvId(DataSource dataSource, String specialEnvId) {
        List<String> envIdList = this.getEnvIdsFrom(dataSource);
        if (envIdList.contains(specialEnvId)) {
            this.addEnvParamsToDataSource(Long.valueOf(specialEnvId), dataSource);
        }
    }

    private void mergeEnvParamsByDefault(DataSource dataSource) {
        List<String> envIdList = this.getEnvIdsFrom(dataSource);
        if (CollectionUtils.isNotEmpty(envIdList)) {
            this.addEnvParamsToDataSource(Long.valueOf(envIdList.get(0)), dataSource);
        }
    }

    private List<String> getEnvIdsFrom(DataSource dataSource) {
        Object envIdArray;
        Map connectParams = dataSource.getConnectParams();
        if (connectParams.containsKey("envId")) {
            String envId = connectParams.get("envId").toString();
            connectParams.remove("envId");
            return Arrays.asList(envId);
        }
        if (connectParams.containsKey("envIdArray") && (envIdArray = connectParams.get("envIdArray")) instanceof List) {
            List envIdList = (List)envIdArray;
            connectParams.remove("envIdArray");
            return envIdList;
        }
        return Collections.emptyList();
    }

    @Override
    public DataSource getDataSourceInfoForConnect(Long dataSourceId, Long version) {
        DataSource dataSource = this.dataSourceDao.selectOneDetail(dataSourceId);
        if (Objects.nonNull(dataSource)) {
            this.mergeVersionParams(dataSource, version);
            this.mergeEnvParamsByDefault(dataSource);
        }
        return dataSource;
    }

    @Override
    public boolean existDataSource(String dataSourceName) {
        if (StringUtils.isNotBlank((CharSequence)dataSourceName)) {
            DataSource dataSource = this.dataSourceDao.selectOneByName(dataSourceName);
            return Objects.nonNull(dataSource);
        }
        return false;
    }

    @Override
    public boolean existDataSourceEnv(String dataSourceEnvName) {
        if (StringUtils.isNotBlank((CharSequence)dataSourceEnvName)) {
            DataSourceEnv dataSourceEnv = this.dataSourceEnvDao.selectOneByName(dataSourceEnvName);
            return Objects.nonNull(dataSourceEnv);
        }
        return false;
    }

    @Override
    public DataSource getDataSourceInfoBrief(Long dataSourceId) {
        return this.dataSourceDao.selectOne(dataSourceId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long removeDataSourceInfo(Long dataSourceId, String createSystem) {
        int affect;
        DataSource dataSource = this.dataSourceDao.selectOne(dataSourceId);
        if (null != dataSource && (affect = this.dataSourceDao.removeOne(dataSourceId)) > 0) {
            int versionNum = this.dataSourceVersionDao.removeFromDataSourceId(dataSourceId);
            return dataSourceId;
        }
        return -1L;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDataSourceInfo(DataSource updatedOne) {
        this.dataSourceDao.updateOne(updatedOne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageInfo<DataSource> queryDataSourceInfoPage(DataSourceVo dataSourceVo) {
        PageHelper.startPage((int)dataSourceVo.getCurrentPage(), (int)dataSourceVo.getPageSize());
        try {
            List<DataSource> queryList = this.dataSourceDao.selectByPageVo(dataSourceVo);
            PageInfo pageInfo = new PageInfo(queryList);
            return pageInfo;
        }
        finally {
            PageHelper.clearPage();
        }
    }

    @Override
    public List<DataSource> queryDataSourceInfo(List ids) {
        List<DataSource> queryList = this.dataSourceDao.selectByIds(ids);
        return queryList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveDataSourceEnv(DataSourceEnv dataSourceEnv) throws ErrorException {
        this.storeConnectParams(dataSourceEnv.getCreateUser(), dataSourceEnv.getKeyDefinitions(), dataSourceEnv.getConnectParams(), parameter -> {
            dataSourceEnv.setParameter(parameter);
            this.dataSourceEnvDao.insertOne(dataSourceEnv);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveBatchDataSourceEnv(List<DataSourceEnv> dataSourceEnvList) throws ErrorException {
        for (DataSourceEnv dataSourceEnv : dataSourceEnvList) {
            this.storeConnectParams(dataSourceEnv.getCreateUser(), dataSourceEnv.getKeyDefinitions(), dataSourceEnv.getConnectParams(), parameter -> {
                dataSourceEnv.setParameter(parameter);
                this.dataSourceEnvDao.insertOne(dataSourceEnv);
            });
        }
    }

    @Override
    public List<DataSourceEnv> listDataSourceEnvByType(Long dataSourceTypeId) {
        return this.dataSourceEnvDao.listByTypeId(dataSourceTypeId);
    }

    @Override
    public DataSourceEnv getDataSourceEnv(Long envId) {
        return this.dataSourceEnvDao.selectOneDetail(envId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long removeDataSourceEnv(Long envId) {
        int affect;
        DataSourceEnv dataSourceEnv = this.dataSourceEnvDao.selectOneDetail(envId);
        if (null != dataSourceEnv && (affect = this.dataSourceEnvDao.removeOne(envId)) > 0) {
            Map connectParams = dataSourceEnv.getConnectParams();
            List<DataSourceParamKeyDefinition> keyDefinitions = this.dataSourceParamKeyDao.listByDataSourceTypeAndScope(dataSourceEnv.getDataSourceTypeId(), DataSourceParamKeyDefinition.Scope.ENV);
            keyDefinitions.forEach(keyDefinition -> {
                if (keyDefinition.getValueType() == DataSourceParamKeyDefinition.ValueType.FILE && connectParams.containsKey(keyDefinition.getKey())) {
                    try {
                        this.bmlAppService.clientRemoveResource(dataSourceEnv.getCreateUser(), String.valueOf(connectParams.get(keyDefinition.getKey())));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return envId;
        }
        return -1L;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDataSourceEnv(DataSourceEnv updatedOne, DataSourceEnv storedOne) throws ErrorException {
        this.updateConnectParams(updatedOne.getCreateUser(), updatedOne.getKeyDefinitions(), updatedOne.getConnectParams(), storedOne.getConnectParams(), parameter -> {
            updatedOne.setParameter(parameter);
            this.dataSourceEnvDao.updateOne(updatedOne);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBatchDataSourceEnv(List<DataSourceEnv> dataSourceEnvList) throws ErrorException {
        for (DataSourceEnv updatedOne : dataSourceEnvList) {
            DataSourceEnv storedOne = this.getDataSourceEnv(updatedOne.getId());
            this.updateConnectParams(updatedOne.getCreateUser(), updatedOne.getKeyDefinitions(), updatedOne.getConnectParams(), storedOne.getConnectParams(), parameter -> {
                updatedOne.setParameter(parameter);
                this.dataSourceEnvDao.updateOne(updatedOne);
            });
        }
    }

    @Override
    public List<DataSourceEnv> queryDataSourceEnvPage(DataSourceEnvVo dataSourceEnvVo) {
        PageHelper.startPage((int)dataSourceEnvVo.getCurrentPage(), (int)dataSourceEnvVo.getPageSize());
        List<DataSourceEnv> queryList = this.dataSourceEnvDao.selectByPageVo(dataSourceEnvVo);
        PageInfo pageInfo = new PageInfo(queryList);
        return pageInfo.getList();
    }

    @Override
    public Long expireDataSource(Long dataSourceId) {
        int affect;
        DataSource dataSource = this.dataSourceDao.selectOne(dataSourceId);
        if (null != dataSource && (affect = this.dataSourceDao.expireOne(dataSourceId)) > 0) {
            return dataSourceId;
        }
        return -1L;
    }

    @Override
    public int publishByDataSourceId(Long dataSourceId, Long versionId) {
        Long latestVersion = this.dataSourceVersionDao.getLatestVersion(dataSourceId);
        if (versionId > latestVersion) {
            return 0;
        }
        return this.dataSourceDao.setPublishedVersionId(dataSourceId, versionId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long insertDataSourceParameter(List<DataSourceParamKeyDefinition> keyDefinitionList, Long datasourceId, Map<String, Object> connectParams, String username, String comment) throws ErrorException {
        DatasourceVersion datasourceVersion = new DatasourceVersion();
        datasourceVersion.setCreateUser(username);
        datasourceVersion.setDatasourceId(datasourceId);
        if (null != comment) {
            datasourceVersion.setComment(comment);
        }
        Long latestVersion = this.dataSourceVersionDao.getLatestVersion(datasourceId);
        long newVersionId = latestVersion + 1L;
        datasourceVersion.setVersionId(Long.valueOf(newVersionId));
        List definedKeyNames = keyDefinitionList.stream().map(DataSourceParamKeyDefinition::getKey).collect(Collectors.toList());
        for (DataSourceParamsHook hook : this.dataSourceParamsHooks) {
            hook.beforePersist(connectParams, keyDefinitionList);
        }
        datasourceVersion.setParameter(Json.toJson(connectParams, null));
        this.dataSourceVersionDao.insertOne(datasourceVersion);
        this.dataSourceDao.updateVersionId(datasourceId, newVersionId);
        return newVersionId;
    }

    @Override
    public List<DatasourceVersion> getVersionList(Long datasourceId) {
        List<DatasourceVersion> versionList = this.dataSourceVersionDao.getVersionsFromDatasourceId(datasourceId);
        return versionList;
    }

    private void updateConnectParams(String userName, List<DataSourceParamKeyDefinition> keyDefinitionList, Map<String, Object> updatedParams, Map<String, Object> storedParams, Consumer<String> parameterCallback) throws ErrorException {
        List definedKeyNames = keyDefinitionList.stream().map(DataSourceParamKeyDefinition::getKey).collect(Collectors.toList());
        ArrayList<String> uploadedResources = new ArrayList<String>();
        try {
            updatedParams.entrySet().removeIf(entry -> {
                if (!definedKeyNames.contains(entry.getKey())) {
                    return true;
                }
                Object paramValue = entry.getValue();
                if (paramValue instanceof FormStreamContent) {
                    String resourceId = String.valueOf(storedParams.getOrDefault(entry.getKey(), ""));
                    if (StringUtils.isNotBlank((CharSequence)resourceId)) {
                        this.uploadFormStream(userName, (FormStreamContent)paramValue, resourceId);
                    } else {
                        resourceId = this.uploadFormStream(userName, (FormStreamContent)paramValue, "");
                    }
                    if (null == resourceId) {
                        return true;
                    }
                    uploadedResources.add(resourceId);
                    entry.setValue(resourceId);
                }
                storedParams.remove(entry.getKey());
                return false;
            });
            ArrayList<String> duplicateResources = new ArrayList<String>();
            keyDefinitionList.forEach(definedKey -> {
                if (definedKey.getValueType() == DataSourceParamKeyDefinition.ValueType.FILE && storedParams.containsKey(definedKey.getKey())) {
                    duplicateResources.add(String.valueOf(storedParams.get(definedKey.getKey())));
                }
            });
            for (DataSourceParamsHook hook : this.dataSourceParamsHooks) {
                hook.beforePersist(updatedParams, keyDefinitionList);
            }
            parameterCallback.accept(Json.toJson(updatedParams, null));
            this.deleteResources(userName, duplicateResources);
        }
        catch (Exception e) {
            this.deleteResources(userName, uploadedResources);
            if (e.getCause() instanceof ErrorException) {
                throw (ErrorException)e.getCause();
            }
            throw e;
        }
    }

    private void storeConnectParams(String userName, List<DataSourceParamKeyDefinition> keyDefinitionList, Map<String, Object> connectParams, Consumer<String> parameterCallback) throws ErrorException {
        List definedKeyNames = keyDefinitionList.stream().map(DataSourceParamKeyDefinition::getKey).collect(Collectors.toList());
        ArrayList<String> uploadedResources = new ArrayList<String>();
        try {
            connectParams.entrySet().removeIf(entry -> {
                if (!definedKeyNames.contains(entry.getKey())) {
                    return true;
                }
                Object paramValue = entry.getValue();
                if (paramValue instanceof FormStreamContent) {
                    String resourceId = this.uploadFormStream(userName, (FormStreamContent)paramValue, "");
                    if (null == resourceId) {
                        return true;
                    }
                    uploadedResources.add(resourceId);
                    entry.setValue(resourceId);
                }
                return false;
            });
            for (DataSourceParamsHook hook : this.dataSourceParamsHooks) {
                hook.beforePersist(connectParams, keyDefinitionList);
            }
            parameterCallback.accept(Json.toJson(connectParams, null));
        }
        catch (Exception e) {
            this.deleteResources(userName, uploadedResources);
            if (e.getCause() instanceof ErrorException) {
                throw (ErrorException)e.getCause();
            }
            throw e;
        }
    }

    private String uploadFormStream(String userName, FormStreamContent streamContent, String resourceId) {
        String fileName = streamContent.getFileName();
        InputStream inputStream = streamContent.getStream();
        if (null != inputStream) {
            try {
                return StringUtils.isBlank((CharSequence)resourceId) ? this.bmlAppService.clientUploadResource(userName, fileName, inputStream) : this.bmlAppService.clientUpdateResource(userName, resourceId, inputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void deleteResources(String userName, List<String> uploadedResources) {
        if (!uploadedResources.isEmpty()) {
            for (String resourceId : uploadedResources) {
                try {
                    this.bmlAppService.clientRemoveResource(userName, resourceId);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void mergeVersionParams(DataSource dataSource, Long version) {
        if (Objects.isNull(version)) {
            return;
        }
        Map connectParams = dataSource.getConnectParams();
        String versionParameter = this.dataSourceVersionDao.selectOneVersion(dataSource.getId(), version);
        if (StringUtils.isNotBlank((CharSequence)versionParameter)) {
            try {
                connectParams.putAll((Map)Objects.requireNonNull(Json.fromJson((String)versionParameter, Map.class, (Class[])new Class[0])));
            }
            catch (JsonErrorException e) {
                LOG.warn("Parameter is not json string");
            }
        }
    }
}

