/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.operator.once;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.job.JobStatus;
import org.apache.linkis.cli.application.entity.operator.JobOper;
import org.apache.linkis.cli.application.entity.var.VarAccess;
import org.apache.linkis.cli.application.exception.LinkisClientExecutionException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.job.common.LinkisJobStatus;
import org.apache.linkis.cli.application.operator.once.OnceJobDesc;
import org.apache.linkis.cli.application.operator.ujes.UJESClientFactory;
import org.apache.linkis.computation.client.LinkisJobBuilder$;
import org.apache.linkis.computation.client.once.simple.SimpleOnceJob;
import org.apache.linkis.computation.client.once.simple.SimpleOnceJobBuilder;
import org.apache.linkis.computation.client.once.simple.SubmittableSimpleOnceJob;
import org.apache.linkis.computation.client.operator.impl.EngineConnLogOperator;
import org.apache.linkis.computation.client.operator.impl.EngineConnLogs;

public class OnceJobOper
implements JobOper {
    EngineConnLogOperator logOperator = null;
    private SimpleOnceJob onceJob;
    private String serverUrl;
    private String engineTypeForECM;
    private Boolean isLogFin = false;

    public void init(OnceJobDesc desc) {
        String engineTypeRaw;
        VarAccess varAccess = desc.getVarAccess();
        this.serverUrl = varAccess.getVar(String.class, "wds.linkis.client.common.gatewayUrl");
        LinkisJobBuilder$.MODULE$.setDefaultClientConfig(UJESClientFactory.generateDWSClientConfig(varAccess));
        LinkisJobBuilder$.MODULE$.setDefaultUJESClient(UJESClientFactory.getReusable(varAccess));
        this.engineTypeForECM = engineTypeRaw = (String)desc.getLabelMap().get("engineType");
        this.engineTypeForECM = StringUtils.isNotBlank((CharSequence)engineTypeRaw) ? StringUtils.split((String)engineTypeRaw, (String)"-")[0] : "";
        this.onceJob = (SimpleOnceJob)new SimpleOnceJobBuilder().setCreateService("LinkisCli").addExecuteUser(desc.getProxyUser()).setStartupParams(desc.getParamConfMap()).setLabels(desc.getLabelMap()).setRuntimeParams(desc.getParamRunTimeMap()).setSource(desc.getSourceMap()).setVariableMap(desc.getParamVarsMap()).setJobContent(desc.getJobContentMap()).build();
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public SimpleOnceJob getOnceJob() {
        return this.onceJob;
    }

    public void setOnceJob(SimpleOnceJob onceJob) {
        this.onceJob = onceJob;
    }

    private void panicIfNull(Object obj) {
        if (obj == null) {
            throw new LinkisClientExecutionException("EXE0040", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "Instance of <Unknown> is null");
        }
    }

    public void submit() {
        this.panicIfNull(this.onceJob);
        if (!(this.onceJob instanceof SubmittableSimpleOnceJob)) {
            throw new LinkisClientExecutionException("EXE0041", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "onceJob is not properly initiated");
        }
        ((SubmittableSimpleOnceJob)this.onceJob).submit();
    }

    public void kill() {
        this.panicIfNull(this.onceJob);
        if (!this.getStatus().isJobFinishedState()) {
            this.onceJob.kill();
        }
    }

    public String getJobID() {
        return this.onceJob.getId();
    }

    public String getUser() {
        return "TODO";
    }

    public JobStatus getStatus() {
        this.panicIfNull(this.onceJob);
        String status = this.onceJob.getStatus();
        return LinkisJobStatus.convertFromNodeStatusString(status);
    }

    public void waitForComplete() {
        this.panicIfNull(this.onceJob);
        this.onceJob.waitForCompleted();
    }

    public String getCurrentLog() {
        this.panicIfNull(this.onceJob);
        if (this.logOperator == null) {
            this.logOperator = (EngineConnLogOperator)this.onceJob.getOperator(EngineConnLogOperator.OPERATOR_NAME());
            this.logOperator.setECMServiceInstance(((SubmittableSimpleOnceJob)this.onceJob).getECMServiceInstance());
            this.logOperator.setEngineConnType(this.engineTypeForECM);
            this.logOperator.setIgnoreKeywords("[SpringContextShutdownHook],[main]");
        }
        EngineConnLogs logs = (EngineConnLogs)this.logOperator.apply();
        StringBuilder logBuilder = new StringBuilder();
        for (String log : logs.logs()) {
            logBuilder.append(log).append(System.lineSeparator());
        }
        String status = this.onceJob.getStatus();
        LinkisJobStatus jobStatus = LinkisJobStatus.convertFromNodeStatusString(status);
        if ((logs.logs() == null || logs.logs().size() <= 0) && jobStatus.isJobFinishedState()) {
            this.isLogFin = true;
        }
        return logBuilder.toString();
    }

    public Boolean isLogFin() {
        return this.isLogFin;
    }
}

