/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.var;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.command.ParamItem;
import org.apache.linkis.cli.application.entity.command.Params;
import org.apache.linkis.cli.application.entity.var.VarAccess;
import org.apache.linkis.cli.application.exception.VarAccessException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.command.SpecialMap;
import org.apache.linkis.cli.application.interactor.command.template.converter.AbstractStringConverter;
import org.apache.linkis.cli.application.interactor.command.template.converter.PredefinedStringConverters;
import org.apache.linkis.cli.application.interactor.properties.ClientProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VarAccessImpl
implements VarAccess {
    private static Logger logger = LoggerFactory.getLogger(VarAccessImpl.class);
    private Params cmdParams;
    private ClientProperties userConf;
    private ClientProperties defaultConf;
    private Map<String, String> subMapCache;

    public VarAccessImpl setCmdParams(Params cmdParams) {
        this.cmdParams = cmdParams;
        return this;
    }

    public Params getSubParam(String identifier) {
        return this.cmdParams;
    }

    public VarAccessImpl setUserConf(ClientProperties userConf) {
        this.userConf = userConf;
        return this;
    }

    public ClientProperties getUserConf(String identifier) {
        return this.userConf;
    }

    public VarAccessImpl setDefaultConf(ClientProperties defaultConf) {
        this.defaultConf = defaultConf;
        return this;
    }

    public ClientProperties getDefaultConf(String identifier) {
        return this.defaultConf;
    }

    public VarAccessImpl init() {
        this.subMapCache = new HashMap<String, String>();
        this.putSubMapCache(this.subMapCache, this.cmdParams);
        return this;
    }

    private void putSubMapCache(Map<String, String> subMapCache, Params param) {
        for (ParamItem item : param.getParamItemMap().values()) {
            if (item.getValue() == null || !item.hasVal() || !(item.getValue() instanceof Map) || item.getValue() instanceof SpecialMap) continue;
            try {
                Map subMap = (Map)item.getValue();
                for (Map.Entry entry : subMap.entrySet()) {
                    if (subMapCache.containsKey(item.getKey())) {
                        logger.warn("Value of duplicated key \"{}\" in subMap \"{}\" will be ignored.", (Object)item.getKey(), (Object)item.getKey());
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey())) || !StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                    subMapCache.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (ClassCastException e) {
                logger.warn("Param: {} has an unsupported Map type(not Map<String, String>). It wiil be ignored", (Object)item.getKey());
            }
        }
    }

    public void checkInit() {
        if (this.cmdParams == null || this.defaultConf == null || this.subMapCache == null) {
            throw new VarAccessException("VA0002", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.VarAccessInitErr, "stdVarAccess is not inited. cmdParams: " + this.cmdParams + "defaultConf: " + this.defaultConf + "subMapCache: " + this.subMapCache);
        }
    }

    @Override
    public <T> T getVarOrDefault(Class<T> clazz, String key, T defaultValue) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        T val = this.getVar(clazz, key);
        return val != null ? val : defaultValue;
    }

    @Override
    public <T> T getVar(Class<T> clazz, String key) {
        this.checkInit();
        if (key == null || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        T p1 = this.getVarFromParam(clazz, key, this.cmdParams);
        T pd1 = this.getDefaultVarFromParam(clazz, key, this.cmdParams);
        T c1 = this.getVarFromCfg(clazz, key, this.userConf);
        T c2 = this.getVarFromCfg(clazz, key, this.defaultConf);
        return p1 != null ? p1 : (c1 != null ? c1 : (c2 != null ? c2 : pd1));
    }

    private <T> T getVarFromParam(Class<T> clazz, String key, Params params) {
        Object v3;
        if (params == null || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Object v1 = params.getParamItemMap().containsKey(key) && params.getParamItemMap().get(key).hasVal() ? this.setNullIfEmpty(params.getParamItemMap().get(key).getValue()) : null;
        Object v2 = this.setNullIfEmpty(this.convertStringVal(clazz, this.subMapCache.getOrDefault(key, null)));
        Object object = v3 = params.getExtraProperties() == null ? null : this.setNullIfEmpty(params.getExtraProperties().getOrDefault(key, null));
        Object retObj = v1 != null ? v1 : (v2 != null ? v2 : v3);
        return clazz.cast(retObj);
    }

    private boolean paramHasVar(String key, Params params) {
        boolean b1 = params.getParamItemMap().containsKey(key) && params.getParamItemMap().get(key).hasVal();
        boolean b2 = this.subMapCache.containsKey(key);
        boolean b3 = params.getExtraProperties().containsKey(key);
        return b1 || b2 || b3;
    }

    private <T> T getDefaultVarFromParam(Class<T> clazz, String key, Params params) {
        if (params == null || StringUtils.isBlank((CharSequence)key) || !params.getParamItemMap().containsKey(key)) {
            return null;
        }
        Object vd = this.setNullIfEmpty(params.getParamItemMap().get(key).getDefaultValue());
        return clazz.cast(vd);
    }

    private <T> T getVarFromCfg(Class<T> clazz, String key, ClientProperties conf) {
        String strVal;
        if (conf == null) {
            return null;
        }
        Object val = conf.get(key);
        if (val == null) {
            return null;
        }
        try {
            strVal = (String)val;
        }
        catch (ClassCastException e) {
            throw new VarAccessException("VA0003", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.VarAccessErr, "Cannot getVar \"" + key + "\" from config. Cause: value is not String");
        }
        return this.convertStringVal(clazz, strVal);
    }

    private Object setNullIfEmpty(Object obj) {
        Object ret = obj instanceof String && StringUtils.isBlank((CharSequence)((String)obj)) ? null : (obj instanceof Map && ((Map)obj).size() == 0 ? null : (obj instanceof Collections && ((Collection)obj).size() == 0 ? null : obj));
        return ret;
    }

    private boolean cfgHasVar(String key, ClientProperties conf) {
        return conf == null ? false : conf.containsKey(key);
    }

    private <T> T convertStringVal(Class<T> clazz, String strVal) {
        Object ret;
        if (StringUtils.isBlank((CharSequence)strVal)) {
            return null;
        }
        if (clazz == Object.class) {
            ret = strVal;
        } else if (clazz == String.class) {
            ret = this.convertGivenConverter(strVal, PredefinedStringConverters.NO_CONVERTER);
        } else if (clazz == Integer.class) {
            ret = this.convertGivenConverter(strVal, PredefinedStringConverters.INT_CONVERTER);
        } else if (clazz == Long.class) {
            ret = this.convertGivenConverter(strVal, PredefinedStringConverters.LONG_CONVERTER);
        } else if (clazz == Boolean.class) {
            ret = this.convertGivenConverter(strVal, PredefinedStringConverters.BOOLEAN_CONVERTER);
        } else if (Map.class.isAssignableFrom(clazz)) {
            ret = null;
        } else if (clazz == String[].class) {
            ret = null;
        } else {
            throw new VarAccessException("VA0004", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.VarAccessErr, "Cannot convertStringVal \"" + strVal + "\" to " + clazz.getCanonicalName() + ": designated type is not supported");
        }
        return clazz.cast(ret);
    }

    private <T> T convertGivenConverter(String strVal, AbstractStringConverter<T> converter) {
        return (T)converter.convert(strVal);
    }

    @Override
    public String[] getAllVarKeys() {
        ArrayList<String> varKeys = new ArrayList<String>();
        this.addParamVarKeys(varKeys, this.cmdParams);
        this.addPropsVarKeys(varKeys, this.userConf);
        this.addPropsVarKeys(varKeys, this.defaultConf);
        return varKeys.toArray(new String[varKeys.size()]);
    }

    private void addParamVarKeys(List<String> varKeys, Params param) {
        if (param != null) {
            for (String key : param.getParamItemMap().keySet()) {
                if (varKeys.contains(key)) continue;
                varKeys.add(key);
            }
            for (String key : this.subMapCache.keySet()) {
                if (varKeys.contains(key)) continue;
                varKeys.add(key);
            }
            for (String key : param.getExtraProperties().keySet()) {
                if (varKeys.contains(key)) continue;
                varKeys.add(key);
            }
        }
    }

    private void addPropsVarKeys(List<String> varKeys, ClientProperties props) {
        if (props != null) {
            for (Object key : props.keySet()) {
                if (varKeys.contains(key)) continue;
                varKeys.add((String)key);
            }
        }
    }

    @Override
    public boolean hasVar(String key) {
        boolean b1 = this.paramHasVar(key, this.cmdParams);
        boolean b2 = this.cfgHasVar(key, this.userConf);
        boolean b3 = this.cfgHasVar(key, this.defaultConf);
        return b1 || b2 || b3;
    }
}

