/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.command.template.option;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.interactor.command.template.converter.AbstractStringConverter;
import org.apache.linkis.cli.application.interactor.command.template.option.BaseOption;

public class Parameter<T>
extends BaseOption<T>
implements Cloneable {
    final String paramName;

    public Parameter(String keyPrefix, String key, String paramName, String description, boolean isOptional, AbstractStringConverter<T> converter, T defaultValue) {
        super(keyPrefix, key, description, isOptional, defaultValue, converter);
        this.paramName = paramName;
    }

    @Override
    public String getParamName() {
        return this.paramName;
    }

    public String repr() {
        String temp = this.accepctArrayValue() ? this.paramName + " ... " : this.paramName;
        return this.isOptional() ? "[" + temp + "]" : "<" + temp + ">";
    }

    public String toString() {
        Object defaultValue = this.getDefaultValue();
        String description = this.getDescription();
        StringBuilder sb = new StringBuilder();
        sb.append("\t").append(this.paramName).append(" <").append(defaultValue.getClass().getSimpleName()).append(">").append(System.lineSeparator());
        sb.append("\t\t").append(description).append(System.lineSeparator());
        sb.append("\t\tdefault by: ").append(defaultValue.getClass().isArray() ? StringUtils.join((Object[])((Object[])defaultValue), (String)", ") : defaultValue.toString()).append(System.lineSeparator());
        sb.append("\t\toptional:").append(this.isOptional());
        return sb.toString();
    }

    public boolean accepctArrayValue() {
        Object defaultValue = this.getDefaultValue();
        return defaultValue.getClass().isArray();
    }

    @Override
    public Parameter<T> clone() throws CloneNotSupportedException {
        return (Parameter)super.clone();
    }
}

