/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.obf;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.apache.kylin.tool.obf.FileObfuscator;
import org.apache.kylin.tool.obf.MappingRecorder;
import org.apache.kylin.tool.obf.ObfLevel;
import org.apache.kylin.tool.obf.ResultRecorder;

public abstract class PropertiesFileObfuscator
extends FileObfuscator {
    protected PropertiesFileObfuscator(ObfLevel level, MappingRecorder recorder, ResultRecorder resultRecorder) {
        super(level, recorder, resultRecorder);
    }

    abstract void obfuscateProperties(Properties var1);

    @Override
    void doObfuscateFile(File orig) {
        String path = orig.getAbsolutePath();
        Properties p = this.readProperties(orig);
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(orig), Charset.defaultCharset()));){
            for (Map.Entry<Object, Object> kv : p.entrySet()) {
                bw.write(kv.getKey() + "=" + kv.getValue());
                bw.newLine();
            }
            bw.flush();
            logger.info("{} processed successfully", (Object)path);
            this.resultRecorder.addSuccessFile(path);
        }
        catch (IOException e) {
            logger.info("{} processed failed", (Object)path);
            this.resultRecorder.addFailedFile(path);
        }
    }

    private Properties readProperties(File orig) {
        Properties p = new Properties();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(orig));){
            p.load(in);
            this.obfuscateProperties(p);
        }
        catch (Exception e) {
            logger.info("Failed to load properties file:{}.", (Object)orig.getAbsolutePath(), (Object)e);
        }
        return p;
    }
}

