/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.KylinTableCCCleanup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinTableCCCleanupCLI
extends ExecutableApplication {
    private static final Logger logger = LoggerFactory.getLogger(KylinTableCCCleanupCLI.class);
    private static final Option OPTION_CLEANUP = new Option("c", "cleanup", false, "Cleanup the computed columns in table metadata.");
    private static final Option OPTION_PROJECTS = new Option("p", "projects", true, "Specify projects to cleanup.");
    private static final Option OPTION_HELP = new Option("h", "help", false, "Print usage of KapTableCCCleanupCLI");
    private boolean cleanup = false;

    public static void main(String[] args) {
        int exit = 0;
        try {
            new KylinTableCCCleanupCLI().execute(args);
        }
        catch (Throwable e) {
            exit = 1;
            logger.warn("Fail to cleanup table cc.", e);
        }
        Unsafe.systemExit((int)exit);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_CLEANUP);
        options.addOption(OPTION_PROJECTS);
        options.addOption(OPTION_HELP);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        boolean hasOptionProjects;
        if (this.printUsage(optionsHelper)) {
            return;
        }
        boolean hasOptionCleanup = optionsHelper.hasOption(OPTION_CLEANUP);
        if (hasOptionCleanup) {
            this.cleanup = true;
        }
        List<String> projects = (hasOptionProjects = optionsHelper.hasOption(OPTION_PROJECTS)) ? Arrays.asList(optionsHelper.getOptionValue(OPTION_PROJECTS).split(",")) : NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
        logger.info("Cleanup option value: '{}', projects {}", (Object)this.cleanup, projects);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        KylinTableCCCleanup kapTableCCCleanup = new KylinTableCCCleanup(config, this.cleanup, projects);
        kapTableCCCleanup.scanAllTableCC();
        System.out.println("Done. Detailed Message is at ${KYLIN_HOME}/logs/shell.stderr");
    }

    private boolean printUsage(OptionsHelper optionsHelper) {
        boolean help = optionsHelper.hasOption(OPTION_HELP);
        if (help) {
            optionsHelper.printUsage(((Object)((Object)this)).getClass().getName(), this.getOptions());
        }
        return help;
    }
}

