/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.kerberos;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Shell;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.tool.kerberos.KerberosLoginUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class KerberosLoginTask {
    private static final Logger logger = LoggerFactory.getLogger(KerberosLoginTask.class);
    private static final Configuration KRB_CONF = new Configuration();
    private KapConfig kapConfig;

    public void execute() {
        this.kapConfig = KapConfig.getInstanceFromEnv();
        if (this.kapConfig.isKerberosEnabled()) {
            Preconditions.checkState((boolean)KerberosLoginUtil.checkKeyTabIsExist(this.kapConfig.getKerberosKeytabPath()), (Object)("The key tab is not exist : " + this.kapConfig.getKerberosKeytabPath()));
            Preconditions.checkState((boolean)KerberosLoginUtil.checkKeyTabIsValid(this.kapConfig.getKerberosKeytabPath()), (Object)("The key tab is invalid : " + this.kapConfig.getKerberosKeytabPath()));
            try {
                this.reInitTGT();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void reInitTGT() throws IOException {
        this.renewKerberosTicketQuietly();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        KerberosLoginTask.this.sleepQuietly(KerberosLoginTask.this.kapConfig.getKerberosTicketRefreshInterval() * 60L * 1000L);
                        KerberosLoginTask.this.renewKerberosTicketQuietly();
                    }
                }
                catch (Exception e) {
                    logger.error("unexpected exception", (Throwable)e);
                    return;
                }
            }
        });
        t.setDaemon(true);
        t.setName("TGT Reinit for " + UserGroupInformation.getLoginUser().getUserName());
        t.start();
        Thread kerberosMonitor = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        KerberosLoginTask.this.lookKerberosTicketQuietly();
                        KerberosLoginTask.this.sleepQuietly(KerberosLoginTask.this.kapConfig.getKerberosMonitorInterval() * 60L * 1000L);
                    }
                }
                catch (Exception e) {
                    logger.error("unexpected exception", (Throwable)e);
                    return;
                }
            }
        });
        kerberosMonitor.setDaemon(true);
        kerberosMonitor.setName("Kerberos monitor for " + UserGroupInformation.getLoginUser().getUserName());
        kerberosMonitor.start();
    }

    private void sleepQuietly(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            logger.warn("sleep interrupted", (Throwable)e);
        }
    }

    private void renewKerberosTicketQuietly() {
        try {
            logger.info("kinit -kt " + this.kapConfig.getKerberosKeytabPath() + " " + this.kapConfig.getKerberosPrincipal());
            Shell.execCommand((String[])new String[]{"kinit", "-kt", this.kapConfig.getKerberosKeytabPath(), this.kapConfig.getKerberosPrincipal()});
            logger.info("Login " + this.kapConfig.getKerberosPrincipal() + " from keytab: " + this.kapConfig.getKerberosKeytabPath() + ".");
            if (this.kapConfig.getKerberosPlatform().equals("Standard")) {
                this.loginStandardKerberos();
            } else if (this.kapConfig.getKerberosPlatform().equals("FI") || this.kapConfig.getKerberosPlatform().equals("TDH")) {
                this.loginNonStandardKerberos();
            }
        }
        catch (Exception e) {
            logger.error("Error renew kerberos ticket", (Throwable)e);
        }
    }

    private void loginNonStandardKerberos() throws IOException {
        String zkServerPrincipal = this.kapConfig.getKerberosZKPrincipal();
        if (Boolean.TRUE.equals(this.kapConfig.getPlatformZKEnable())) {
            Unsafe.setProperty((String)"zookeeper.sasl.client", (String)"true");
        }
        String jaasFilePath = this.kapConfig.getKerberosJaasConfPath();
        Unsafe.setProperty((String)"java.security.auth.login.config", (String)jaasFilePath);
        Unsafe.setProperty((String)"java.security.krb5.conf", (String)this.kapConfig.getKerberosKrb5ConfPath());
        KerberosLoginUtil.setJaasConf("Client", this.kapConfig.getKerberosPrincipal(), this.kapConfig.getKerberosKeytabPath());
        if (Boolean.TRUE.equals(this.kapConfig.getPlatformZKEnable())) {
            KerberosLoginUtil.setZookeeperServerPrincipal(zkServerPrincipal);
        }
        KerberosLoginUtil.login(this.kapConfig.getKerberosPrincipal(), this.kapConfig.getKerberosKeytabPath(), this.kapConfig.getKerberosKrb5ConfPath(), KRB_CONF);
    }

    private void loginStandardKerberos() throws IOException {
        UserGroupInformation.loginUserFromKeytab((String)this.kapConfig.getKerberosPrincipal(), (String)this.kapConfig.getKerberosKeytabPath());
        logger.info("Login kerberos success.");
    }

    private void lookKerberosTicketQuietly() {
        try {
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            logger.info("current user :" + currentUser);
            Credentials credentials = currentUser.getCredentials();
            logger.info("Current user has " + credentials.getAllTokens().size() + " token.");
            Collection allTokens = credentials.getAllTokens();
            for (Token token : allTokens) {
                TokenIdentifier tokenIdentifier = token.decodeIdentifier();
                logger.info(tokenIdentifier.toString());
            }
            if (!allTokens.isEmpty()) {
                logger.info("Current user should have 0 token but there are non-zero. ReLogin current user: " + currentUser.getUserName());
                this.renewKerberosTicketQuietly();
            }
        }
        catch (Exception e) {
            logger.error("Error showing kerberos tokens", (Throwable)e);
        }
    }
}

