/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.source.ISampleDataDeployer;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.hive.HiveClientFactory;
import org.apache.kylin.source.hive.HiveTableMeta;
import org.apache.kylin.source.hive.IHiveClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetadataExplorer
implements ISourceMetadataExplorer,
ISampleDataDeployer {
    public static final Logger logger = LoggerFactory.getLogger(HiveMetadataExplorer.class);
    IHiveClient hiveClient = HiveClientFactory.getHiveClient();

    private static String getHiveDataType(String javaDataType) {
        String hiveDataType = javaDataType.toLowerCase(Locale.ROOT).startsWith("varchar") ? "string" : javaDataType;
        hiveDataType = javaDataType.toLowerCase(Locale.ROOT).startsWith("integer") ? "int" : hiveDataType;
        return hiveDataType.toLowerCase(Locale.ROOT);
    }

    public List<String> listDatabases() throws Exception {
        return this.hiveClient.getHiveDbNames();
    }

    public List<String> listTables(String database) throws Exception {
        return this.hiveClient.getHiveTableNames(database);
    }

    public Pair<TableDesc, TableExtDesc> loadTableMetadata(String database, String tableName, String prj) {
        HiveTableMeta hiveTableMeta;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NTableMetadataManager metaMgr = NTableMetadataManager.getInstance((KylinConfig)config, (String)prj);
        try {
            hiveTableMeta = this.hiveClient.getHiveTableMeta(database, tableName);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot get HiveTableMeta", e);
        }
        TableDesc tableDesc = metaMgr.getTableDesc(database + "." + tableName);
        if (tableDesc == null) {
            tableDesc = new TableDesc();
            tableDesc.setDatabase(database.toUpperCase(Locale.ROOT));
            tableDesc.setName(tableName.toUpperCase(Locale.ROOT));
            tableDesc.setUuid(RandomUtil.randomUUIDStr());
            tableDesc.setLastModified(0L);
        } else {
            tableDesc = new TableDesc(tableDesc);
        }
        if (hiveTableMeta.tableType != null) {
            tableDesc.setTableType(hiveTableMeta.tableType);
        }
        tableDesc.setRangePartition(this.checkIsRangePartitionTable(hiveTableMeta.allColumns));
        int columnNumber = hiveTableMeta.allColumns.size();
        List<ColumnDesc> columns = this.getColumnDescs(hiveTableMeta.allColumns);
        tableDesc.setColumns(columns.toArray(new ColumnDesc[columnNumber]));
        StringBuilder partitionColumnString = new StringBuilder();
        int n = hiveTableMeta.partitionColumns.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                partitionColumnString.append(", ");
            }
            partitionColumnString.append(hiveTableMeta.partitionColumns.get((int)i).name.toUpperCase(Locale.ROOT));
        }
        TableExtDesc tableExtDesc = new TableExtDesc();
        tableExtDesc.setIdentity(tableDesc.getIdentity());
        tableExtDesc.setUuid(RandomUtil.randomUUIDStr());
        tableExtDesc.setLastModified(0L);
        tableExtDesc.init(prj);
        tableExtDesc.addDataSourceProp("location", hiveTableMeta.sdLocation);
        tableExtDesc.addDataSourceProp("owner", hiveTableMeta.owner);
        tableExtDesc.addDataSourceProp("last_access_time", String.valueOf(hiveTableMeta.lastAccessTime));
        tableExtDesc.addDataSourceProp("partition_column", partitionColumnString.toString());
        tableExtDesc.addDataSourceProp("total_file_size", String.valueOf(hiveTableMeta.fileSize));
        tableExtDesc.addDataSourceProp("total_file_number", String.valueOf(hiveTableMeta.fileNum));
        tableExtDesc.addDataSourceProp("hive_inputFormat", hiveTableMeta.sdInputFormat);
        tableExtDesc.addDataSourceProp("hive_outputFormat", hiveTableMeta.sdOutputFormat);
        tableExtDesc.addDataSourceProp("skip_header_line_count", String.valueOf(hiveTableMeta.skipHeaderLineCount));
        return Pair.newPair((Object)tableDesc, (Object)tableExtDesc);
    }

    public List<ColumnDesc> getColumnDescs(List<HiveTableMeta.HiveTableColumnMeta> columnMetaList) {
        ArrayList<ColumnDesc> columns = new ArrayList<ColumnDesc>(columnMetaList.size());
        HashSet columnCacheTemp = Sets.newHashSet();
        IntStream.range(0, columnMetaList.size()).forEach(i -> {
            HiveTableMeta.HiveTableColumnMeta field = (HiveTableMeta.HiveTableColumnMeta)columnMetaList.get(i);
            if (columnCacheTemp.contains(field.name)) {
                logger.info("The\u3010{}\u3011column is already included and does not need to be added again", (Object)field.name);
                return;
            }
            columnCacheTemp.add(field.name);
            ColumnDesc cdesc = new ColumnDesc();
            cdesc.setName(field.name.toUpperCase(Locale.ROOT));
            if ("float".equalsIgnoreCase(field.dataType)) {
                cdesc.setDatatype("double");
            } else {
                cdesc.setDatatype(field.dataType);
            }
            cdesc.setId(String.valueOf(i + 1));
            cdesc.setComment(field.comment);
            columns.add(cdesc);
        });
        return columns;
    }

    public boolean checkIsRangePartitionTable(List<HiveTableMeta.HiveTableColumnMeta> columnMetas) {
        return columnMetas.stream().collect(Collectors.groupingBy(p -> p.name)).values().stream().anyMatch(p -> p.size() > 1);
    }

    public List<String> getRelatedKylinResources(TableDesc table) {
        return Collections.emptyList();
    }

    public boolean checkDatabaseAccess(String database) throws Exception {
        return true;
    }

    public boolean checkTablesAccess(Set<String> tables) {
        return true;
    }

    public Set<String> getTablePartitions(String database, String table, String prj, String partitionCols) {
        throw new UnsupportedOperationException();
    }

    public void createSampleDatabase(String database) throws Exception {
        this.hiveClient.executeHQL(this.generateCreateSchemaSql(database));
    }

    private String generateCreateSchemaSql(String schemaName) {
        return String.format(Locale.ROOT, "CREATE DATABASE IF NOT EXISTS %s", schemaName);
    }

    public void createSampleTable(TableDesc table) throws Exception {
        this.hiveClient.executeHQL(this.generateCreateTableSql(table));
    }

    private String[] generateCreateTableSql(TableDesc tableDesc) {
        String dropsql = "DROP TABLE IF EXISTS " + tableDesc.getIdentity();
        String dropsql2 = "DROP VIEW IF EXISTS " + tableDesc.getIdentity();
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE TABLE " + tableDesc.getIdentity() + "\n");
        ddl.append("(\n");
        for (int i = 0; i < tableDesc.getColumns().length; ++i) {
            ColumnDesc col = tableDesc.getColumns()[i];
            if (i > 0) {
                ddl.append(",");
            }
            ddl.append(col.getName() + " " + HiveMetadataExplorer.getHiveDataType(col.getDatatype()) + "\n");
        }
        ddl.append(")\n");
        ddl.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY ','\n");
        ddl.append("STORED AS TEXTFILE");
        return new String[]{dropsql, dropsql2, ddl.toString()};
    }

    public void loadSampleData(String tableName, String tmpDataDir) throws Exception {
        this.hiveClient.executeHQL(this.generateLoadDataSql(tableName, tmpDataDir));
    }

    private String generateLoadDataSql(String tableName, String tableFileDir) {
        return "LOAD DATA LOCAL INPATH '" + tableFileDir + "/" + tableName + ".csv' OVERWRITE INTO TABLE " + tableName;
    }

    public void createWrapperView(String origTableName, String viewName) throws Exception {
        this.hiveClient.executeHQL(this.generateCreateViewSql(viewName, origTableName));
    }

    private String[] generateCreateViewSql(String viewName, String tableName) {
        String dropView = "DROP VIEW IF EXISTS " + viewName;
        String dropTable = "DROP TABLE IF EXISTS " + viewName;
        String createSql = "CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName;
        return new String[]{dropView, dropTable, createSql};
    }
}

