/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.softaffinity;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftAffinityBookKeeping {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SoftAffinityBookKeeping.class);
    private static final ThreadLocal<LinkedHashMap<String, String>> THREAD = new ThreadLocal();
    private static final int MAX_ENTRIES = 20;

    private SoftAffinityBookKeeping() {
    }

    public static void recordAsk(String file, String[] locations) {
        String loc;
        LinkedHashMap<String, String> book = SoftAffinityBookKeeping.getBook();
        String existing = book.putIfAbsent(file, loc = String.join((CharSequence)"|", locations));
        if (existing != null && !existing.contains(loc)) {
            book.put(file, existing + "|" + loc);
        }
    }

    @NotNull
    private static LinkedHashMap<String, String> getBook() {
        LinkedHashMap<String, String> book = THREAD.get();
        if (book == null) {
            book = new LinkedHashMap<String, String>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                    return this.size() > 20;
                }
            };
            THREAD.set(book);
        }
        return book;
    }

    public static Map<String, String> audit() {
        LinkedHashMap<String, String> book = SoftAffinityBookKeeping.getBook();
        ImmutableMap ret = ImmutableMap.copyOf(book);
        book.clear();
        return ret;
    }

    public static void logAudits() {
        List lines = SoftAffinityBookKeeping.audit().entrySet().stream().map(e -> (String)e.getKey() + " -> " + (String)e.getValue()).collect(Collectors.toList());
        log.debug("Past few mappings of location -> executors: \n{}", (Object)String.join((CharSequence)"\n", lines));
    }

    public static int size() {
        LinkedHashMap<String, String> book = THREAD.get();
        return book.size();
    }
}

