/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.hash.HashFunction;
import org.apache.kylin.shaded.com.google.common.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class KylinAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(KylinAuthenticationProvider.class);
    @Autowired
    @Qualifier(value="userService")
    UserService userService;
    @Autowired
    private CacheManager cacheManager;
    private AuthenticationProvider authenticationProvider;
    private HashFunction hf = null;

    public KylinAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"The embedded authenticationProvider should not be null.");
        this.authenticationProvider = authenticationProvider;
        this.hf = Hashing.murmur3_128();
    }

    @PostConstruct
    public void init() {
        Preconditions.checkNotNull((Object)this.cacheManager, (Object)"cacheManager is not injected yet");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication authed;
        byte[] hashKey = this.hf.hashString((CharSequence)(authentication.getName() + authentication.getCredentials()), Charset.defaultCharset()).asBytes();
        String userKey = Arrays.toString(hashKey);
        Cache.ValueWrapper authedUser = this.cacheManager.getCache("UserCache").get((Object)userKey);
        if (authedUser != null) {
            authed = (Authentication)authedUser.get();
            SecurityContextHolder.getContext().setAuthentication(authed);
        } else {
            try {
                ManagedUser user;
                authed = this.authenticationProvider.authenticate(authentication);
                if (authed.getDetails() == null) {
                    throw new UsernameNotFoundException("User not found in LDAP, check whether he/she has been added to the groups.");
                }
                if (authed.getDetails() instanceof UserDetails) {
                    UserDetails details = (UserDetails)authed.getDetails();
                    user = new ManagedUser(details.getUsername(), details.getPassword(), (Boolean)false, details.getAuthorities());
                } else {
                    user = new ManagedUser(authentication.getName(), "skippped-ldap", (Boolean)false, authed.getAuthorities());
                }
                Assert.notNull((Object)((Object)user), (String)"The UserDetail is null.");
                String username = user.getUsername();
                logger.debug("User {} authorities : {}", (Object)username, (Object)user.getAuthorities());
                if (!this.userService.userExists(username)) {
                    this.userService.createUser(user);
                } else if (this.needUpdateUser(user, username)) {
                    this.userService.updateUser(user);
                }
                this.cacheManager.getCache("UserCache").put((Object)userKey, (Object)authed);
            }
            catch (AuthenticationException e) {
                logger.error("Failed to auth user: " + authentication.getName(), (Throwable)e);
                throw e;
            }
            logger.debug("Authenticated user " + authed.toString());
        }
        return authed;
    }

    private boolean needUpdateUser(ManagedUser user, String username) {
        return KylinConfig.getInstanceFromEnv().getSecurityProfile().equals("ldap") && !this.userService.loadUserByUsername(username).equals((Object)user);
    }

    public boolean supports(Class<?> authentication) {
        return this.authenticationProvider.supports(authentication);
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public void setAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }
}

