/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.job.impl.curator.CuratorLeaderSelector;
import org.apache.kylin.job.impl.curator.CuratorScheduler;
import org.apache.kylin.rest.service.BasicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="serviceDiscoveryStateService")
public class ServiceDiscoveryStateService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDiscoveryStateService.class);

    public Set<Participant> getAllParticipants() {
        CuratorLeaderSelector leaderSelector = CuratorScheduler.getLeaderSelector();
        if (leaderSelector != null) {
            return leaderSelector.getParticipants();
        }
        return Collections.emptySet();
    }

    public boolean isActiveJobNode() {
        CuratorLeaderSelector leaderSelector = CuratorScheduler.getLeaderSelector();
        return leaderSelector != null && leaderSelector.hasDefaultSchedulerStarted();
    }

    public Map<String, String> getJobServerState(Collection<String> servers) throws IOException {
        HashMap<String, String> r = new HashMap<String, String>();
        for (String server : servers) {
            RestClient client = new RestClient(server);
            Pair jobServerState = client.getJobServerWithState();
            logger.info("Ask server: {} for its job server state, is active job node: {}", jobServerState.getFirst(), jobServerState.getSecond());
            r.put((String)jobServerState.getFirst(), (String)jobServerState.getSecond());
        }
        return r;
    }
}

