/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class UserGroupService
extends BasicService
implements IUserGroupService {
    @Autowired
    AclEvaluate aclEvaluate;
    @Autowired
    @Qualifier(value="userService")
    UserService userService;

    @Override
    public List<String> listAllAuthorities(String project) throws IOException {
        if (project == null) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.checkProjectAdminPermission(project);
        }
        return this.getAllUserGroups();
    }

    @Override
    public boolean exists(String name) throws IOException {
        return this.getAllUserGroups().contains(name);
    }

    public abstract Map<String, List<String>> getGroupMembersMap() throws IOException;

    public abstract List<ManagedUser> getGroupMembersByName(String var1) throws IOException;

    protected abstract List<String> getAllUserGroups() throws IOException;

    public abstract void addGroup(String var1) throws IOException;

    public abstract void deleteGroup(String var1) throws IOException;

    public abstract void modifyGroupUsers(String var1, List<String> var2) throws IOException;
}

