/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.ServerMode;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.security.springacl.AclRecord;
import org.apache.kylin.rest.security.springacl.LegacyAceInfo;
import org.apache.kylin.rest.security.springacl.ObjectIdentityImpl;
import org.apache.kylin.rest.security.springacl.SidInfo;
import org.apache.kylin.rest.service.AclService;
import org.apache.kylin.rest.service.KylinUserService;
import org.apache.kylin.rest.service.UserGrantedAuthority;
import org.apache.kylin.rest.util.Serializer;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.HBaseResourceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclTableMigrationTool {
    private static final Serializer<SidInfo> sidSerializer = new Serializer<SidInfo>(SidInfo.class);
    private static final Serializer<ObjectIdentityImpl> domainObjSerializer = new Serializer<ObjectIdentityImpl>(ObjectIdentityImpl.class);
    private static final Serializer<LegacyAceInfo> aceSerializer = new Serializer<LegacyAceInfo>(LegacyAceInfo.class);
    private static final Serializer<UserGrantedAuthority[]> ugaSerializer = new Serializer<UserGrantedAuthority[]>(UserGrantedAuthority[].class);
    public static final String MIGRATE_OK_PREFIX = "MIGRATE_OK_";
    private static final Logger logger = LoggerFactory.getLogger(AclTableMigrationTool.class);

    public void migrate(KylinConfig kylinConfig) throws IOException {
        if (!this.checkIfNeedMigrate(kylinConfig)) {
            logger.info("Do not need to migrate acl table data");
            return;
        }
        if (!ServerMode.SERVER_MODE.canServeAll()) {
            throw new IllegalStateException("Please make sure that you have config kylin.server.mode=all before migrating data");
        }
        logger.info("Start to migrate acl table data");
        ResourceStore store = ResourceStore.getStore((KylinConfig)kylinConfig);
        String userTableName = kylinConfig.getMetadataUrlPrefix() + "_user";
        String aclTableName = kylinConfig.getMetadataUrlPrefix() + "_acl";
        if (this.needMigrateTable(aclTableName, store)) {
            logger.info("Migrate table : {}", (Object)aclTableName);
            this.migrate(store, "_acl", kylinConfig);
        }
        if (this.needMigrateTable(userTableName, store)) {
            logger.info("Migrate table : {}", (Object)userTableName);
            this.migrate(store, "_user", kylinConfig);
        }
    }

    public boolean checkIfNeedMigrate(KylinConfig kylinConfig) throws IOException {
        ResourceStore store = ResourceStore.getStore((KylinConfig)kylinConfig);
        if (!(store instanceof HBaseResourceStore)) {
            logger.info("HBase enviroment not found. Not necessary to migrate data");
            return false;
        }
        String userTableName = kylinConfig.getMetadataUrlPrefix() + "_user";
        String aclTableName = kylinConfig.getMetadataUrlPrefix() + "_acl";
        return this.needMigrateTable(aclTableName, store) || this.needMigrateTable(userTableName, store);
    }

    private boolean needMigrateTable(String tableName, ResourceStore store) throws IOException {
        return this.checkTableExist(tableName) && !this.isTableAlreadyMigrate(store, tableName);
    }

    private void migrate(ResourceStore store, String tableType, KylinConfig kylinConfig) throws IOException {
        switch (tableType) {
            case "_acl": {
                String aclTableName = kylinConfig.getMetadataUrlPrefix() + "_acl";
                this.convertToResourceStore(kylinConfig, aclTableName, store, new ResultConverter(){

                    @Override
                    public void convertResult(ResultScanner rs, ResourceStore store) throws IOException {
                        if (rs == null) {
                            return;
                        }
                        Result result = rs.next();
                        while (result != null) {
                            AclRecord record = new AclRecord();
                            ObjectIdentityImpl object = AclTableMigrationTool.this.getDomainObjectInfoFromRs(result);
                            record.setDomainObjectInfo(object);
                            record.setParentDomainObjectInfo(AclTableMigrationTool.this.getParentDomainObjectInfoFromRs(result));
                            record.setOwnerInfo(AclTableMigrationTool.this.getOwnerSidInfo(result));
                            record.setEntriesInheriting(AclTableMigrationTool.this.getInheriting(result));
                            record.setAllAceInfo(AclTableMigrationTool.this.getAllAceInfo(result));
                            store.putResource(AclService.resourceKey(object.getId()), (RootPersistentEntity)record, System.currentTimeMillis(), AclService.SERIALIZER);
                            result = rs.next();
                        }
                    }
                });
                break;
            }
            case "_user": {
                String userTableName = kylinConfig.getMetadataUrlPrefix() + "_user";
                this.convertToResourceStore(kylinConfig, userTableName, store, new ResultConverter(){

                    @Override
                    public void convertResult(ResultScanner rs, ResourceStore store) throws IOException {
                        if (rs == null) {
                            return;
                        }
                        Result result = rs.next();
                        while (result != null) {
                            ManagedUser user = AclTableMigrationTool.this.hbaseRowToUser(result);
                            store.putResource(KylinUserService.getId(user.getUsername()), (RootPersistentEntity)user, System.currentTimeMillis(), KylinUserService.SERIALIZER);
                            result = rs.next();
                        }
                    }
                });
                break;
            }
            default: {
                throw new IOException("Unrecognized table type");
            }
        }
    }

    private boolean checkTableExist(String tableName) throws IOException {
        StorageURL metadataUrl = KylinConfig.getInstanceFromEnv().getMetadataUrl();
        try (Admin admin = HBaseConnection.get((StorageURL)metadataUrl).getAdmin();){
            boolean bl = admin.tableExists(TableName.valueOf((String)tableName));
            return bl;
        }
    }

    private boolean isTableAlreadyMigrate(ResourceStore store, String tableName) throws IOException {
        return store.exists(MIGRATE_OK_PREFIX + tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToResourceStore(KylinConfig kylinConfig, String tableName, ResourceStore store, ResultConverter converter) throws IOException {
        Table table = null;
        ResultScanner rs = null;
        Scan scan = new Scan();
        try {
            table = HBaseConnection.get((StorageURL)kylinConfig.getStorageUrl()).getTable(TableName.valueOf((String)tableName));
            rs = table.getScanner(scan);
            converter.convertResult(rs, store);
            store.checkAndPutResource(MIGRATE_OK_PREFIX + tableName, (RootPersistentEntity)new StringEntity(tableName + " migrated"), StringEntity.serializer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(rs);
            IOUtils.closeQuietly(table);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)rs);
        IOUtils.closeQuietly((Closeable)table);
    }

    private ObjectIdentityImpl getDomainObjectInfoFromRs(Result result) {
        String type = new String(result.getValue(Bytes.toBytes((String)"i"), Bytes.toBytes((String)"t")), StandardCharsets.UTF_8);
        String id = new String(result.getRow(), StandardCharsets.UTF_8);
        ObjectIdentityImpl newInfo = new ObjectIdentityImpl(type, id);
        return newInfo;
    }

    private ObjectIdentityImpl getParentDomainObjectInfoFromRs(Result result) throws IOException {
        ObjectIdentityImpl parentInfo = domainObjSerializer.deserialize(result.getValue(Bytes.toBytes((String)"i"), Bytes.toBytes((String)"p")));
        return parentInfo;
    }

    private boolean getInheriting(Result result) {
        boolean entriesInheriting = Bytes.toBoolean((byte[])result.getValue(Bytes.toBytes((String)"i"), Bytes.toBytes((String)"i")));
        return entriesInheriting;
    }

    private SidInfo getOwnerSidInfo(Result result) throws IOException {
        SidInfo owner = sidSerializer.deserialize(result.getValue(Bytes.toBytes((String)"i"), Bytes.toBytes((String)"o")));
        return owner;
    }

    private Map<String, LegacyAceInfo> getAllAceInfo(Result result) throws IOException {
        HashMap<String, LegacyAceInfo> allAceInfoMap = new HashMap<String, LegacyAceInfo>();
        NavigableMap familyMap = result.getFamilyMap(Bytes.toBytes((String)"a"));
        if (familyMap != null && !familyMap.isEmpty()) {
            for (Map.Entry entry : familyMap.entrySet()) {
                String sid = new String((byte[])entry.getKey(), StandardCharsets.UTF_8);
                LegacyAceInfo aceInfo = aceSerializer.deserialize((byte[])entry.getValue());
                if (null == aceInfo) continue;
                allAceInfoMap.put(sid, aceInfo);
            }
        }
        return allAceInfoMap;
    }

    private ManagedUser hbaseRowToUser(Result result) throws JsonParseException, JsonMappingException, IOException {
        if (null == result || result.isEmpty()) {
            return null;
        }
        String username = Bytes.toString((byte[])result.getRow());
        byte[] valueBytes = result.getValue(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c"));
        UserGrantedAuthority[] deserialized = ugaSerializer.deserialize(valueBytes);
        String password = "";
        List<Object> authorities = Collections.emptyList();
        if (deserialized != null) {
            if (deserialized.length > 0 && deserialized[0].getAuthority().startsWith("PWD:")) {
                password = deserialized[0].getAuthority().substring("PWD:".length());
                authorities = Arrays.asList(deserialized).subList(1, deserialized.length);
            } else {
                authorities = Arrays.asList(deserialized);
            }
        }
        return new ManagedUser(username, password, (Boolean)false, authorities);
    }

    public static class User {
        String userName;
        String password;
        List<String> authorities;

        public User(String userName, String password, List<String> authorities) {
            this.userName = userName;
            this.password = password;
            this.authorities = authorities;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public List<String> getAuthorities() {
            return this.authorities;
        }

        public void setAuthorities(List<String> authorities) {
            this.authorities = authorities;
        }
    }

    static interface ResultConverter {
        public void convertResult(ResultScanner var1, ResourceStore var2) throws IOException;
    }
}

