/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.WriteConflictException;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cachesync.CaseInsensitiveStringCache;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.security.springacl.AclRecord;
import org.apache.kylin.rest.security.springacl.MutableAclRecord;
import org.apache.kylin.rest.security.springacl.ObjectIdentityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AlreadyExistsException;
import org.springframework.security.acls.model.ChildrenExistException;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="aclService")
public class AclService
implements MutableAclService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AclService.class);
    public static final String DIR_PREFIX = "/acl/";
    public static final Serializer<AclRecord> SERIALIZER = new JsonSerializer(AclRecord.class, true);
    @Autowired
    protected PermissionGrantingStrategy permissionGrantingStrategy;
    @Autowired
    protected PermissionFactory aclPermissionFactory;
    private CaseInsensitiveStringCache<AclRecord> aclMap;
    private CachedCrudAssist<AclRecord> crud;
    private AutoReadWriteLock lock = new AutoReadWriteLock();

    public AclService() throws IOException {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ResourceStore aclStore = ResourceStore.getStore((KylinConfig)config);
        this.aclMap = new CaseInsensitiveStringCache(config, "acl");
        this.crud = new CachedCrudAssist<AclRecord>(aclStore, "/acl", "", AclRecord.class, this.aclMap, true){

            protected AclRecord initEntityAfterReload(AclRecord acl, String resourceName) {
                acl.init(null, AclService.this.aclPermissionFactory, AclService.this.permissionGrantingStrategy);
                return acl;
            }
        };
        this.crud.reloadAll();
    }

    public void afterPropertiesSet() throws Exception {
        Broadcaster.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).registerStaticListener((Broadcaster.Listener)new AclRecordSyncListener(), new String[]{"acl"});
    }

    public List<ObjectIdentity> findChildren(ObjectIdentity parentIdentity) {
        ArrayList allAclRecords;
        ArrayList<ObjectIdentity> oids = new ArrayList<ObjectIdentity>();
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            allAclRecords = new ArrayList(this.aclMap.values());
        }
        for (AclRecord record : allAclRecords) {
            ObjectIdentityImpl parent = record.getParentDomainObjectInfo();
            if (parent == null || !parent.equals(parentIdentity)) continue;
            ObjectIdentityImpl child = record.getDomainObjectInfo();
            oids.add(child);
        }
        return oids;
    }

    public MutableAclRecord readAcl(ObjectIdentity oid) throws NotFoundException {
        return (MutableAclRecord)this.readAclById(oid);
    }

    public Acl readAclById(ObjectIdentity object) throws NotFoundException {
        Map<ObjectIdentity, Acl> aclsMap = this.readAclsById(Arrays.asList(object), null);
        return aclsMap.get(object);
    }

    public Acl readAclById(ObjectIdentity object, List<Sid> sids) throws NotFoundException {
        Message msg = MsgPicker.getMsg();
        Map<ObjectIdentity, Acl> aclsMap = this.readAclsById(Arrays.asList(object), sids);
        if (!aclsMap.containsKey(object)) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getNO_ACL_ENTRY(), object));
        }
        return aclsMap.get(object);
    }

    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects) throws NotFoundException {
        return this.readAclsById(objects, null);
    }

    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> oids, List<Sid> sids) throws NotFoundException {
        HashMap<ObjectIdentity, Acl> aclMaps = new HashMap<ObjectIdentity, Acl>();
        for (ObjectIdentity oid : oids) {
            AclRecord record = this.getAclRecordByCache(AclService.objID(oid));
            if (record == null) {
                Message msg = MsgPicker.getMsg();
                throw new NotFoundException(String.format(Locale.ROOT, msg.getACL_INFO_NOT_FOUND(), oid));
            }
            Acl parentAcl = null;
            if (record.isEntriesInheriting() && record.getParentDomainObjectInfo() != null) {
                parentAcl = this.readAclById(record.getParentDomainObjectInfo());
            }
            record.init(parentAcl, this.aclPermissionFactory, this.permissionGrantingStrategy);
            aclMaps.put(oid, new MutableAclRecord(record));
        }
        return aclMaps;
    }

    public MutableAcl createAcl(ObjectIdentity objectIdentity) throws AlreadyExistsException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            AclRecord aclRecord = this.getAclRecordByCache(AclService.objID(objectIdentity));
            if (aclRecord != null) {
                throw new AlreadyExistsException("ACL of " + objectIdentity + " exists!");
            }
            AclRecord record = this.newPrjACL(objectIdentity);
            this.crud.save((RootPersistentEntity)record);
            logger.debug("ACL of " + objectIdentity + " created successfully.");
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
        return (MutableAcl)this.readAclById(objectIdentity);
    }

    public void deleteAcl(ObjectIdentity objectIdentity, boolean deleteChildren) throws ChildrenExistException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            List<ObjectIdentity> children = this.findChildren(objectIdentity);
            if (!deleteChildren && children.size() > 0) {
                Message msg = MsgPicker.getMsg();
                throw new BadRequestException(String.format(Locale.ROOT, msg.getIDENTITY_EXIST_CHILDREN(), objectIdentity));
            }
            for (ObjectIdentity oid : children) {
                this.deleteAcl(oid, deleteChildren);
            }
            this.crud.delete(AclService.objID(objectIdentity));
            logger.debug("ACL of " + objectIdentity + " deleted successfully.");
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    public MutableAcl updateAcl(MutableAcl mutableAcl) throws NotFoundException {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForWrite();){
            AclRecord record = ((MutableAclRecord)mutableAcl).getAclRecord();
            this.crud.save((RootPersistentEntity)record);
            logger.debug("ACL of " + mutableAcl.getObjectIdentity() + " updated successfully.");
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
        return mutableAcl;
    }

    MutableAclRecord upsertAce(MutableAclRecord acl, final Sid sid, final Permission perm) {
        return this.updateAclWithRetry(acl, new AclRecordUpdater(){

            @Override
            public void update(AclRecord record) {
                record.upsertAce(perm, sid);
            }
        });
    }

    void batchUpsertAce(MutableAclRecord acl, final Map<Sid, Permission> sidToPerm) {
        this.updateAclWithRetry(acl, new AclRecordUpdater(){

            @Override
            public void update(AclRecord record) {
                for (Sid sid : sidToPerm.keySet()) {
                    record.upsertAce((Permission)sidToPerm.get(sid), sid);
                }
            }
        });
    }

    MutableAclRecord inherit(MutableAclRecord acl, final MutableAclRecord parentAcl) {
        return this.updateAclWithRetry(acl, new AclRecordUpdater(){

            @Override
            public void update(AclRecord record) {
                record.setEntriesInheriting(true);
                record.setParent(parentAcl);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private AclRecord getAclRecordByCache(String id) {
        try (AutoReadWriteLock.AutoLock l = this.lock.lockForRead();){
            if (this.aclMap.size() > 0) {
                AclRecord aclRecord = (AclRecord)((Object)this.aclMap.get((Object)id));
                return aclRecord;
            }
        }
        try {
            l = this.lock.lockForWrite();
            var3_4 = null;
            try {
                this.crud.reloadAll();
                AclRecord aclRecord = (AclRecord)((Object)this.aclMap.get((Object)id));
                return aclRecord;
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (l != null) {
                    if (var3_4 != null) {
                        try {
                            l.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        l.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can not get ACL record from cache.", e);
        }
    }

    private AclRecord newPrjACL(ObjectIdentity objID) {
        AclRecord acl = new AclRecord(objID, this.getCurrentSid());
        acl.init(null, this.aclPermissionFactory, this.permissionGrantingStrategy);
        acl.updateRandomUuid();
        return acl;
    }

    private Sid getCurrentSid() {
        return new PrincipalSid(SecurityContextHolder.getContext().getAuthentication());
    }

    private MutableAclRecord updateAclWithRetry(MutableAclRecord acl, AclRecordUpdater updater) {
        int retry = 7;
        while (retry-- > 0) {
            AclRecord record = acl.getAclRecord();
            updater.update(record);
            try {
                this.crud.save((RootPersistentEntity)record);
                return acl;
            }
            catch (WriteConflictException ise) {
                if (retry <= 0) {
                    logger.error("Retry is out, till got error, abandoning...", (Throwable)ise);
                    throw ise;
                }
                logger.warn("Write conflict to update ACL " + AclService.resourceKey(record.getObjectIdentity()) + " retry remaining " + retry + ", will retry...");
                acl = this.readAcl(acl.getObjectIdentity());
            }
            catch (IOException e) {
                throw new InternalErrorException(e);
            }
        }
        throw new RuntimeException("should not reach here");
    }

    private static String resourceKey(ObjectIdentity domainObjId) {
        return AclService.resourceKey(AclService.objID(domainObjId));
    }

    private static String objID(ObjectIdentity domainObjId) {
        return String.valueOf(domainObjId.getIdentifier());
    }

    static String resourceKey(String domainObjId) {
        return DIR_PREFIX + domainObjId;
    }

    public static interface AclRecordUpdater {
        public void update(AclRecord var1);
    }

    private class AclRecordSyncListener
    extends Broadcaster.Listener {
        private AclRecordSyncListener() {
        }

        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) throws IOException {
            try (AutoReadWriteLock.AutoLock l = AclService.this.lock.lockForWrite();){
                if (event == Broadcaster.Event.DROP) {
                    AclService.this.aclMap.removeLocal((Object)cacheKey);
                } else {
                    AclService.this.crud.reloadQuietly(cacheKey);
                }
            }
            broadcaster.notifyProjectACLUpdate(cacheKey);
        }

        public void onClearAll(Broadcaster broadcaster) throws IOException {
            try (AutoReadWriteLock.AutoLock l = AclService.this.lock.lockForWrite();){
                AclService.this.aclMap.clear();
            }
        }
    }
}

