/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.signature.FactTableRealizationSetCalculator;
import org.apache.kylin.rest.signature.SignatureCalculator;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLResponseSignatureUtil {
    public static final Logger logger = LoggerFactory.getLogger(SQLResponseSignatureUtil.class);

    public static boolean checkSignature(KylinConfig config, SQLResponse sqlResponse, String projectName) {
        String old = sqlResponse.getSignature();
        if (old == null) {
            return false;
        }
        String latest = SQLResponseSignatureUtil.createSignature(config, sqlResponse, projectName);
        return old.equals(latest);
    }

    public static String createSignature(KylinConfig config, SQLResponse sqlResponse, String projectName) {
        SignatureCalculator signatureCalculator;
        ProjectInstance project = ProjectManager.getInstance((KylinConfig)config).getProject(projectName);
        Preconditions.checkNotNull((Object)project);
        try {
            Class signatureClass = SQLResponseSignatureUtil.getSignatureClass(project.getConfig());
            signatureCalculator = (SignatureCalculator)signatureClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Will use default signature since fail to construct signature due to " + e);
            signatureCalculator = new FactTableRealizationSetCalculator();
        }
        return signatureCalculator.calculateSignature(config, sqlResponse, project);
    }

    private static Class getSignatureClass(KylinConfig config) {
        try {
            return Class.forName(config.getSQLResponseSignatureClass());
        }
        catch (ClassNotFoundException e) {
            logger.warn("Will use default signature since cannot find class " + config.getSQLResponseSignatureClass());
            return FactTableRealizationSetCalculator.class;
        }
    }
}

