/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.job;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryInfoSerializer;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.job.execution.CardinalityExecutable;
import org.apache.kylin.job.execution.CheckpointExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCleanupJob {
    private static final Logger logger = LoggerFactory.getLogger(MetadataCleanupJob.class);
    private static final long NEW_RESOURCE_THREADSHOLD_MS = 43200000L;
    final KylinConfig config;
    private Map<String, Long> garbageResources = Maps.newHashMap();
    private ResourceStore store;

    public MetadataCleanupJob() {
        this(KylinConfig.getInstanceFromEnv());
    }

    public MetadataCleanupJob(KylinConfig config) {
        this.config = config;
        this.store = ResourceStore.getStore((KylinConfig)config);
    }

    public Map<String, Long> getGarbageResources() {
        return this.garbageResources;
    }

    public Map<String, Long> cleanup(boolean delete, int jobOutdatedDays, boolean deleteAllJobs) throws Exception {
        int n;
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)this.config);
        long newResourceTimeCut = System.currentTimeMillis() - 43200000L;
        FileSystem fs = HadoopUtil.getWorkingFileSystem((Configuration)HadoopUtil.getCurrentConfiguration());
        HashMap toDeleteCandidates = Maps.newHashMap();
        String[] stringArray = new String[]{"/table_snapshot", "/cube_statistics", "/ext_table_snapshot"};
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String resourceRoot = stringArray[n];
            for (String dir : this.noNull(this.store.listResources(resourceRoot))) {
                for (String string : this.noNull(this.store.listResources(dir))) {
                    long timestamp = this.getTimestamp(string);
                    if (timestamp >= newResourceTimeCut) continue;
                    toDeleteCandidates.put(string, timestamp);
                }
            }
        }
        try {
            Object[] fStatus = new FileStatus[]{};
            fStatus = (FileStatus[])ArrayUtils.addAll((Object[])fStatus, (Object[])fs.listStatus(new Path(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "resources/GlobalDict/dict")));
            Object[] objectArray = fStatus = (FileStatus[])ArrayUtils.addAll((Object[])fStatus, (Object[])fs.listStatus(new Path(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "resources/SegmentDict/dict")));
            n = objectArray.length;
            for (int resourceRoot = 0; resourceRoot < n; ++resourceRoot) {
                FileStatus[] globalDicts;
                Object status = objectArray[resourceRoot];
                String path = status.getPath().toString();
                for (FileStatus globalDict : globalDicts = fs.listStatus(new Path(path))) {
                    String globalDictPath = globalDict.getPath().toString();
                    long timestamp = this.getTimestamp(globalDict);
                    if (timestamp >= newResourceTimeCut) continue;
                    toDeleteCandidates.put(globalDictPath, timestamp);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.info("Working Directory does not exist on HDFS. ");
        }
        for (String resourceRoot : new String[]{"/dict"}) {
            for (String dir : this.noNull(this.store.listResources(resourceRoot))) {
                for (String string : this.noNull(this.store.listResources(dir))) {
                    for (String res : this.noNull(this.store.listResources(string))) {
                        long timestamp = this.getTimestamp(res);
                        if (timestamp >= newResourceTimeCut) continue;
                        toDeleteCandidates.put(res, timestamp);
                    }
                }
            }
        }
        HashSet activeResources = Sets.newHashSet();
        for (CubeInstance cube : cubeManager.reloadAndListAllCubes()) {
            activeResources.addAll(cube.getSnapshots().values());
            for (CubeSegment segment : cube.getSegments()) {
                activeResources.addAll(segment.getSnapshotPaths());
                activeResources.addAll(segment.getDictionaryPaths());
                activeResources.add(segment.getStatisticsResourcePath());
                for (String dictPath : segment.getDictionaryPaths()) {
                    DictionaryInfo dictionaryInfo = (DictionaryInfo)this.store.getResource(dictPath, (Serializer)DictionaryInfoSerializer.FULL_SERIALIZER);
                    if (!"org.apache.kylin.dict.AppendTrieDictionary".equals(dictionaryInfo != null ? dictionaryInfo.getDictionaryClass() : null)) continue;
                    String dictObj = dictionaryInfo.getDictionaryObject().toString();
                    String basedir = dictObj.substring(dictObj.indexOf("(") + 1, dictObj.indexOf(")") - 1);
                    if (basedir.startsWith(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "/resources/GlobalDict")) {
                        activeResources.add(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "resources/GlobalDict" + dictionaryInfo.getResourceDir());
                        continue;
                    }
                    if (!basedir.startsWith(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "/resources/SegmentDict")) continue;
                    activeResources.add(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "resources/SegmentDict" + dictionaryInfo.getResourceDir());
                }
            }
        }
        toDeleteCandidates.keySet().removeAll(activeResources);
        long outdatedJobTimeCut = System.currentTimeMillis() - (long)(jobOutdatedDays * 24 * 3600) * 1000L;
        ExecutableDao executableDao = ExecutableDao.getInstance((KylinConfig)this.config);
        List allExecutable = executableDao.getJobs();
        for (ExecutablePO executable : allExecutable) {
            long l = executable.getLastModified();
            if (l >= outdatedJobTimeCut || !deleteAllJobs && !this.isJobComplete(executableDao, executable)) continue;
            String jobResPath = "/execute/" + executable.getUuid();
            String jobOutputResPath = "/execute_output/" + executable.getUuid();
            long outputLastModified = this.getTimestamp(jobOutputResPath);
            toDeleteCandidates.put(jobResPath, l);
            toDeleteCandidates.put(jobOutputResPath, outputLastModified);
            List tasks = executable.getTasks();
            if (tasks == null || tasks.isEmpty()) continue;
            for (ExecutablePO task : executable.getTasks()) {
                String taskId = task.getUuid();
                if (!StringUtils.isNotBlank((CharSequence)taskId)) continue;
                String resPath = "/execute_output/" + task.getUuid();
                long timestamp = this.getTimestamp(resPath);
                toDeleteCandidates.put(resPath, timestamp);
            }
        }
        this.garbageResources = this.cleanupConclude(delete, toDeleteCandidates);
        return this.garbageResources;
    }

    private boolean isJobComplete(ExecutableDao executableDao, ExecutablePO job) {
        String jobId = job.getUuid();
        boolean isComplete = false;
        try {
            ExecutableOutputPO output = executableDao.getJobOutput(jobId);
            String status = output.getStatus();
            String jobType = job.getType();
            if (jobType.equals(CubingJob.class.getName()) || jobType.equals(CheckpointExecutable.class.getName())) {
                if (StringUtils.equals((CharSequence)status, (CharSequence)ExecutableState.SUCCEED.toString()) || StringUtils.equals((CharSequence)status, (CharSequence)ExecutableState.DISCARDED.toString())) {
                    isComplete = true;
                }
            } else if (jobType.equals(CardinalityExecutable.class.getName())) {
                isComplete = true;
            }
        }
        catch (PersistentException e) {
            logger.error("Get job output failed for job uuid: {}", (Object)jobId, (Object)e);
            isComplete = true;
        }
        return isComplete;
    }

    private Map<String, Long> cleanupConclude(boolean delete, Map<String, Long> toDeleteResources) throws IOException {
        if (toDeleteResources.isEmpty()) {
            logger.info("No metadata resource to clean up");
            return toDeleteResources;
        }
        logger.info("{} metadata resource to clean up", (Object)toDeleteResources.size());
        if (delete) {
            ResourceStore store = ResourceStore.getStore((KylinConfig)this.config);
            FileSystem fs = HadoopUtil.getWorkingFileSystem((Configuration)HadoopUtil.getCurrentConfiguration());
            for (String res : toDeleteResources.keySet()) {
                long timestamp = toDeleteResources.get(res);
                logger.info("Deleting metadata=[resource_path: {}, timestamp: {}]", (Object)res, (Object)timestamp);
                try {
                    if (res.startsWith(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory())) {
                        fs.delete(new Path(res), true);
                        continue;
                    }
                    store.deleteResource(res, timestamp);
                }
                catch (IOException e) {
                    logger.error("Failed to delete metadata=[resource_path: {}, timestamp: {}] ", new Object[]{res, timestamp, e});
                }
            }
        } else {
            for (String res : toDeleteResources.keySet()) {
                long timestamp = toDeleteResources.get(res);
                logger.info("Dry run, pending delete metadata=[resource_path: {}, timestamp: {}] ", (Object)res, (Object)timestamp);
            }
        }
        return toDeleteResources;
    }

    private NavigableSet<String> noNull(NavigableSet<String> list) {
        return list == null ? new TreeSet() : list;
    }

    private long getTimestamp(String resPath) {
        long timestamp = Long.MAX_VALUE;
        try {
            timestamp = this.store.getResourceTimestamp(resPath);
        }
        catch (IOException e) {
            logger.warn("Failed to get resource timestamp from remote resource store, details:{}", (Throwable)e);
        }
        return timestamp;
    }

    private long getTimestamp(FileStatus filestatus) {
        return filestatus.getModificationTime();
    }
}

