/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.badquery.BadQueryEntry;
import org.apache.kylin.metadata.badquery.BadQueryHistory;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.JobService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="diagnosisService")
public class DiagnosisService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisService.class);
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private JobService jobService;

    private String getDiagnosisPackageName(File destDir) {
        Message msg = MsgPicker.getMsg();
        File[] files = destDir.listFiles();
        if (files == null) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getDIAG_PACKAGE_NOT_AVAILABLE(), destDir.getAbsolutePath()));
        }
        for (File subDir : files) {
            if (!subDir.isDirectory()) continue;
            for (File file : subDir.listFiles()) {
                if (!file.getName().endsWith(".zip")) continue;
                return file.getAbsolutePath();
            }
        }
        throw new BadRequestException(String.format(Locale.ROOT, msg.getDIAG_PACKAGE_NOT_FOUND(), destDir.getAbsolutePath()));
    }

    public BadQueryHistory getProjectBadQueryHistory(String project) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(project);
        return this.getBadQueryHistoryManager().getBadQueriesForProject(project);
    }

    public String dumpProjectDiagnosisInfo(String project, File exportPath) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(project);
        String[] args = new String[]{project, exportPath.getAbsolutePath()};
        this.runDiagnosisCLI(args);
        return this.getDiagnosisPackageName(exportPath);
    }

    public String dumpJobDiagnosisInfo(String jobId, File exportPath) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(this.jobService.getJobInstance(jobId));
        String[] args = new String[]{jobId, exportPath.getAbsolutePath()};
        this.runDiagnosisCLI(args);
        return this.getDiagnosisPackageName(exportPath);
    }

    private void runDiagnosisCLI(String[] args) throws IOException {
        Message msg = MsgPicker.getMsg();
        File cwd = new File("");
        logger.debug("Current path: {}", (Object)cwd.getAbsolutePath());
        logger.debug("DiagnosisInfoCLI args: {}", (Object)Arrays.toString(args));
        File script = new File(KylinConfig.getKylinHome() + File.separator + "bin", "diag.sh");
        if (!script.exists()) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getDIAG_NOT_FOUND(), script.getAbsolutePath()));
        }
        String diagCmd = script.getAbsolutePath() + " " + StringUtils.join((Object[])args, (String)" ");
        CliCommandExecutor executor = KylinConfig.getInstanceFromEnv().getCliCommandExecutor();
        Pair cmdOutput = executor.execute(diagCmd);
        if ((Integer)cmdOutput.getFirst() != 0) {
            throw new BadRequestException(msg.getGENERATE_DIAG_PACKAGE_FAIL());
        }
    }

    public List<BadQueryEntry> getQueriesByType(List<BadQueryEntry> allBadEntries, String queryType) throws IOException {
        ArrayList filteredEntries = Lists.newArrayList();
        for (BadQueryEntry entry : allBadEntries) {
            if (null == entry || !entry.getAdj().equals(queryType)) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries;
    }

    public Map<String, Object> getQueries(Integer pageOffset, Integer pageSize, String queryType, List<BadQueryEntry> allBadEntries) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        List<BadQueryEntry> filteredEntries = this.getQueriesByType(allBadEntries, queryType);
        int offset = pageOffset * pageSize;
        int limit = pageSize;
        if (filteredEntries.size() <= offset) {
            offset = filteredEntries.size();
            limit = 0;
        }
        if (filteredEntries.size() - offset < limit) {
            limit = filteredEntries.size() - offset;
        }
        data.put("badQueries", filteredEntries.subList(offset, offset + limit));
        data.put("size", filteredEntries.size());
        return data;
    }
}

