/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.cuboid.TreeCuboidScheduler;
import org.apache.kylin.cube.model.CubeBuildTypeEnum;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.engine.mr.common.CuboidStatsReaderUtil;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.job.exception.JobException;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.exception.NotFoundException;
import org.apache.kylin.rest.exception.TooManyRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.request.CubeRequest;
import org.apache.kylin.rest.request.JobBuildRequest;
import org.apache.kylin.rest.request.JobBuildRequest2;
import org.apache.kylin.rest.request.JobOptimizeRequest;
import org.apache.kylin.rest.request.LookupSnapshotBuildRequest;
import org.apache.kylin.rest.response.CubeInstanceResponse;
import org.apache.kylin.rest.response.CuboidTreeResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.GeneralResponse;
import org.apache.kylin.rest.response.HBaseResponse;
import org.apache.kylin.rest.service.CubeService;
import org.apache.kylin.rest.service.JobService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.util.ValidateUtil;
import org.apache.kylin.source.kafka.util.KafkaClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cubes"})
public class CubeController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(CubeController.class);
    @Autowired
    @Qualifier(value="cubeMgmtService")
    private CubeService cubeService;
    @Autowired
    @Qualifier(value="jobService")
    private JobService jobService;
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;

    @RequestMapping(value={"/validate/{cubeName}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse<Boolean> validateModelName(@PathVariable String cubeName) {
        return new EnvelopeResponse<Boolean>("000", this.cubeService.isCubeNameVaildate(cubeName), "");
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<CubeInstanceResponse> getCubes(@RequestParam(value="cubeName", required=false) String cubeName, @RequestParam(value="modelName", required=false) String modelName, @RequestParam(value="projectName", required=false) String projectName, @RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="offset", required=false) Integer offset) {
        int coffset;
        List<CubeInstance> cubes = this.cubeService.listAllCubes(cubeName, projectName, modelName, false);
        ArrayList response = Lists.newArrayListWithExpectedSize((int)cubes.size());
        for (CubeInstance cube : cubes) {
            try {
                response.add(this.cubeService.createCubeInstanceResponse(cube));
            }
            catch (Exception e) {
                logger.error("Error creating cube instance response, skipping.", (Throwable)e);
            }
        }
        int climit = null == limit ? response.size() : limit.intValue();
        int n = coffset = null == offset ? 0 : offset;
        if (response.size() <= coffset) {
            return Collections.emptyList();
        }
        if (response.size() - coffset < climit) {
            return response.subList(coffset, response.size());
        }
        return response.subList(coffset, coffset + climit);
    }

    @RequestMapping(value={"validEncodings"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Integer> getValidEncodings() {
        Map encodings;
        try {
            encodings = DimensionEncodingFactory.getValidEncodings();
        }
        catch (Exception e) {
            logger.error("Error when getting valid encodings", (Throwable)e);
            return Maps.newHashMap();
        }
        return encodings;
    }

    @RequestMapping(value={"/{cubeName}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public CubeInstance getCube(@PathVariable String cubeName) {
        this.checkCubeExists(cubeName);
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        return cube;
    }

    @RequestMapping(value={"/{cubeName}/sql"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public GeneralResponse getSql(@PathVariable String cubeName) {
        this.checkCubeExists(cubeName);
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        CubeJoinedFlatTableDesc flatTableDesc = new CubeJoinedFlatTableDesc(cube.getDescriptor(), true);
        String sql = JoinedFlatTable.generateSelectDataStatement((IJoinedFlatTableDesc)flatTableDesc);
        GeneralResponse response = new GeneralResponse();
        response.setProperty("sql", sql);
        return response;
    }

    @RequestMapping(value={"/{cubeName}/segs/{segmentName}/sql"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public GeneralResponse getSql(@PathVariable String cubeName, @PathVariable String segmentName) {
        this.checkCubeExists(cubeName);
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        CubeSegment segment = cube.getSegment(segmentName, null);
        if (segment == null) {
            throw new NotFoundException("Cannot find segment " + segmentName);
        }
        CubeJoinedFlatTableDesc flatTableDesc = new CubeJoinedFlatTableDesc(segment, true);
        String sql = JoinedFlatTable.generateSelectDataStatement((IJoinedFlatTableDesc)flatTableDesc);
        GeneralResponse response = new GeneralResponse();
        response.setProperty("sql", sql);
        return response;
    }

    @RequestMapping(value={"/{cubeName}/notify_list"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public void updateNotifyList(@PathVariable String cubeName, @RequestBody List<String> notifyList) {
        this.checkCubeExists(cubeName);
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        try {
            this.cubeService.updateCubeNotifyList(cube, notifyList);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/cost"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public CubeInstance updateCubeCost(@PathVariable String cubeName, @RequestParam(value="cost") int cost) {
        this.checkCubeExists(cubeName);
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        try {
            return this.cubeService.updateCubeCost(cube, cost);
        }
        catch (Exception e) {
            String message = "Failed to update cube cost: " + cubeName + " : " + cost;
            logger.error(message, (Throwable)e);
            throw new InternalErrorException(message + " Caused by: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/segs/{segmentName}/refresh_lookup"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public CubeInstance rebuildLookupSnapshot(@PathVariable String cubeName, @PathVariable String segmentName, @RequestParam(value="lookupTable") String lookupTable) {
        try {
            CubeManager cubeMgr = this.cubeService.getCubeManager();
            CubeInstance cube = cubeMgr.getCube(cubeName);
            return this.cubeService.rebuildLookupSnapshot(cube, segmentName, lookupTable);
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/refresh_lookup"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public JobInstance rebuildLookupSnapshot(@PathVariable String cubeName, @RequestBody LookupSnapshotBuildRequest request) {
        try {
            CubeManager cubeMgr = this.cubeService.getCubeManager();
            CubeInstance cube = cubeMgr.getCube(cubeName);
            String submitter = SecurityContextHolder.getContext().getAuthentication().getName();
            return this.jobService.submitLookupSnapshotJob(cube, request.getLookupTableName(), request.getSegmentIDs(), submitter);
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/segs/{segmentName}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public CubeInstance deleteSegment(@PathVariable String cubeName, @PathVariable String segmentName) {
        this.checkCubeExists(cubeName);
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        CubeSegment segment = cube.getSegment(segmentName, null);
        if (segment == null) {
            throw new NotFoundException("Cannot find segment '" + segmentName + "'");
        }
        try {
            return this.cubeService.deleteSegment(cube, segmentName);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/build"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public JobInstance build(@PathVariable String cubeName, @RequestBody JobBuildRequest req) {
        return this.rebuild(cubeName, req);
    }

    @RequestMapping(value={"/{cubeName}/rebuild"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public JobInstance rebuild(@PathVariable String cubeName, @RequestBody JobBuildRequest req) {
        return this.buildInternal(cubeName, new SegmentRange.TSRange(Long.valueOf(req.getStartTime()), Long.valueOf(req.getEndTime())), null, null, null, req.getBuildType(), req.isForce() || req.isForceMergeEmptySegment(), req.getPriorityOffset());
    }

    @RequestMapping(value={"/{cubeName}/build2"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public JobInstance build2(@PathVariable String cubeName, @RequestBody JobBuildRequest2 req) {
        try {
            Class<?> clazz = Class.forName("org.apache.kafka.clients.consumer.KafkaConsumer");
            if (clazz == null) {
                throw new ClassNotFoundException();
            }
        }
        catch (ClassNotFoundException e) {
            throw new InternalErrorException("Could not find Kafka dependency");
        }
        return this.rebuild2(cubeName, req);
    }

    @RequestMapping(value={"/{cubeName}/rebuild2"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public JobInstance rebuild2(@PathVariable String cubeName, @RequestBody JobBuildRequest2 req) {
        return this.buildInternal(cubeName, null, new SegmentRange((Comparable)Long.valueOf(req.getSourceOffsetStart()), (Comparable)Long.valueOf(req.getSourceOffsetEnd())), req.getSourcePartitionOffsetStart(), req.getSourcePartitionOffsetEnd(), req.getBuildType(), req.isForce(), req.getPriorityOffset());
    }

    private JobInstance buildInternal(String cubeName, SegmentRange.TSRange tsRange, SegmentRange segRange, Map<Integer, Long> sourcePartitionOffsetStart, Map<Integer, Long> sourcePartitionOffsetEnd, String buildType, boolean force, Integer priorityOffset) {
        try {
            String submitter = SecurityContextHolder.getContext().getAuthentication().getName();
            CubeInstance cube = this.jobService.getCubeManager().getCube(cubeName);
            this.checkBuildingSegment(cube);
            return this.jobService.submitJob(cube, tsRange, segRange, sourcePartitionOffsetStart, sourcePartitionOffsetEnd, CubeBuildTypeEnum.valueOf((String)buildType), force, submitter, priorityOffset);
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/optimize"}, method={RequestMethod.PUT})
    @ResponseBody
    public JobInstance optimize(@PathVariable String cubeName, @RequestBody JobOptimizeRequest jobOptimizeRequest) {
        try {
            String submitter = SecurityContextHolder.getContext().getAuthentication().getName();
            CubeInstance cube = this.jobService.getCubeManager().getCube(cubeName);
            this.checkCubeExists(cubeName);
            logger.info("cuboid recommend:" + jobOptimizeRequest.getCuboidsRecommend());
            return (JobInstance)this.jobService.submitOptimizeJob(cube, jobOptimizeRequest.getCuboidsRecommend(), submitter).getFirst();
        }
        catch (BadRequestException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (JobException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new BadRequestException(e.getLocalizedMessage());
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/recover_segment_optimize/{segmentID}"}, method={RequestMethod.PUT})
    @ResponseBody
    public JobInstance recoverSegmentOptimize(@PathVariable String cubeName, @PathVariable String segmentID) {
        try {
            String submitter = SecurityContextHolder.getContext().getAuthentication().getName();
            CubeInstance cube = this.jobService.getCubeManager().getCube(cubeName);
            CubeSegment segment = cube.getSegmentById(segmentID);
            if (segment == null) {
                throw new NotFoundException("Cannot find segment '" + segmentID + "'");
            }
            return this.jobService.submitRecoverSegmentOptimizeJob(segment, submitter);
        }
        catch (JobException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new BadRequestException(e.getLocalizedMessage());
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/disable"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public CubeInstance disableCube(@PathVariable String cubeName) {
        try {
            this.checkCubeExists(cubeName);
            CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
            return this.cubeService.disableCube(cube);
        }
        catch (Exception e) {
            String message = "Failed to disable cube: " + cubeName;
            logger.error(message, (Throwable)e);
            throw new InternalErrorException(message + " Caused by: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/purge"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public CubeInstance purgeCube(@PathVariable String cubeName) {
        try {
            this.checkCubeExists(cubeName);
            CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
            return this.cubeService.purgeCube(cube);
        }
        catch (Exception e) {
            String message = "Failed to purge cube: " + cubeName;
            logger.error(message, (Throwable)e);
            throw new InternalErrorException(message + " Caused by: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/clone"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public CubeInstance cloneCube(@PathVariable String cubeName, @RequestBody CubeRequest cubeRequest) {
        CubeInstance newCube;
        String newCubeName = cubeRequest.getCubeName();
        String projectName = cubeRequest.getProject();
        this.checkCubeExists(cubeName);
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        if (cube.getStatus() == RealizationStatusEnum.DESCBROKEN) {
            throw new BadRequestException("Broken cube can't be cloned");
        }
        if (!ValidateUtil.isAlphanumericUnderscore(newCubeName)) {
            throw new BadRequestException("Invalid Cube name, only letters, numbers and underscore supported.");
        }
        ProjectInstance project = this.cubeService.getProjectManager().getProject(projectName);
        if (project == null) {
            throw new NotFoundException("Project " + projectName + " doesn't exist");
        }
        if (!project.getName().equals(cube.getProject())) {
            throw new BadRequestException("Cloning cubes across projects is not supported.");
        }
        CubeDesc cubeDesc = cube.getDescriptor();
        CubeDesc newCubeDesc = CubeDesc.getCopyOf((CubeDesc)cubeDesc);
        newCubeDesc.setName(newCubeName);
        try {
            newCube = this.cubeService.createCubeAndDesc(project, newCubeDesc);
            this.cubeService.getCubeDescManager().reloadCubeDescLocal(newCubeName);
        }
        catch (IOException e) {
            throw new InternalErrorException("Failed to clone cube ", e);
        }
        return newCube;
    }

    @RequestMapping(value={"/{cubeName}/enable"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public CubeInstance enableCube(@PathVariable String cubeName) {
        try {
            this.checkCubeExists(cubeName);
            CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
            this.cubeService.checkEnableCubeCondition(cube);
            return this.cubeService.enableCube(cube);
        }
        catch (Exception e) {
            String message = "Failed to enable cube: " + cubeName;
            logger.error(message, (Throwable)e);
            throw new InternalErrorException(message + " Caused by: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public void deleteCube(@PathVariable String cubeName) {
        this.checkCubeExists(cubeName);
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        try {
            this.cubeService.deleteCube(cube);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException("Failed to delete cube.  Caused by: " + e.getMessage(), e);
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public CubeRequest saveCubeDesc(@RequestBody CubeRequest cubeRequest) {
        CubeDesc desc = this.deserializeCubeDesc(cubeRequest);
        if (desc == null) {
            cubeRequest.setMessage("CubeDesc is null.");
            return cubeRequest;
        }
        String name = desc.getName();
        if (StringUtils.isEmpty((String)name)) {
            logger.info("Cube name should not be empty.");
            throw new BadRequestException("Cube name should not be empty.");
        }
        if (!ValidateUtil.isAlphanumericUnderscore(name)) {
            throw new BadRequestException("Invalid Cube name, only letters, numbers and underscore supported.");
        }
        this.validateColumnFamily(desc);
        try {
            desc.setUuid(RandomUtil.randomUUID().toString());
            String projectName = null == cubeRequest.getProject() ? "default" : cubeRequest.getProject();
            ProjectInstance project = this.cubeService.getProjectManager().getProject(projectName);
            if (project == null) {
                throw new NotFoundException("Project " + projectName + " doesn't exist");
            }
            this.cubeService.createCubeAndDesc(project, desc);
        }
        catch (Exception e) {
            logger.error("Failed to deal with the request.", (Throwable)e);
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
        cubeRequest.setUuid(desc.getUuid());
        cubeRequest.setSuccessful(true);
        return cubeRequest;
    }

    private void validateColumnFamily(CubeDesc cubeDesc) {
        HashSet columnFamilyMetricsSet = Sets.newHashSet();
        for (HBaseColumnFamilyDesc hBaseColumnFamilyDesc : cubeDesc.getHbaseMapping().getColumnFamily()) {
            for (HBaseColumnDesc hBaseColumnDesc : hBaseColumnFamilyDesc.getColumns()) {
                for (String columnName : hBaseColumnDesc.getMeasureRefs()) {
                    columnFamilyMetricsSet.add(columnName);
                }
            }
        }
        for (MeasureDesc measureDesc : cubeDesc.getMeasures()) {
            if (columnFamilyMetricsSet.contains(measureDesc.getName())) continue;
            throw new BadRequestException("column family lack measure:" + measureDesc.getName());
        }
        if (cubeDesc.getMeasures().size() != columnFamilyMetricsSet.size()) {
            throw new BadRequestException("the number of input measure and the number of measure defined in cubedesc are not consistent");
        }
        for (RowKeyColDesc rowKeyColDesc : cubeDesc.getRowkey().getRowKeyColumns()) {
            String[] encodingArgs;
            Object[] encodingConf = DimensionEncoding.parseEncodingConf((String)rowKeyColDesc.getEncoding());
            String encodingName = (String)encodingConf[0];
            if (DimensionEncodingFactory.isValidEncoding((String)encodingName, (String[])(encodingArgs = (String[])encodingConf[1]), (int)rowKeyColDesc.getEncodingVersion())) continue;
            throw new BadRequestException("Illegal row key column desc: " + rowKeyColDesc);
        }
    }

    @RequestMapping(value={""}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public CubeRequest updateCubeDesc(@RequestBody CubeRequest cubeRequest) throws JsonProcessingException {
        CubeDesc desc = this.deserializeCubeDesc(cubeRequest);
        if (desc == null) {
            return cubeRequest;
        }
        String projectName = null == cubeRequest.getProject() ? "default" : cubeRequest.getProject();
        try {
            CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeRequest.getCubeName());
            if (cube == null) {
                String error = "The cube named " + cubeRequest.getCubeName() + " does not exist ";
                this.updateRequest(cubeRequest, false, error);
                return cubeRequest;
            }
            this.validateColumnFamily(desc);
            if (!cube.getDescriptor().getName().equalsIgnoreCase(desc.getName())) {
                String error = "Cube Desc renaming is not allowed: desc.getName(): " + desc.getName() + ", cubeRequest.getCubeName(): " + cubeRequest.getCubeName();
                this.updateRequest(cubeRequest, false, error);
                return cubeRequest;
            }
            if (cube.getSegments().size() != 0 && !cube.getDescriptor().consistentWith(desc)) {
                String error = "CubeDesc " + desc.getName() + " is inconsistent with existing. Try purge that cube first or avoid updating key cube desc fields.";
                this.updateRequest(cubeRequest, false, error);
                return cubeRequest;
            }
            desc = this.cubeService.updateCubeAndDesc(cube, desc, projectName, true);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new ForbiddenException("You don't have right to update this cube.");
        }
        catch (Exception e) {
            logger.error("Failed to deal with the request:" + e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException("Failed to deal with the request: " + e.getLocalizedMessage(), e);
        }
        if (desc.isBroken()) {
            this.updateRequest(cubeRequest, false, desc.getErrorsAsString());
            return cubeRequest;
        }
        String descData = JsonUtil.writeValueAsIndentString((Object)desc);
        cubeRequest.setCubeDescData(descData);
        cubeRequest.setSuccessful(true);
        return cubeRequest;
    }

    @RequestMapping(value={"/{cubeName}/hbase"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<HBaseResponse> getHBaseInfo(@PathVariable String cubeName) {
        ArrayList<HBaseResponse> hbase = new ArrayList<HBaseResponse>();
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        if (null == cube) {
            throw new InternalErrorException("Cannot find cube " + cubeName);
        }
        Segments segments = cube.getSegments();
        for (CubeSegment segment : segments) {
            String tableName = segment.getStorageLocationIdentifier();
            HBaseResponse hr = null;
            try {
                hr = this.cubeService.getHTableInfo(cubeName, tableName);
            }
            catch (IOException e) {
                logger.error("Failed to calcuate size of HTable \"" + tableName + "\".", (Throwable)e);
            }
            if (null == hr) {
                logger.info("Failed to calcuate size of HTable \"" + tableName + "\".");
                hr = new HBaseResponse();
            }
            hr.setTableName(tableName);
            hr.setDateRangeStart((Long)segment.getTSRange().start.v);
            hr.setDateRangeEnd((Long)segment.getTSRange().end.v);
            hr.setSegmentName(segment.getName());
            hr.setSegmentStatus(segment.getStatus().toString());
            hr.setSourceCount(segment.getInputRecords());
            if (segment.isOffsetCube()) {
                hr.setSourceOffsetStart((Long)segment.getSegRange().start.v);
                hr.setSourceOffsetEnd((Long)segment.getSegRange().end.v);
            }
            hbase.add(hr);
        }
        return hbase;
    }

    @RequestMapping(value={"/{cubeName}/holes"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<CubeSegment> getHoles(@PathVariable String cubeName) {
        this.checkCubeExists(cubeName);
        return this.cubeService.getCubeManager().calculateHoles(cubeName);
    }

    @RequestMapping(value={"/{cubeName}/holes"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public List<JobInstance> fillHoles(@PathVariable String cubeName) {
        this.checkCubeExists(cubeName);
        ArrayList jobs = Lists.newArrayList();
        List holes = this.cubeService.getCubeManager().calculateHoles(cubeName);
        if (holes.size() == 0) {
            logger.info("No hole detected for cube '" + cubeName + "'");
            return jobs;
        }
        for (CubeSegment hole : holes) {
            JobInstance job;
            Object request;
            if (hole.isOffsetCube()) {
                request = new JobBuildRequest2();
                ((JobBuildRequest2)request).setBuildType(CubeBuildTypeEnum.BUILD.toString());
                ((JobBuildRequest2)request).setSourceOffsetStart((Long)hole.getSegRange().start.v);
                ((JobBuildRequest2)request).setSourceOffsetEnd((Long)hole.getSegRange().end.v);
                ((JobBuildRequest2)request).setSourcePartitionOffsetStart(hole.getSourcePartitionOffsetStart());
                ((JobBuildRequest2)request).setSourcePartitionOffsetEnd(hole.getSourcePartitionOffsetEnd());
                try {
                    job = this.build2(cubeName, (JobBuildRequest2)request);
                    jobs.add(job);
                }
                catch (Exception e) {
                    logger.info("Error to submit job for hole '" + hole.toString() + "', skip it now.", (Throwable)e);
                }
                continue;
            }
            request = new JobBuildRequest();
            ((JobBuildRequest)request).setBuildType(CubeBuildTypeEnum.BUILD.toString());
            ((JobBuildRequest)request).setStartTime((Long)hole.getTSRange().start.v);
            ((JobBuildRequest)request).setEndTime((Long)hole.getTSRange().end.v);
            try {
                job = this.build(cubeName, (JobBuildRequest)request);
                jobs.add(job);
            }
            catch (Exception e) {
                logger.info("Error to submit job for hole '" + hole.toString() + "', skip it now.", (Throwable)e);
            }
        }
        return jobs;
    }

    @RequestMapping(value={"/{cubeName}/cuboids/export"}, method={RequestMethod.GET})
    @ResponseBody
    public void cuboidsExport(@PathVariable String cubeName, @RequestParam(value="top") Integer top, HttpServletResponse response) throws IOException {
        this.checkCubeExists(cubeName);
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        Map<Long, Long> cuboidList = this.getRecommendCuboidList(cube);
        LinkedList dimensionSetList = Lists.newLinkedList();
        if (cuboidList == null || cuboidList.isEmpty()) {
            logger.info("Cannot get recommended cuboid list for cube " + cubeName);
        } else {
            if (cuboidList.size() < top) {
                logger.info("Require " + top + " recommended cuboids, but only " + cuboidList.size() + " is found.");
            }
            Iterator<Long> cuboidIterator = cuboidList.keySet().iterator();
            RowKeyColDesc[] rowKeyColDescList = cube.getDescriptor().getRowkey().getRowKeyColumns();
            block11: while (true) {
                Integer n = top;
                Integer n2 = top = Integer.valueOf(top - 1);
                if (n <= 0 || !cuboidIterator.hasNext()) break;
                HashSet dimensionSet = Sets.newHashSet();
                dimensionSetList.add(dimensionSet);
                long cuboid = cuboidIterator.next();
                int i = 0;
                while (true) {
                    if (i >= rowKeyColDescList.length) continue block11;
                    if ((cuboid & 1L << rowKeyColDescList[i].getBitIndex()) > 0L) {
                        dimensionSet.add(rowKeyColDescList[i].getColumn());
                    }
                    ++i;
                }
                break;
            }
        }
        response.setContentType("text/json;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + cubeName + ".json\"");
        try (PrintWriter writer = response.getWriter();){
            writer.write(JsonUtil.writeValueAsString((Object)dimensionSetList));
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            throw new InternalErrorException("Failed to write: " + e.getLocalizedMessage(), e);
        }
    }

    @RequestMapping(value={"/{cubeName}/cuboids/current"}, method={RequestMethod.GET})
    @ResponseBody
    public CuboidTreeResponse getCurrentCuboids(@PathVariable String cubeName) {
        this.checkCubeExists(cubeName);
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        CuboidScheduler cuboidScheduler = cube.getCuboidScheduler();
        Map cuboidStatsMap = cube.getCuboids();
        if (cuboidStatsMap == null) {
            cuboidStatsMap = CuboidStatsReaderUtil.readCuboidStatsFromCube((Set)cuboidScheduler.getAllCuboidIds(), (CubeInstance)cube);
        }
        Map<Long, Long> hitFrequencyMap = null;
        Map<Long, Long> queryMatchMap = null;
        try {
            hitFrequencyMap = this.getTargetCuboidHitFrequency(cubeName);
            queryMatchMap = this.cubeService.getCuboidQueryMatchCount(cubeName);
        }
        catch (Exception e) {
            logger.warn("Fail to query on system cube due to " + e);
        }
        Set currentCuboidSet = cube.getCuboidScheduler().getAllCuboidIds();
        return this.cubeService.getCuboidTreeResponse(cuboidScheduler, cuboidStatsMap, hitFrequencyMap, queryMatchMap, currentCuboidSet);
    }

    @RequestMapping(value={"/{cubeName}/cuboids/recommend"}, method={RequestMethod.GET})
    @ResponseBody
    public CuboidTreeResponse getRecommendCuboids(@PathVariable String cubeName) throws IOException {
        this.checkCubeExists(cubeName);
        CubeInstance cube = this.cubeService.getCubeManager().getCube(cubeName);
        Map<Long, Long> recommendCuboidStatsMap = this.getRecommendCuboidList(cube);
        if (recommendCuboidStatsMap == null || recommendCuboidStatsMap.isEmpty()) {
            return new CuboidTreeResponse();
        }
        TreeCuboidScheduler cuboidScheduler = new TreeCuboidScheduler(cube.getDescriptor(), (List)Lists.newArrayList(recommendCuboidStatsMap.keySet()), (Comparator)new TreeCuboidScheduler.CuboidCostComparator(recommendCuboidStatsMap));
        Map<Long, Long> displayHitFrequencyMap = this.getTargetCuboidHitFrequency(cubeName);
        Map<Long, Long> queryMatchMap = this.cubeService.getCuboidQueryMatchCount(cubeName);
        Set currentCuboidSet = cube.getCuboidScheduler().getAllCuboidIds();
        return this.cubeService.getCuboidTreeResponse((CuboidScheduler)cuboidScheduler, recommendCuboidStatsMap, displayHitFrequencyMap, queryMatchMap, currentCuboidSet);
    }

    private Map<Long, Long> getRecommendCuboidList(CubeInstance cube) throws IOException {
        Map<Long, Long> optimizeHitFrequencyMap = this.getSourceCuboidHitFrequency(cube.getName());
        Map<Long, Map<Long, Pair<Long, Long>>> rollingUpCountSourceMap = this.cubeService.getCuboidRollingUpStats(cube.getName());
        return this.cubeService.getRecommendCuboidStatistics(cube, optimizeHitFrequencyMap, rollingUpCountSourceMap);
    }

    private Map<Long, Long> getSourceCuboidHitFrequency(String cubeName) {
        return this.cubeService.getCuboidHitFrequency(cubeName, true);
    }

    private Map<Long, Long> getTargetCuboidHitFrequency(String cubeName) {
        return this.cubeService.getCuboidHitFrequency(cubeName, false);
    }

    @RequestMapping(value={"/{cubeName}/init_start_offsets"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public GeneralResponse initStartOffsets(@PathVariable String cubeName) {
        this.checkCubeExists(cubeName);
        CubeInstance cubeInstance = this.cubeService.getCubeManager().getCube(cubeName);
        if (cubeInstance.getSourceType() != 1) {
            String msg = "Cube '" + cubeName + "' is not a Streaming Cube.";
            throw new IllegalArgumentException(msg);
        }
        GeneralResponse response = new GeneralResponse();
        try {
            Map startOffsets = KafkaClient.getLatestOffsets((CubeInstance)cubeInstance);
            CubeDesc desc = cubeInstance.getDescriptor();
            desc.setPartitionOffsetStart(startOffsets);
            this.cubeService.getCubeDescManager().updateCubeDesc(desc);
            response.setProperty("result", "success");
            response.setProperty("offsets", startOffsets.toString());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    private CubeDesc deserializeCubeDesc(CubeRequest cubeRequest) {
        CubeDesc desc = null;
        try {
            logger.debug("Saving cube " + cubeRequest.getCubeDescData());
            desc = (CubeDesc)JsonUtil.readValue((String)cubeRequest.getCubeDescData(), CubeDesc.class);
        }
        catch (JsonParseException e) {
            logger.error("The cube definition is not valid.", (Throwable)e);
            this.updateRequest(cubeRequest, false, e.getMessage());
        }
        catch (JsonMappingException e) {
            logger.error("The cube definition is not valid.", (Throwable)e);
            this.updateRequest(cubeRequest, false, e.getMessage());
        }
        catch (IOException e) {
            logger.error("Failed to deal with the request.", (Throwable)e);
            throw new InternalErrorException("Failed to deal with the request:" + e.getMessage(), e);
        }
        return desc;
    }

    private void updateRequest(CubeRequest request, boolean success, String message) {
        request.setCubeDescData("");
        request.setSuccessful(success);
        request.setMessage(message);
    }

    private void checkCubeExists(String cubeName) {
        CubeInstance cubeInstance = this.cubeService.getCubeManager().getCube(cubeName);
        if (cubeInstance == null) {
            Message msg = MsgPicker.getMsg();
            throw new NotFoundException(String.format(Locale.ROOT, msg.getCUBE_NOT_FOUND(), cubeName));
        }
    }

    private void checkBuildingSegment(CubeInstance cube) {
        this.checkBuildingSegment(cube, cube.getConfig().getMaxBuildingSegments());
    }

    private void checkBuildingSegment(CubeInstance cube, int maxBuildingSeg) {
        if (cube.getBuildingSegments().size() >= maxBuildingSeg) {
            throw new TooManyRequestException("There is already " + cube.getBuildingSegments().size() + " building segment; ");
        }
    }

    @RequestMapping(value={"/{cube}/{project}/migrate"}, method={RequestMethod.POST})
    @ResponseBody
    public void migrateCube(@PathVariable String cube, @PathVariable String project) {
        CubeInstance cubeInstance = this.cubeService.getCubeManager().getCube(cube);
        this.cubeService.migrateCube(cubeInstance, project);
    }

    public void setCubeService(CubeService cubeService) {
        this.cubeService = cubeService;
    }

    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }
}

